execute as @n[tag=Pets.Owner] at @s run playsound entity.player.levelup master @s ~ ~ ~ 1 1.5

# --------------------------------------------------------------------------------- #

# Store the level before math calculation to detect if leveling actually occurred
scoreboard players operation #previous_level Pets.EXP = #current_level Pets.EXP

function pets:handler/math/level_up

# If no level change occurred, exit early
execute if score #previous_level Pets.EXP = #current_level Pets.EXP run return fail

execute if score #current_level Pets.EXP matches 101.. run scoreboard players set #current_level Pets.EXP 100

# Max level achievement
execute as @n[tag=Pets.Owner] at @s if score #current_level Pets.EXP matches 100 run playsound ui.toast.challenge_complete master @s ~ ~ ~ 1 1.2
execute if score #current_level Pets.EXP matches 100 run advancement grant @p[tag=Pets.Owner] from pets:divine_beast_tamer

# --------------------------------------------------------------------------------- #

# Empty name check
data modify storage pets leveling.display_name set from entity @s item.components."minecraft:profile".properties[1].value
execute if data storage pets leveling{display_name:""} run return run tellraw @p[tag=Pets.Owner] "something went wrong..."

tellraw @p[tag=Pets.Owner] [{"text":"- Your ", "color":"green"},{"nbt":"leveling.display_name", "storage":"pets", "color":"aqua"},{"text":" has reached level "},{"score":{"objective":"Pets.EXP","name":"#current_level"}, "color":"aqua"},{"text":"."}]

# Update the pet's level and name
execute store result storage pets leveling.level int 1 run scoreboard players get #current_level Pets.EXP
data modify entity @s item.components."minecraft:profile".properties[2].value set string storage pets leveling.level

# Get the color for the pet's name
scoreboard players set #color Pets.Calc 0
data modify storage pets leveling.color set value ''
function pets:handler/math/get_color

function pets:handler/active_pet/leveling/update_pet with storage pets leveling


data modify entity @s item.components."minecraft:custom_name" set from entity @s CustomName

# --------------------------------------------------------------------------------- #

# Update the pet's lore (if scalable by level)
execute if data entity @s item.components."minecraft:profile".properties[{value:"Ant"}] run return run function pets:handler/active_pet/lore/ant
execute if data entity @s item.components."minecraft:profile".properties[{value:"Axolotl"}] run return run function pets:handler/active_pet/lore/axolotl
execute if data entity @s item.components."minecraft:profile".properties[{value:"Blue Dragon"}] run return run function pets:handler/active_pet/lore/blue_dragon
execute if data entity @s item.components."minecraft:profile".properties[{value:"Cat"}] run return run function pets:handler/active_pet/lore/cat
execute if data entity @s item.components."minecraft:profile".properties[{value:"Chicken"}] run return run function pets:handler/active_pet/lore/chicken
execute if data entity @s item.components."minecraft:profile".properties[{value:"Dog"}] run return run function pets:handler/active_pet/lore/dog
execute if data entity @s item.components."minecraft:profile".properties[{value:"Dolphin"}] run return run function pets:handler/active_pet/lore/dolphin
execute if data entity @s item.components."minecraft:profile".properties[{value:"Elder Guardian"}] run return run function pets:handler/active_pet/lore/elder_guardian
execute if data entity @s item.components."minecraft:profile".properties[{value:"Ghast"}] run return run function pets:handler/active_pet/lore/ghast
execute if data entity @s item.components."minecraft:profile".properties[{value:"Hamster"}] run return run function pets:handler/active_pet/lore/hamster
execute if data entity @s item.components."minecraft:profile".properties[{value:"Herobrine"}] run return run function pets:handler/active_pet/lore/herobrine
execute if data entity @s item.components."minecraft:profile".properties[{value:"Owl"}] run return run function pets:handler/active_pet/lore/owl
execute if data entity @s item.components."minecraft:profile".properties[{value:"Panda"}] run return run function pets:handler/active_pet/lore/panda
execute if data entity @s item.components."minecraft:profile".properties[{value:"Penguin"}] run return run function pets:handler/active_pet/lore/penguin
execute if data entity @s item.components."minecraft:profile".properties[{value:"Red Dragon"}] run return run function pets:handler/active_pet/lore/red_dragon
execute if data entity @s item.components."minecraft:profile".properties[{value:"Red Parrot"}] run return run function pets:handler/active_pet/lore/red_parrot
execute if data entity @s item.components."minecraft:profile".properties[{value:"Phoenix"}] run return run function pets:handler/active_pet/lore/phoenix
execute if data entity @s item.components."minecraft:profile".properties[{value:"Pufferfish"}] run return run function pets:handler/active_pet/lore/pufferfish
execute if data entity @s item.components."minecraft:profile".properties[{value:"Rabbit"}] run return run function pets:handler/active_pet/lore/rabbit
execute if data entity @s item.components."minecraft:profile".properties[{value:"Reaper"}] run return run function pets:handler/active_pet/lore/reaper
execute if data entity @s item.components."minecraft:profile".properties[{value:"Snail"}] run return run function pets:handler/active_pet/lore/snail
execute if data entity @s item.components."minecraft:profile".properties[{value:"Spinosaurus"}] run return run function pets:handler/active_pet/lore/spinosaurus
execute if data entity @s item.components."minecraft:profile".properties[{value:"Tiger"}] run return run function pets:handler/active_pet/lore/tiger
execute if data entity @s item.components."minecraft:profile".properties[{value:"Turtle"}] run return run function pets:handler/active_pet/lore/turtle
execute if data entity @s item.components."minecraft:profile".properties[{value:"Warden"}] run return run function pets:handler/active_pet/lore/warden
execute if data entity @s item.components."minecraft:profile".properties[{value:"Worm"}] run return run function pets:handler/active_pet/lore/worm