/*
 * Decompiled with CFR 0.152.
 */
package com.heledron.sky_torch.laser;

import com.heledron.sky_torch.AppState;
import com.heledron.sky_torch.GameObject;
import com.heledron.sky_torch.laser.BlindingEffectKt;
import com.heledron.sky_torch.laser.BlindingEffectOptions;
import com.heledron.sky_torch.utilities.EntityRendererKt;
import com.heledron.sky_torch.utilities.MultiModelRenderer;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/heledron/sky_torch/laser/BlindEffect;", "Lcom/heledron/sky_torch/GameObject;", "players", "", "Lorg/bukkit/entity/Player;", "options", "Lcom/heledron/sky_torch/laser/BlindingEffectOptions;", "<init>", "(Ljava/util/List;Lcom/heledron/sky_torch/laser/BlindingEffectOptions;)V", "getOptions", "()Lcom/heledron/sky_torch/laser/BlindingEffectOptions;", "age", "", "update", "", "render", "sky-torch"})
public final class BlindEffect
extends GameObject {
    @NotNull
    private final List<Player> players;
    @NotNull
    private final BlindingEffectOptions options;
    private int age;

    public BlindEffect(@NotNull List<? extends Player> players, @NotNull BlindingEffectOptions options) {
        Intrinsics.checkNotNullParameter(players, "players");
        Intrinsics.checkNotNullParameter(options, "options");
        this.players = players;
        this.options = options;
    }

    @NotNull
    public final BlindingEffectOptions getOptions() {
        return this.options;
    }

    @Override
    public void update() {
        int n = this.age;
        this.age = n + 1;
        if (this.age > this.options.getFadeInDuration() + this.options.getDuration() + this.options.getFadeOutDuration()) {
            this.remove();
        }
    }

    @Override
    public void render() {
        double opacity;
        if (!this.options.getEnabled()) {
            return;
        }
        double d = this.age < this.options.getFadeInDuration() ? (double)this.age / (double)this.options.getFadeInDuration() : (opacity = this.age < this.options.getFadeInDuration() + this.options.getDuration() ? 1.0 : 1.0 - (double)(this.age - this.options.getFadeInDuration() - this.options.getDuration()) / (double)this.options.getFadeOutDuration());
        if (opacity <= 0.0) {
            return;
        }
        Color color = this.options.getColor().setAlpha((int)((double)this.options.getColor().getAlpha() * opacity));
        Intrinsics.checkNotNullExpressionValue(color, "setAlpha(...)");
        Color color2 = color;
        for (Player player : this.players) {
            Iterator iterator2 = ((Iterable)BlindingEffectKt.access$getTransforms$p()).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                Matrix4f transform = (Matrix4f)iterator2.next();
                MultiModelRenderer multiModelRenderer = AppState.INSTANCE.getRenderer();
                Pair<Pair<BlindEffect, Player>, Integer> pair = TuplesKt.to(TuplesKt.to(this, player), i);
                Location location = player.getEyeLocation().toVector().toLocation(player.getWorld());
                Intrinsics.checkNotNullExpressionValue(location, "toLocation(...)");
                multiModelRenderer.render(pair, EntityRendererKt.textModel(location, arg_0 -> BlindEffect.render$lambda$0(transform, arg_0), arg_0 -> BlindEffect.render$lambda$1(color2, arg_0)));
            }
        }
    }

    private static final Unit render$lambda$0(Matrix4f $transform, TextDisplay it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.setText(" ");
        it.setBrightness(new Display.Brightness(15, 15));
        it.setTeleportDuration(1);
        it.setTransformationMatrix($transform);
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$1(Color $color, TextDisplay it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.setBackgroundColor($color);
        return Unit.INSTANCE;
    }
}

