/*
 * Decompiled with CFR 0.152.
 */
package com.heledron.sky_torch.laser;

import com.heledron.sky_torch.laser.BurnWaveOptions;
import com.heledron.sky_torch.laser.BurnWavePlacement;
import com.heledron.sky_torch.laser.Burner;
import com.heledron.sky_torch.laser.Cloud;
import com.heledron.sky_torch.utilities.MathsKt;
import com.heledron.sky_torch.utilities.SchedulingKt;
import com.heledron.sky_torch.utilities.UtilitiesKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a0\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"spawnBurnWave", "", "placement", "Lcom/heledron/sky_torch/laser/BurnWavePlacement;", "options", "Lcom/heledron/sky_torch/laser/BurnWaveOptions;", "burn", "Lcom/heledron/sky_torch/laser/Burner;", "spawnBurnCloud", "Lcom/heledron/sky_torch/laser/Cloud;", "x", "", "y", "sky-torch"})
public final class BurnWaveKt {
    public static final void spawnBurnWave(@NotNull BurnWavePlacement placement, @NotNull BurnWaveOptions options, @NotNull Burner burn) {
        double y;
        double x;
        Intrinsics.checkNotNullParameter(placement, "placement");
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(burn, "burn");
        for (Pair<Double, Double> pair : UtilitiesKt.ring(options.getCount())) {
            x = ((Number)pair.component1()).doubleValue();
            y = ((Number)pair.component2()).doubleValue();
            BurnWaveKt.spawnBurnCloud(placement, options, burn, x, y);
        }
        for (Pair<Double, Double> pair : UtilitiesKt.ring(options.getDelayedCount())) {
            x = ((Number)pair.component1()).doubleValue();
            y = ((Number)pair.component2()).doubleValue();
            SchedulingKt.runLater(Random.Default.nextLong(options.getMaxSpawnDelay() / (long)options.getSpawnRandomInterval()) * (long)options.getSpawnRandomInterval(), () -> BurnWaveKt.spawnBurnWave$lambda$0(placement, options, burn, x, y));
        }
    }

    private static final Cloud spawnBurnCloud(BurnWavePlacement placement, BurnWaveOptions options, Burner burn, double x, double y) {
        Location location = placement.getOrigin().toLocation(placement.getWorld());
        Intrinsics.checkNotNullExpressionValue(location, "toLocation(...)");
        Object object = location;
        Vector vector = new Vector(x, 0.1, y).normalize().multiply(Random.Default.nextDouble(options.getSpeedMin(), options.getSpeedMax()));
        Intrinsics.checkNotNullExpressionValue(vector, "multiply(...)");
        Vector vector2 = vector;
        double d = options.getSize();
        double d2 = options.getGrowth();
        int n = Random.Default.nextInt(options.getDurationMin(), options.getDurationMax());
        List list = (List)CollectionsKt.random((Collection)options.getPalette().getBurn().getBurnWave(), Random.Default);
        Location location2 = placement.getRender().toLocation(placement.getWorld());
        Intrinsics.checkNotNullExpressionValue(location2, "toLocation(...)");
        Location location3 = location2;
        Object $this$spawnBurnCloud_u24lambda_u243 = object = new Cloud((Location)object, location3, vector2, d, d2, n, list);
        boolean bl = false;
        ((Cloud)$this$spawnBurnCloud_u24lambda_u243).setOnUpdate(() -> BurnWaveKt.spawnBurnCloud$lambda$3$lambda$2((Cloud)$this$spawnBurnCloud_u24lambda_u243, options, burn));
        return object;
    }

    private static final Unit spawnBurnWave$lambda$0(BurnWavePlacement $placement, BurnWaveOptions $options, Burner $burn, double $x, double $y) {
        BurnWaveKt.spawnBurnCloud($placement, $options, $burn, $x, $y);
        return Unit.INSTANCE;
    }

    private static final Unit spawnBurnCloud$lambda$3$lambda$2(Cloud $this_apply, BurnWaveOptions $options, Burner $burn) {
        RayTraceResult rayTraceResult;
        block7: {
            block6: {
                $this_apply.getVelocity().multiply(1.0 - $options.getAirDragCoefficient());
                if (!$this_apply.getLocation().getBlock().getChunk().isLoaded()) {
                    return Unit.INSTANCE;
                }
                double scanUpwards = $this_apply.getSize() / (double)2 + $options.getScanUpwards();
                double scanDownwards = $this_apply.getSize() / (double)2 + $options.getScanDownwards();
                Location location = $this_apply.getLocation().clone().add(0.0, scanUpwards, 0.0);
                Intrinsics.checkNotNullExpressionValue(location, "add(...)");
                Location top = location;
                rayTraceResult = UtilitiesKt.raycastGround(top, new Vector(0, -1, 0), scanUpwards + scanDownwards);
                if (rayTraceResult == null || (rayTraceResult = rayTraceResult.getHitPosition()) == null) break block6;
                World world = $this_apply.getLocation().getWorld();
                Intrinsics.checkNotNull(world);
                if ((rayTraceResult = rayTraceResult.toLocation(world)) != null) break block7;
            }
            Location location = $this_apply.getLocation().clone();
            rayTraceResult = location;
            Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
        }
        RayTraceResult ground = rayTraceResult;
        if ($this_apply.getLocation().getBlock().getType().isOccluding()) {
            $this_apply.getLocation().setY(MathsKt.lerp($this_apply.getLocation().getY(), ground.getY() + $this_apply.getSize() / (double)2, 0.03));
        }
        double burnHeight = RangesKt.coerceAtLeast($this_apply.getSize() * 0.7, 5.0);
        double burnAmount = RangesKt.coerceAtLeast($this_apply.getSize(), 1.0) * (double)$options.getBurnBlocks();
        int n = (int)burnAmount;
        for (int i = 0; i < n; ++i) {
            Block block;
            int it = i;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(ground.clone().getBlock().getRelative(Random.Default.nextInt(-3, 3), (int)Random.Default.nextDouble(-burnHeight, burnHeight), Random.Default.nextInt(-3, 3)), "getRelative(...)");
            if (!block.getChunk().isLoaded()) continue;
            float heat = $options.getDisableHeat() ? 0.5f : 1.0f - (float)$this_apply.getAge() / (float)$this_apply.getMaxAge();
            $burn.burn(block, $this_apply.getRenderLocation(), heat);
        }
        return Unit.INSTANCE;
    }
}

