/*
 * Decompiled with CFR 0.152.
 */
package com.heledron.sky_torch.laser;

import com.heledron.sky_torch.laser.BurnOptions;
import com.heledron.sky_torch.laser.BurnPalette;
import com.heledron.sky_torch.laser.BurnerKt;
import com.heledron.sky_torch.utilities.SchedulingKt;
import com.heledron.sky_torch.utilities.SeriesScheduler;
import com.heledron.sky_torch.utilities.SetBlockUndoKt;
import java.io.Closeable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R&\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lcom/heledron/sky_torch/laser/Burner;", "Ljava/io/Closeable;", "options", "Lcom/heledron/sky_torch/laser/BurnOptions;", "<init>", "(Lcom/heledron/sky_torch/laser/BurnOptions;)V", "getOptions", "()Lcom/heledron/sky_torch/laser/BurnOptions;", "isClosed", "", "()Z", "setClosed", "(Z)V", "visited", "", "Lorg/bukkit/block/Block;", "getVisited", "()Ljava/util/Set;", "burning", "", "Lorg/bukkit/Material;", "getBurning", "()Ljava/util/Map;", "setBurning", "(Ljava/util/Map;)V", "close", "", "burn", "block", "renderLocation", "Lorg/bukkit/Location;", "heat", "", "isOccluded", "sky-torch"})
public final class Burner
implements Closeable {
    @NotNull
    private final BurnOptions options;
    private boolean isClosed;
    @NotNull
    private final Set<Block> visited;
    @NotNull
    private Map<Block, Material> burning;

    public Burner(@NotNull BurnOptions options) {
        Intrinsics.checkNotNullParameter(options, "options");
        this.options = options;
        this.visited = new LinkedHashSet();
        this.burning = new LinkedHashMap();
    }

    @NotNull
    public final BurnOptions getOptions() {
        return this.options;
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    public final void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    @NotNull
    public final Set<Block> getVisited() {
        return this.visited;
    }

    @NotNull
    public final Map<Block, Material> getBurning() {
        return this.burning;
    }

    public final void setBurning(@NotNull Map<Block, Material> map) {
        Intrinsics.checkNotNullParameter(map, "<set-?>");
        this.burning = map;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public final void burn(@NotNull Block block, @NotNull Location renderLocation, float heat) {
        Intrinsics.checkNotNullParameter(block, "block");
        Intrinsics.checkNotNullParameter(renderLocation, "renderLocation");
        BurnPalette palette = this.options.getPalette().getBurn();
        if (this.isOccluded(block)) {
            return;
        }
        if (this.visited.contains(block)) {
            return;
        }
        ((Collection)this.visited).add(block);
        if (this.options.getDisabled()) {
            return;
        }
        if (block.isLiquid() || BurnerKt.hasWater(block)) {
            return;
        }
        Block block2 = block.getRelative(0, -1, 0);
        Intrinsics.checkNotNullExpressionValue(block2, "getRelative(...)");
        Block blockBelow = block2;
        if (block.getType().isAir() && BurnerKt.access$canPlaceFireOn(blockBelow)) {
            if ((double)Random.Default.nextFloat() > this.options.getSetFireChance()) {
                return;
            }
            SetBlockUndoKt.setBlock(block, (Material)CollectionsKt.random((Collection)palette.getFirePalette(), Random.Default));
            SchedulingKt.runLater(200L, () -> Burner.burn$lambda$0(this, blockBelow, block));
            return;
        }
        if (block.getType().isAir()) {
            return;
        }
        List<Pair<Long, BlockData>> list = palette.burn(block, heat);
        if (list == null) {
            return;
        }
        List<Pair<Long, BlockData>> burnPalette = list;
        SeriesScheduler series = new SeriesScheduler();
        this.burning.put(block, block.getType());
        for (Pair<Long, BlockData> pair : burnPalette) {
            long delay = ((Number)pair.component1()).longValue();
            BlockData data = pair.component2();
            series.sleep(delay);
            series.run(() -> Burner.burn$lambda$1(this, block, data));
        }
        if ((double)Random.Default.nextFloat() < this.options.getSpawnSmokeChance()) {
            Location location = block.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            BurnerKt.spawnSmokeCloud(location, renderLocation, palette);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isOccluded(Block block) {
        Block block2 = block.getRelative(0, 1, 0);
        Intrinsics.checkNotNullExpressionValue(block2, "getRelative(...)");
        if (!Burner.isOccluded$isOccluding(this, block2)) return false;
        Block block3 = block.getRelative(0, -1, 0);
        Intrinsics.checkNotNullExpressionValue(block3, "getRelative(...)");
        if (!Burner.isOccluded$isOccluding(this, block3)) return false;
        Block block4 = block.getRelative(1, 0, 0);
        Intrinsics.checkNotNullExpressionValue(block4, "getRelative(...)");
        if (!Burner.isOccluded$isOccluding(this, block4)) return false;
        Block block5 = block.getRelative(-1, 0, 0);
        Intrinsics.checkNotNullExpressionValue(block5, "getRelative(...)");
        if (!Burner.isOccluded$isOccluding(this, block5)) return false;
        Block block6 = block.getRelative(0, 0, 1);
        Intrinsics.checkNotNullExpressionValue(block6, "getRelative(...)");
        if (!Burner.isOccluded$isOccluding(this, block6)) return false;
        Block block7 = block.getRelative(0, 0, -1);
        Intrinsics.checkNotNullExpressionValue(block7, "getRelative(...)");
        if (!Burner.isOccluded$isOccluding(this, block7)) return false;
        return true;
    }

    private static final Unit burn$lambda$0(Burner this$0, Block $blockBelow, Block $block) {
        if (this$0.isClosed) {
            return Unit.INSTANCE;
        }
        if (!BurnerKt.access$canPlaceFireOn($blockBelow)) {
            SetBlockUndoKt.setBlock($block, Material.AIR);
        }
        return Unit.INSTANCE;
    }

    private static final Unit burn$lambda$1(Burner this$0, Block $block, BlockData $data) {
        if (this$0.isClosed) {
            return Unit.INSTANCE;
        }
        if ($block.getType().isAir()) {
            return Unit.INSTANCE;
        }
        SetBlockUndoKt.setBlock($block, $data);
        return Unit.INSTANCE;
    }

    private static final boolean isOccluded$isOccluding(Burner this$0, Block block) {
        Material material = this$0.burning.get(block);
        if (material == null) {
            material = block.getType();
        }
        return material.isOccluding();
    }
}

