/*
 * Decompiled with CFR 0.152.
 */
package com.heledron.sky_torch.laser;

import com.heledron.sky_torch.AppState;
import com.heledron.sky_torch.GameObject;
import com.heledron.sky_torch.utilities.EntityRendererKt;
import com.heledron.sky_torch.utilities.ModelPart;
import com.heledron.sky_torch.utilities.SchedulingKt;
import com.heledron.sky_torch.utilities.UtilitiesKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u00109\u001a\u000204H\u0016J\b\u0010:\u001a\u000204H\u0016J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u001a\u0010,\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010&\"\u0004\b.\u0010(R\u001a\u0010/\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010&\"\u0004\b1\u0010(R \u00102\u001a\b\u0012\u0004\u0012\u00020403X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108\u00a8\u0006>"}, d2={"Lcom/heledron/sky_torch/laser/Cloud;", "Lcom/heledron/sky_torch/GameObject;", "location", "Lorg/bukkit/Location;", "renderLocation", "velocity", "Lorg/bukkit/util/Vector;", "size", "", "growth", "maxAge", "", "blocks", "", "Lorg/bukkit/block/data/BlockData;", "<init>", "(Lorg/bukkit/Location;Lorg/bukkit/Location;Lorg/bukkit/util/Vector;DDILjava/util/List;)V", "getLocation", "()Lorg/bukkit/Location;", "getRenderLocation", "getVelocity", "()Lorg/bukkit/util/Vector;", "getSize", "()D", "setSize", "(D)V", "getGrowth", "getMaxAge", "()I", "getBlocks", "()Ljava/util/List;", "age", "getAge", "setAge", "(I)V", "pitch", "", "getPitch", "()F", "setPitch", "(F)V", "yaw", "getYaw", "setYaw", "pitchVelocity", "getPitchVelocity", "setPitchVelocity", "yawVelocity", "getYawVelocity", "setYawVelocity", "onUpdate", "Lkotlin/Function0;", "", "getOnUpdate", "()Lkotlin/jvm/functions/Function0;", "setOnUpdate", "(Lkotlin/jvm/functions/Function0;)V", "update", "render", "getModel", "Lcom/heledron/sky_torch/utilities/ModelPart;", "Lorg/bukkit/entity/BlockDisplay;", "sky-torch"})
public final class Cloud
extends GameObject {
    @NotNull
    private final Location location;
    @NotNull
    private final Location renderLocation;
    @NotNull
    private final Vector velocity;
    private double size;
    private final double growth;
    private final int maxAge;
    @NotNull
    private final List<BlockData> blocks;
    private int age;
    private float pitch;
    private float yaw;
    private float pitchVelocity;
    private float yawVelocity;
    @NotNull
    private Function0<Unit> onUpdate;

    public Cloud(@NotNull Location location, @NotNull Location renderLocation, @NotNull Vector velocity, double size, double growth, int maxAge, @NotNull List<? extends BlockData> blocks) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(renderLocation, "renderLocation");
        Intrinsics.checkNotNullParameter(velocity, "velocity");
        Intrinsics.checkNotNullParameter(blocks, "blocks");
        this.location = location;
        this.renderLocation = renderLocation;
        this.velocity = velocity;
        this.size = size;
        this.growth = growth;
        this.maxAge = maxAge;
        this.blocks = blocks;
        this.pitch = Random.Default.nextFloat() * 360.0f;
        this.yaw = Random.Default.nextFloat() * 360.0f;
        this.pitchVelocity = Random.Default.nextFloat() * 0.01f;
        this.yawVelocity = Random.Default.nextFloat() * 0.01f;
        this.onUpdate = Cloud::onUpdate$lambda$0;
        SchedulingKt.runLater(this.maxAge, () -> Cloud._init_$lambda$1(this));
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    @NotNull
    public final Location getRenderLocation() {
        return this.renderLocation;
    }

    @NotNull
    public final Vector getVelocity() {
        return this.velocity;
    }

    public final double getSize() {
        return this.size;
    }

    public final void setSize(double d) {
        this.size = d;
    }

    public final double getGrowth() {
        return this.growth;
    }

    public final int getMaxAge() {
        return this.maxAge;
    }

    @NotNull
    public final List<BlockData> getBlocks() {
        return this.blocks;
    }

    public final int getAge() {
        return this.age;
    }

    public final void setAge(int n) {
        this.age = n;
    }

    public final float getPitch() {
        return this.pitch;
    }

    public final void setPitch(float f) {
        this.pitch = f;
    }

    public final float getYaw() {
        return this.yaw;
    }

    public final void setYaw(float f) {
        this.yaw = f;
    }

    public final float getPitchVelocity() {
        return this.pitchVelocity;
    }

    public final void setPitchVelocity(float f) {
        this.pitchVelocity = f;
    }

    public final float getYawVelocity() {
        return this.yawVelocity;
    }

    public final void setYawVelocity(float f) {
        this.yawVelocity = f;
    }

    @NotNull
    public final Function0<Unit> getOnUpdate() {
        return this.onUpdate;
    }

    public final void setOnUpdate(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, "<set-?>");
        this.onUpdate = function0;
    }

    @Override
    public void update() {
        this.onUpdate.invoke();
        this.size += this.growth;
        this.location.add(this.velocity);
        this.pitch += this.pitchVelocity;
        this.yaw += this.yawVelocity;
        ++this.age;
    }

    @Override
    public void render() {
        AppState.INSTANCE.getRenderer().render((Object)this, this.getModel());
    }

    private final ModelPart<BlockDisplay> getModel() {
        return EntityRendererKt.blockModel(this.renderLocation, Cloud::getModel$lambda$2, arg_0 -> Cloud.getModel$lambda$3(this, arg_0));
    }

    private static final Unit onUpdate$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(Cloud this$0) {
        this$0.remove();
        return Unit.INSTANCE;
    }

    private static final Unit getModel$lambda$2(BlockDisplay it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.setBrightness(new Display.Brightness(15, 15));
        it.setTeleportDuration(1);
        it.setInterpolationDuration(1);
        return Unit.INSTANCE;
    }

    private static final Unit getModel$lambda$3(Cloud this$0, BlockDisplay it) {
        Intrinsics.checkNotNullParameter(it, "it");
        int index = RangesKt.coerceAtMost((int)((float)this$0.age / (float)this$0.maxAge * (float)this$0.blocks.size()), this$0.blocks.size() - 1);
        Vector vector = this$0.location.toVector().subtract(this$0.renderLocation.toVector());
        Intrinsics.checkNotNullExpressionValue(vector, "subtract(...)");
        Vector diff = vector;
        it.setBlock(this$0.blocks.get(index));
        float finalSize = (float)this$0.size;
        Matrix4f matrix = new Matrix4f().translate((float)diff.getX(), (float)diff.getY(), (float)diff.getZ()).rotateXYZ(this$0.pitch, this$0.yaw, 0.0f).translate(-finalSize / (float)2, -finalSize / (float)2, 0.0f).scale(finalSize, finalSize, finalSize);
        Intrinsics.checkNotNull(matrix);
        UtilitiesKt.applyTransformationWithInterpolation(it, matrix);
        return Unit.INSTANCE;
    }
}

