/*
 * Decompiled with CFR 0.152.
 */
package com.heledron.sky_torch.laser;

import com.heledron.sky_torch.AppState;
import com.heledron.sky_torch.laser.Burner;
import com.heledron.sky_torch.laser.FlashBurnOptions;
import com.heledron.sky_torch.laser.FlashBurnPlacement;
import com.heledron.sky_torch.utilities.EntityRendererKt;
import com.heledron.sky_torch.utilities.MultiModelRenderer;
import com.heledron.sky_torch.utilities.SchedulingKt;
import com.heledron.sky_torch.utilities.UtilitiesKt;
import java.io.Closeable;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0002\u001a*\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u0014"}, d2={"flashBurn", "", "placement", "Lcom/heledron/sky_torch/laser/FlashBurnPlacement;", "options", "Lcom/heledron/sky_torch/laser/FlashBurnOptions;", "burner", "Lcom/heledron/sky_torch/laser/Burner;", "sphereRays", "", "Lorg/bukkit/util/Vector;", "horizontalCount", "", "vertMinAngle", "", "vertMaxAngle", "vertCount", "spawnDebugGraphics", "direction", "hit", "sky-torch"})
public final class FlashBurnKt {
    public static final void flashBurn(@NotNull FlashBurnPlacement placement, @NotNull FlashBurnOptions options, @NotNull Burner burner) {
        Iterator<Vector> rays;
        Intrinsics.checkNotNullParameter(placement, "placement");
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(burner, "burner");
        int n = options.getHorizontalCount();
        int n2 = options.getVerticalCount();
        double d = options.getVerticalMinAngle();
        double d2 = options.getVerticalMaxAngle();
        Iterator<Vector> iterator2 = rays = FlashBurnKt.sphereRays(n, d, d2, n2);
        block0: while (iterator2.hasNext()) {
            int area;
            int x;
            Location hit;
            Vector direction = iterator2.next();
            Location location = placement.getOrigin().toLocation(placement.getWorld());
            Intrinsics.checkNotNullExpressionValue(location, "toLocation(...)");
            RayTraceResult rayTraceResult = UtilitiesKt.raycastGround(location, direction, options.getRayDistance());
            Location location2 = rayTraceResult != null && (rayTraceResult = rayTraceResult.getHitPosition()) != null ? rayTraceResult.toLocation(placement.getWorld()) : (hit = null);
            if (options.getDebugDuration() != 0) {
                Location location3 = hit;
                FlashBurnKt.spawnDebugGraphics(placement, options, direction, (Vector)(location3 != null ? location3.toVector() : null));
            }
            if (hit == null || (x = -(area = 2)) > area) continue;
            while (true) {
                int z;
                if ((z = -area) <= area) {
                    while (true) {
                        int y;
                        if ((y = -area) <= area) {
                            while (true) {
                                if (!Random.Default.nextBoolean()) {
                                    Block block;
                                    Intrinsics.checkNotNullExpressionValue(hit.clone().add((double)x, (double)y, (double)z).getBlock(), "getBlock(...)");
                                    Location location4 = placement.getRender().toLocation(placement.getWorld());
                                    Intrinsics.checkNotNullExpressionValue(location4, "toLocation(...)");
                                    burner.burn(block, location4, 0.5f);
                                }
                                if (y == area) break;
                                ++y;
                            }
                        }
                        if (z == area) break;
                        ++z;
                    }
                }
                if (x == area) continue block0;
                ++x;
            }
        }
    }

    private static final Iterator<Vector> sphereRays(int horizontalCount, double vertMinAngle, double vertMaxAngle, int vertCount) {
        return SequencesKt.iterator((Function2)new Function2<SequenceScope<? super Vector>, Continuation<? super Unit>, Object>(horizontalCount, vertMaxAngle, vertMinAngle, vertCount, null){
            double D$0;
            double D$1;
            double D$2;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ int $horizontalCount;
            final /* synthetic */ double $vertMaxAngle;
            final /* synthetic */ double $vertMinAngle;
            final /* synthetic */ int $vertCount;
            {
                this.$horizontalCount = $horizontalCount;
                this.$vertMaxAngle = $vertMaxAngle;
                this.$vertMinAngle = $vertMinAngle;
                this.$vertCount = $vertCount;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block7: {
                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block0 : switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            $this$iterator = (SequenceScope)this.L$0;
                            horizontalStep = 6.283185307179586 / (double)this.$horizontalCount;
                            verticalStep = (this.$vertMaxAngle - this.$vertMinAngle) / (double)this.$vertCount;
                            horizontalIndex = 0;
lbl9:
                            // 2 sources

                            while (horizontalIndex < this.$horizontalCount) {
                                horizontalAngle = (double)horizontalIndex * horizontalStep;
                                verticalIndex = 0;
lbl12:
                                // 2 sources

                                while (verticalIndex < this.$vertCount) {
                                    verticalAngle = this.$vertMinAngle + (double)verticalIndex * verticalStep;
                                    this.L$0 = $this$iterator;
                                    this.D$0 = horizontalStep;
                                    this.D$1 = verticalStep;
                                    this.I$0 = horizontalIndex;
                                    this.D$2 = horizontalAngle;
                                    this.I$1 = verticalIndex;
                                    this.label = 1;
                                    v0 = $this$iterator.yield(new Vector(Math.cos(horizontalAngle) * Math.cos(verticalAngle), Math.sin(verticalAngle), Math.sin(horizontalAngle) * Math.cos(verticalAngle)), this);
                                    if (v0 == var13_2) {
                                        return var13_2;
                                    }
                                    ** GOTO lbl36
                                }
                                break block0;
                            }
                            break block7;
                        }
                        case 1: {
                            verticalIndex = this.I$1;
                            horizontalAngle = this.D$2;
                            horizontalIndex = this.I$0;
                            verticalStep = this.D$1;
                            horizontalStep = this.D$0;
                            $this$iterator = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl36:
                            // 2 sources

                            ++verticalIndex;
                            ** GOTO lbl12
                        }
                    }
                    ++horizontalIndex;
                    ** GOTO lbl9
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return var3_3;
            }

            public final Object invoke(SequenceScope<? super Vector> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final void spawnDebugGraphics(FlashBurnPlacement placement, FlashBurnOptions options, Vector direction, Vector hit) {
        Vector vector = hit;
        if (vector == null || (vector = vector.subtract(placement.getOrigin())) == null) {
            Vector vector2 = direction.clone().multiply(options.getRayDistance());
            vector = vector2;
            Intrinsics.checkNotNullExpressionValue(vector2, "multiply(...)");
        }
        Vector vector3 = vector;
        BlockData blockData = hit == null ? Material.LIGHT_GRAY_STAINED_GLASS.createBlockData() : Material.RED_STAINED_GLASS.createBlockData();
        Intrinsics.checkNotNull(blockData);
        BlockData blockData2 = blockData;
        SchedulingKt.runLater(Random.Default.nextLong(5L), () -> FlashBurnKt.spawnDebugGraphics$lambda$4(direction, placement, vector3, blockData2));
    }

    private static final Unit spawnDebugGraphics$lambda$4$lambda$1$lambda$0(BlockData $blockData, BlockDisplay it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.setBlock($blockData);
        it.setBrightness(new Display.Brightness(15, 15));
        return Unit.INSTANCE;
    }

    private static final Unit spawnDebugGraphics$lambda$4$lambda$1(Vector $direction, FlashBurnPlacement $placement, Vector $vector, BlockData $blockData) {
        MultiModelRenderer multiModelRenderer = AppState.INSTANCE.getRenderer();
        Location location = $placement.getOrigin().toLocation($placement.getWorld());
        Intrinsics.checkNotNullExpressionValue(location, "toLocation(...)");
        Location location2 = location;
        Location location3 = $placement.getRender().toLocation($placement.getWorld());
        Intrinsics.checkNotNullExpressionValue(location3, "toLocation(...)");
        multiModelRenderer.render((Object)$direction, EntityRendererKt.lineModel$default(location3, location2, $vector, null, 0.2f, 1, arg_0 -> FlashBurnKt.spawnDebugGraphics$lambda$4$lambda$1$lambda$0($blockData, arg_0), null, 136, null));
        return Unit.INSTANCE;
    }

    private static final Unit spawnDebugGraphics$lambda$4$lambda$3$lambda$2(Closeable $it) {
        $it.close();
        return Unit.INSTANCE;
    }

    private static final Unit spawnDebugGraphics$lambda$4(Vector $direction, FlashBurnPlacement $placement, Vector $vector, BlockData $blockData) {
        Closeable it = SchedulingKt.onTick(() -> FlashBurnKt.spawnDebugGraphics$lambda$4$lambda$1($direction, $placement, $vector, $blockData));
        boolean bl = false;
        long duration = (long)60 + Random.Default.nextLong(40L);
        SchedulingKt.runLater(duration, () -> FlashBurnKt.spawnDebugGraphics$lambda$4$lambda$3$lambda$2(it));
        return Unit.INSTANCE;
    }
}

