/*
 * Decompiled with CFR 0.152.
 */
package com.heledron.sky_torch.laser;

import com.heledron.sky_torch.AppState;
import com.heledron.sky_torch.GameObject;
import com.heledron.sky_torch.utilities.EntityRendererKt;
import com.heledron.sky_torch.utilities.ModelPart;
import com.heledron.sky_torch.utilities.SchedulingKt;
import com.heledron.sky_torch.utilities.UtilitiesKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020,H\u0016J\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0016\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\"\"\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020 X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\"R\u0014\u0010)\u001a\u00020 X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\"\u00a8\u00061"}, d2={"Lcom/heledron/sky_torch/laser/FlyingBlock;", "Lcom/heledron/sky_torch/GameObject;", "renderLocation", "Lorg/bukkit/Location;", "location", "velocity", "Lorg/bukkit/util/Vector;", "blockData", "Lorg/bukkit/block/data/BlockData;", "<init>", "(Lorg/bukkit/Location;Lorg/bukkit/Location;Lorg/bukkit/util/Vector;Lorg/bukkit/block/data/BlockData;)V", "getRenderLocation", "()Lorg/bukkit/Location;", "getLocation", "getVelocity", "()Lorg/bukkit/util/Vector;", "getBlockData", "()Lorg/bukkit/block/data/BlockData;", "setBlockData", "(Lorg/bukkit/block/data/BlockData;)V", "pitch", "", "getPitch", "()F", "yaw", "getYaw", "rotateAxis", "Lorg/joml/Vector3f;", "Lorg/jetbrains/annotations/NotNull;", "getRotateAxis", "()Lorg/joml/Vector3f;", "rotateSpeed", "", "getRotateSpeed", "()D", "rotation", "getRotation", "setRotation", "(D)V", "gravityAcceleration", "getGravityAcceleration", "airDragCoefficient", "getAirDragCoefficient", "update", "", "render", "getModel", "Lcom/heledron/sky_torch/utilities/ModelPart;", "Lorg/bukkit/entity/BlockDisplay;", "sky-torch"})
public final class FlyingBlock
extends GameObject {
    @NotNull
    private final Location renderLocation;
    @NotNull
    private final Location location;
    @NotNull
    private final Vector velocity;
    @NotNull
    private BlockData blockData;
    private final float pitch;
    private final float yaw;
    @NotNull
    private final Vector3f rotateAxis;
    private final double rotateSpeed;
    private double rotation;
    private final double gravityAcceleration;
    private final double airDragCoefficient;

    public FlyingBlock(@NotNull Location renderLocation, @NotNull Location location, @NotNull Vector velocity, @NotNull BlockData blockData) {
        Intrinsics.checkNotNullParameter(renderLocation, "renderLocation");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(velocity, "velocity");
        Intrinsics.checkNotNullParameter(blockData, "blockData");
        this.renderLocation = renderLocation;
        this.location = location;
        this.velocity = velocity;
        this.blockData = blockData;
        this.pitch = (float)Random.Default.nextDouble(Math.PI * 2);
        this.yaw = (float)Random.Default.nextDouble(Math.PI * 2);
        Vector3f vector3f = this.velocity.clone().crossProduct(new Vector(0, 1, 0)).normalize().toVector3f();
        Intrinsics.checkNotNullExpressionValue(vector3f, "toVector3f(...)");
        this.rotateAxis = vector3f;
        this.rotateSpeed = Random.Default.nextDouble(0.1, 0.8);
        this.gravityAcceleration = 0.08;
        this.airDragCoefficient = 0.02;
        SchedulingKt.runLater(200L, () -> FlyingBlock._init_$lambda$0(this));
    }

    @NotNull
    public final Location getRenderLocation() {
        return this.renderLocation;
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    @NotNull
    public final Vector getVelocity() {
        return this.velocity;
    }

    @NotNull
    public final BlockData getBlockData() {
        return this.blockData;
    }

    public final void setBlockData(@NotNull BlockData blockData) {
        Intrinsics.checkNotNullParameter(blockData, "<set-?>");
        this.blockData = blockData;
    }

    public final float getPitch() {
        return this.pitch;
    }

    public final float getYaw() {
        return this.yaw;
    }

    @NotNull
    public final Vector3f getRotateAxis() {
        return this.rotateAxis;
    }

    public final double getRotateSpeed() {
        return this.rotateSpeed;
    }

    public final double getRotation() {
        return this.rotation;
    }

    public final void setRotation(double d) {
        this.rotation = d;
    }

    public final double getGravityAcceleration() {
        return this.gravityAcceleration;
    }

    public final double getAirDragCoefficient() {
        return this.airDragCoefficient;
    }

    @Override
    public void update() {
        if (this.velocity.getY() < -10.0 && this.location.getBlock().getType().isOccluding()) {
            this.remove();
        }
        Vector vector = this.velocity;
        vector.setY(vector.getY() - this.gravityAcceleration);
        this.velocity.multiply(1.0 - this.airDragCoefficient);
        this.rotation += this.rotateSpeed;
        this.location.add(this.velocity);
    }

    @Override
    public void render() {
        AppState.INSTANCE.getRenderer().render((Object)this, this.getModel());
    }

    @NotNull
    public final ModelPart<BlockDisplay> getModel() {
        return EntityRendererKt.blockModel(this.renderLocation, FlyingBlock::getModel$lambda$1, arg_0 -> FlyingBlock.getModel$lambda$2(this, arg_0));
    }

    private static final Unit _init_$lambda$0(FlyingBlock this$0) {
        this$0.remove();
        return Unit.INSTANCE;
    }

    private static final Unit getModel$lambda$1(BlockDisplay it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.setTeleportDuration(1);
        it.setInterpolationDuration(1);
        return Unit.INSTANCE;
    }

    private static final Unit getModel$lambda$2(FlyingBlock this$0, BlockDisplay it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Vector vector = this$0.location.toVector().subtract(this$0.renderLocation.toVector());
        Intrinsics.checkNotNullExpressionValue(vector, "subtract(...)");
        Vector diff = vector;
        it.setBlock(this$0.blockData);
        float finalSize = 1.0f;
        Matrix4f matrix = new Matrix4f().translate((float)diff.getX(), (float)diff.getY(), (float)diff.getZ()).rotate((float)this$0.rotation, (Vector3fc)this$0.rotateAxis).rotateXYZ(this$0.pitch, this$0.yaw, 0.0f).translate(-finalSize / (float)2, -finalSize / (float)2, 0.0f).scale(finalSize, finalSize, finalSize);
        Intrinsics.checkNotNull(matrix);
        UtilitiesKt.applyTransformationWithInterpolation(it, matrix);
        return Unit.INSTANCE;
    }
}

