/*
 * Decompiled with CFR 0.152.
 */
package com.heledron.sky_torch.laser;

import com.heledron.sky_torch.AppState;
import com.heledron.sky_torch.GameObject;
import com.heledron.sky_torch.laser.BlindEffect;
import com.heledron.sky_torch.laser.BurnWaveKt;
import com.heledron.sky_torch.laser.BurnWavePlacement;
import com.heledron.sky_torch.laser.Burner;
import com.heledron.sky_torch.laser.FlashBurnKt;
import com.heledron.sky_torch.laser.FlashBurnPlacement;
import com.heledron.sky_torch.laser.LaserOptions;
import com.heledron.sky_torch.laser.LaserPlacement;
import com.heledron.sky_torch.laser.ShockWavePlacement;
import com.heledron.sky_torch.laser.ShockwaveKt;
import com.heledron.sky_torch.utilities.EntityRendererKt;
import com.heledron.sky_torch.utilities.EventEmitter;
import com.heledron.sky_torch.utilities.MathsKt;
import com.heledron.sky_torch.utilities.Model;
import com.heledron.sky_torch.utilities.SchedulingKt;
import com.heledron.sky_torch.utilities.SetBlockUndoKt;
import com.heledron.sky_torch.utilities.UtilitiesKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\b\u0010\u001e\u001a\u00020\u000eH\u0002J\b\u0010\u001f\u001a\u00020\u000eH\u0016J\b\u0010 \u001a\u00020\u001aH\u0002J\b\u0010!\u001a\u00020\u001aH\u0002J\b\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/heledron/sky_torch/laser/Laser;", "Lcom/heledron/sky_torch/GameObject;", "placement", "Lcom/heledron/sky_torch/laser/LaserPlacement;", "options", "Lcom/heledron/sky_torch/laser/LaserOptions;", "<init>", "(Lcom/heledron/sky_torch/laser/LaserPlacement;Lcom/heledron/sky_torch/laser/LaserOptions;)V", "onHit", "Lcom/heledron/sky_torch/utilities/EventEmitter;", "onRetractEnd", "burner", "Lcom/heledron/sky_torch/laser/Burner;", "remove", "", "onEnd", "retracting", "", "startFrame", "", "endTime", "time", "driftTimeX", "", "driftTimeZ", "originalHitLocation", "Lorg/bukkit/util/Vector;", "Lorg/jetbrains/annotations/NotNull;", "currentGlowWidth", "update", "boreHole", "render", "laserTip", "laserEnd", "getModel", "Lcom/heledron/sky_torch/utilities/Model;", "sky-torch"})
public final class Laser
extends GameObject {
    @NotNull
    private final LaserPlacement placement;
    @NotNull
    private final LaserOptions options;
    @NotNull
    private final EventEmitter onHit;
    @NotNull
    private final EventEmitter onRetractEnd;
    @NotNull
    private final Burner burner;
    private boolean retracting;
    private int startFrame;
    private int endTime;
    private int time;
    private double driftTimeX;
    private double driftTimeZ;
    @NotNull
    private final Vector originalHitLocation;
    private double currentGlowWidth;

    public Laser(@NotNull LaserPlacement placement, @NotNull LaserOptions options) {
        Intrinsics.checkNotNullParameter(placement, "placement");
        Intrinsics.checkNotNullParameter(options, "options");
        this.placement = placement;
        this.options = options;
        this.onHit = new EventEmitter();
        this.onRetractEnd = new EventEmitter();
        this.burner = new Burner(this.options.getBurn());
        SchedulingKt.runLater(this.options.getDuration(), () -> Laser._init_$lambda$0(this));
        this.onRetractEnd.listen(() -> Laser._init_$lambda$2(this));
        Vector vector = this.placement.getHit().clone();
        Intrinsics.checkNotNullExpressionValue(vector, "clone(...)");
        Vector explodeOrigin = vector;
        explodeOrigin.add(this.placement.getHit().clone().subtract(this.placement.getOrigin()).normalize().multiply(this.options.getExplodePlacementOffset()));
        Vector vector2 = explodeOrigin.clone().add(new Vector(0.0, this.options.getFlashBurnPlacementOffset(), 0.0));
        Intrinsics.checkNotNullExpressionValue(vector2, "add(...)");
        Vector radiationOrigin = vector2;
        Vector vector3 = this.placement.getHit();
        vector3.setY(vector3.getY() - this.options.getDigDepth());
        this.onHit.listen(() -> Laser._init_$lambda$7(this, explodeOrigin, radiationOrigin));
        Vector vector4 = this.placement.getHit().clone();
        Intrinsics.checkNotNullExpressionValue(vector4, "clone(...)");
        this.originalHitLocation = vector4;
        this.currentGlowWidth = 2.0;
    }

    @Override
    public void remove() {
        this.burner.close();
        this.onEnd();
        super.remove();
    }

    private final void onEnd() {
        for (Player player : this.placement.getWorld().getPlayers()) {
            player.removePotionEffect(PotionEffectType.NIGHT_VISION);
        }
    }

    @Override
    public void update() {
        if (this.endTime > this.options.getBeamEndFrames()) {
            return;
        }
        int n = this.time;
        this.time = n + 1;
        this.driftTimeX += Random.Default.nextDouble(2.0);
        this.driftTimeZ += Random.Default.nextDouble(2.2);
        this.placement.getOrigin().add(this.placement.getVelocityDirection().clone().multiply(this.options.getFlySpeed()));
        this.placement.getHit().setX(this.originalHitLocation.getX() + Math.sin(this.driftTimeX / (double)this.options.getRandomnessPeriod() * Math.PI) * this.options.getRandomnessMagnitude());
        this.placement.getHit().setZ(this.originalHitLocation.getZ() + Math.sin(this.driftTimeZ / (double)this.options.getRandomnessPeriod() * Math.PI) * this.options.getRandomnessMagnitude());
        n = this.startFrame;
        this.startFrame = n + 1;
        if (this.startFrame == this.options.getBeamStartFrames()) {
            this.onHit.emit();
        }
        if (this.startFrame >= this.options.getBeamStartFrames()) {
            this.boreHole();
        }
        if (this.retracting) {
            n = this.endTime;
            this.endTime = n + 1;
            if (this.endTime == this.options.getBeamEndFrames()) {
                this.onRetractEnd.emit();
            }
        }
        double glowSin = Math.sin((double)this.time / (double)this.options.getGlowPeriod() * Math.PI) / (double)2 + 0.5;
        this.currentGlowWidth = this.options.getGlowWidthMin() + (this.options.getGlowWidthMax() - this.options.getGlowWidthMin()) * glowSin;
    }

    private final void boreHole() {
        if (this.options.getBoreRadius() == 0.0) {
            return;
        }
        Vector tip = this.laserTip();
        Vector end = this.laserEnd();
        Vector vector = end.clone().subtract(tip);
        Intrinsics.checkNotNullExpressionValue(vector, "subtract(...)");
        Vector stride = vector;
        if (stride.isZero()) {
            return;
        }
        stride.normalize().multiply(this.options.getBoreRadius());
        int tries = (int)Math.ceil((double)this.options.getBoreDistance() / this.options.getBoreRadius());
        for (int i = 0; i < tries; ++i) {
            Block block;
            Vector position;
            Vector3i offset;
            Intrinsics.checkNotNullExpressionValue(tip.clone().add(stride.clone().multiply(i)), "add(...)");
            Iterator<Vector3i> iterator2 = UtilitiesKt.sphereBlockOffsets((int)Math.ceil(this.options.getBoreRadius())).iterator();
            while (iterator2.hasNext()) {
                offset = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(position.toLocation(this.placement.getWorld()).getBlock().getRelative(offset.x, offset.y, offset.z), "getRelative(...)");
                SetBlockUndoKt.setBlock(block, Material.AIR);
            }
            iterator2 = UtilitiesKt.sphereBlockOffsets((int)Math.ceil(this.options.getBoreBurnRadius())).iterator();
            while (iterator2.hasNext()) {
                offset = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(position.toLocation(this.placement.getWorld()).getBlock().getRelative(offset.x, offset.y, offset.z), "getRelative(...)");
                Location location = this.placement.getRender().toLocation(this.placement.getWorld());
                Intrinsics.checkNotNullExpressionValue(location, "toLocation(...)");
                this.burner.burn(block, location, 1.0f);
            }
        }
    }

    @Override
    public void render() {
        AppState.INSTANCE.getRenderer().render((Object)this, this.getModel());
    }

    private final Vector laserTip() {
        Vector vector = this.placement.getOrigin().clone();
        Intrinsics.checkNotNullExpressionValue(vector, "clone(...)");
        return MathsKt.lerp(vector, this.placement.getHit(), RangesKt.coerceAtMost((double)this.startFrame / (double)this.options.getBeamStartFrames(), 1.0));
    }

    private final Vector laserEnd() {
        Vector vector = this.placement.getOrigin().clone();
        Intrinsics.checkNotNullExpressionValue(vector, "clone(...)");
        return MathsKt.lerp(vector, this.placement.getHit(), RangesKt.coerceAtMost((double)this.endTime / (double)this.options.getBeamEndFrames(), 1.0));
    }

    private final Model getModel() {
        Model model = new Model();
        Vector from = this.laserTip();
        Vector to = this.laserEnd();
        Vector vector = to.clone().subtract(from);
        Intrinsics.checkNotNullExpressionValue(vector, "subtract(...)");
        Vector vector2 = vector;
        if (vector2.isZero()) {
            return model;
        }
        Vector vector3 = vector2.clone().normalize();
        Intrinsics.checkNotNullExpressionValue(vector3, "normalize(...)");
        Vector direction = vector3;
        Vector vector4 = direction.clone().crossProduct(new Vector(0, 1, 0)).normalize();
        Intrinsics.checkNotNullExpressionValue(vector4, "normalize(...)");
        Vector upVector = vector4;
        Location location = this.placement.getRender().toLocation(this.placement.getWorld());
        Intrinsics.checkNotNullExpressionValue(location, "toLocation(...)");
        Location location2 = from.clone().add(direction.clone().multiply(-20)).toLocation(this.placement.getWorld());
        Intrinsics.checkNotNullExpressionValue(location2, "toLocation(...)");
        model.add((Object)"beam", EntityRendererKt.lineModel$default(location, location2, vector2, upVector, (float)this.options.getBeamWidth(), 1, Laser::getModel$lambda$8, null, 128, null));
        Location location3 = this.placement.getRender().toLocation(this.placement.getWorld());
        Intrinsics.checkNotNullExpressionValue(location3, "toLocation(...)");
        Location location4 = from.clone().add(direction.clone().multiply((double)-20 + this.currentGlowWidth)).toLocation(this.placement.getWorld());
        Intrinsics.checkNotNullExpressionValue(location4, "toLocation(...)");
        model.add((Object)"glow", EntityRendererKt.lineModel$default(location3, location4, vector2, upVector, (float)this.currentGlowWidth, 1, Laser::getModel$lambda$9, null, 128, null));
        return model;
    }

    private static final Unit _init_$lambda$0(Laser this$0) {
        this$0.retracting = true;
        return Unit.INSTANCE;
    }

    private static final Unit lambda$2$lambda$1(Laser this$0) {
        this$0.remove();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(Laser this$0) {
        this$0.onEnd();
        SchedulingKt.runLater(1200L, () -> Laser.lambda$2$lambda$1(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$7$lambda$3(Laser this$0) {
        UtilitiesKt.playSoundAtPlayers(this$0.placement.getWorld(), Sound.ENTITY_WARDEN_SONIC_BOOM, 1.0f, 0.0f);
        UtilitiesKt.playSoundAtPlayers(this$0.placement.getWorld(), Sound.ENTITY_WARDEN_SONIC_BOOM, 1.0f, 1.0f);
        UtilitiesKt.playSoundAtPlayers(this$0.placement.getWorld(), Sound.ITEM_TOTEM_USE, 1.0f, 0.5f);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$7$lambda$5(Laser this$0, Vector $explodeOrigin) {
        BurnWavePlacement placement = new BurnWavePlacement(this$0.placement.getWorld(), $explodeOrigin, this$0.placement.getRender());
        BurnWaveKt.spawnBurnWave(placement, this$0.options.getBurnWave(), this$0.burner);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$7$lambda$6(Laser this$0, Vector $radiationOrigin) {
        FlashBurnPlacement placement = new FlashBurnPlacement(this$0.placement.getWorld(), $radiationOrigin, this$0.placement.getRender());
        FlashBurnKt.flashBurn(placement, this$0.options.getFlashBurn(), this$0.burner);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(Laser this$0, Vector $explodeOrigin, Vector $radiationOrigin) {
        if (this$0.options.getApplyNightVision()) {
            for (Player player : this$0.placement.getWorld().getPlayers()) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, 10000, 1, true, false, false));
            }
        }
        List list = this$0.placement.getWorld().getPlayers();
        Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
        new BlindEffect(list, this$0.options.getBlinding());
        SchedulingKt.runLater(1L, () -> Laser.lambda$7$lambda$3(this$0));
        Laser $this$lambda_u247_u24lambda_u244 = this$0;
        boolean bl = false;
        ShockWavePlacement placement = new ShockWavePlacement($this$lambda_u247_u24lambda_u244.placement.getWorld(), $explodeOrigin, $this$lambda_u247_u24lambda_u244.placement.getRender());
        ShockwaveKt.spawnShockwave(placement, $this$lambda_u247_u24lambda_u244.options.getShockwave(), $this$lambda_u247_u24lambda_u244.burner);
        SchedulingKt.runLater(1L, () -> Laser.lambda$7$lambda$5(this$0, $explodeOrigin));
        SchedulingKt.runLater(3L, () -> Laser.lambda$7$lambda$6(this$0, $radiationOrigin));
        return Unit.INSTANCE;
    }

    private static final Unit getModel$lambda$8(BlockDisplay it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.setBlock(Material.SMOOTH_QUARTZ.createBlockData());
        it.setBrightness(new Display.Brightness(15, 15));
        return Unit.INSTANCE;
    }

    private static final Unit getModel$lambda$9(BlockDisplay it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.setBlock(Material.WHITE_STAINED_GLASS.createBlockData());
        it.setBrightness(new Display.Brightness(15, 15));
        return Unit.INSTANCE;
    }
}

