/*
 * Decompiled with CFR 0.152.
 */
package com.heledron.sky_torch.laser;

import com.heledron.sky_torch.AppState;
import com.heledron.sky_torch.laser.BurnPalette;
import com.heledron.sky_torch.laser.Burner;
import com.heledron.sky_torch.laser.BurnerKt;
import com.heledron.sky_torch.laser.Cloud;
import com.heledron.sky_torch.laser.FlyingBlock;
import com.heledron.sky_torch.laser.ShockWaveOptions;
import com.heledron.sky_torch.laser.ShockWavePlacement;
import com.heledron.sky_torch.utilities.CameraShake;
import com.heledron.sky_torch.utilities.EntityRendererKt;
import com.heledron.sky_torch.utilities.MathsKt;
import com.heledron.sky_torch.utilities.MultiModelRenderer;
import com.heledron.sky_torch.utilities.SchedulingKt;
import com.heledron.sky_torch.utilities.SeriesScheduler;
import com.heledron.sky_torch.utilities.SetBlockUndoKt;
import com.heledron.sky_torch.utilities.UtilitiesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a8\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\fH\u0002\"!\u0010\u0000\u001a\u0012\u0012\u000e\u0012\f0\u0002\u00a2\u0006\u0002\b\u0003\u00a2\u0006\u0002\b\u00040\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"shockWavePalette", "", "Lorg/bukkit/block/data/BlockData;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "getShockWavePalette", "()Ljava/util/List;", "spawnShockwave", "", "placement", "Lcom/heledron/sky_torch/laser/ShockWavePlacement;", "options", "Lcom/heledron/sky_torch/laser/ShockWaveOptions;", "burner", "Lcom/heledron/sky_torch/laser/Burner;", "removeBlock", "block", "Lorg/bukkit/block/Block;", "spawnFlyingBlock", "shockWaveVelocity", "Lorg/bukkit/util/Vector;", "radiusFraction", "", "renderLocation", "Lorg/bukkit/Location;", "burnPalette", "Lcom/heledron/sky_torch/laser/BurnPalette;", "sky-torch"})
@SourceDebugExtension(value={"SMAP\nshockwave.kt\nKotlin\n*S Kotlin\n*F\n+ 1 shockwave.kt\ncom/heledron/sky_torch/laser/ShockwaveKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1557#2:151\n1628#2,3:152\n*S KotlinDebug\n*F\n+ 1 shockwave.kt\ncom/heledron/sky_torch/laser/ShockwaveKt\n*L\n49#1:151\n49#1:152,3\n*E\n"})
public final class ShockwaveKt {
    @NotNull
    private static final List<BlockData> shockWavePalette;

    @NotNull
    public static final List<BlockData> getShockWavePalette() {
        return shockWavePalette;
    }

    public static final void spawnShockwave(@NotNull ShockWavePlacement placement, @NotNull ShockWaveOptions options, @NotNull Burner burner) {
        Intrinsics.checkNotNullParameter(placement, "placement");
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(burner, "burner");
        List visitedPlayers = new ArrayList();
        for (Pair<Double, Double> pair : UtilitiesKt.ring(options.getCount())) {
            Vector vector;
            Location location;
            double x = ((Number)pair.component1()).doubleValue();
            double z = ((Number)pair.component2()).doubleValue();
            Location location2 = placement.getRender().toLocation(placement.getWorld());
            Intrinsics.checkNotNullExpressionValue(location2, "toLocation(...)");
            Object object = location2;
            Intrinsics.checkNotNullExpressionValue(placement.getOrigin().toLocation(placement.getWorld()), "toLocation(...)");
            Intrinsics.checkNotNullExpressionValue(new Vector(x, 0.02, z).multiply(options.getSpeed()), "multiply(...)");
            double d = options.getSize();
            double d2 = options.getGrowth();
            int n = options.getDuration();
            List list = CollectionsKt.listOf(CollectionsKt.random((Collection)shockWavePalette, Random.Default));
            Object $this$spawnShockwave_u24lambda_u243 = object = new Cloud(location, (Location)object, vector, d, d2, n, list);
            boolean bl = false;
            ((Cloud)$this$spawnShockwave_u24lambda_u243).setOnUpdate(() -> ShockwaveKt.spawnShockwave$lambda$3$lambda$2((Cloud)$this$spawnShockwave_u24lambda_u243, placement, visitedPlayers, options, burner));
        }
    }

    private static final void removeBlock(Block block) {
        if (BurnerKt.hasWater(block)) {
            SetBlockUndoKt.setBlock(block, Material.WATER);
        } else {
            SetBlockUndoKt.setBlock(block, Material.AIR);
        }
    }

    private static final void spawnFlyingBlock(Block block, Vector shockWaveVelocity, double radiusFraction, Location renderLocation, BurnPalette burnPalette, ShockWaveOptions options) {
        List<Pair<Long, BlockData>> list = burnPalette.burn(block, 1.0f);
        if (list == null) {
            list = CollectionsKt.listOf(TuplesKt.to(0L, block.getBlockData()));
        }
        List<Pair<Long, BlockData>> palette = list;
        BlockData blockData = block.getBlockData();
        Intrinsics.checkNotNullExpressionValue(blockData, "getBlockData(...)");
        BlockData blockData2 = blockData;
        Vector vector = shockWaveVelocity.clone();
        Intrinsics.checkNotNullExpressionValue(vector, "clone(...)");
        Vector velocity = vector;
        double power = 1.0 - radiusFraction;
        velocity.setY(velocity.length() * power);
        velocity.normalize();
        velocity.multiply(Random.Default.nextDouble(options.getFlyingBlockMinVelocity(), options.getFlyingBlockMaxVelocity()) * Math.pow(power, 2));
        SchedulingKt.runLater(Random.Default.nextLong(5L), () -> ShockwaveKt.spawnFlyingBlock$lambda$5(renderLocation, block, velocity, blockData2, palette));
    }

    private static final Unit spawnShockwave$lambda$3$lambda$2$lambda$1(BlockDisplay it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.setBlock(Material.RED_CONCRETE.createBlockData());
        it.setTransformation(UtilitiesKt.centredTransform(1.0f, 1.0f, 1.0f));
        return Unit.INSTANCE;
    }

    private static final Unit spawnShockwave$lambda$3$lambda$2(Cloud $this_apply, ShockWavePlacement $placement, List $visitedPlayers, ShockWaveOptions $options, Burner $burner) {
        double radiusFraction;
        RayTraceResult ground;
        double radiusSquared;
        block11: {
            RayTraceResult rayTraceResult;
            block10: {
                radiusSquared = $this_apply.getLocation().toVector().add($this_apply.getVelocity()).distanceSquared($placement.getOrigin());
                for (Player player : $placement.getWorld().getPlayers()) {
                    if ($visitedPlayers.contains(player) || player.getLocation().toVector().distanceSquared($placement.getOrigin()) > radiusSquared) continue;
                    ((Collection)$visitedPlayers).add(player);
                    Intrinsics.checkNotNull(player);
                    new CameraShake(player, $options.getCameraShake());
                }
                Location location = $this_apply.getLocation().clone().add(0.0, $options.getScanUpwards(), 0.0);
                Intrinsics.checkNotNullExpressionValue(location, "add(...)");
                Location top = location;
                rayTraceResult = UtilitiesKt.raycastGround(top, new Vector(0, -1, 0), $options.getScanUpwards());
                if (rayTraceResult == null || (rayTraceResult = rayTraceResult.getHitPosition()) == null) break block10;
                World world = $this_apply.getLocation().getWorld();
                Intrinsics.checkNotNull(world);
                if ((rayTraceResult = rayTraceResult.toLocation(world)) != null) break block11;
            }
            rayTraceResult = ground = $this_apply.getLocation();
        }
        if ($this_apply.getLocation().getBlock().getType().isOccluding()) {
            $this_apply.getLocation().setY(MathsKt.lerp($this_apply.getLocation().getY(), ground.getY() + $this_apply.getSize() / (double)2, 0.1));
        }
        if ((radiusFraction = radiusSquared / Math.pow($options.getDestructionRange(), 2)) > 1.0) {
            return Unit.INSTANCE;
        }
        int removeRadius = RangesKt.coerceAtLeast(MathKt.roundToInt(Math.pow(1.0 - radiusFraction, $options.getDestructionCurve()) * $options.getDestructionRadius()), $options.getDestructionRadius() == 0.0 ? 0 : 1);
        if (removeRadius == 0) {
            return Unit.INSTANCE;
        }
        Iterator<Vector3i> iterator2 = UtilitiesKt.sphereBlockOffsets(removeRadius).iterator();
        while (iterator2.hasNext()) {
            Block block;
            Vector3i offset = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(ground.getBlock().getRelative(offset.x, offset.y, offset.z), "getRelative(...)");
            if ($options.getMarkDestroyedBlocks()) {
                MultiModelRenderer multiModelRenderer = AppState.INSTANCE.getRenderer();
                Location location = block.getLocation().add(new Vector(0.5, 0.5, 0.5));
                Intrinsics.checkNotNullExpressionValue(location, "add(...)");
                multiModelRenderer.render((Object)block, EntityRendererKt.blockModel$default(location, ShockwaveKt::spawnShockwave$lambda$3$lambda$2$lambda$1, null, 4, null));
            }
            if (block.getType().isAir() || block.isLiquid()) continue;
            if ((double)Random.Default.nextFloat() < $options.getFlyingBlockChance()) {
                ShockwaveKt.spawnFlyingBlock(block, $this_apply.getVelocity(), radiusFraction, $this_apply.getRenderLocation(), $burner.getOptions().getPalette().getBurn(), $options);
            }
            ShockwaveKt.removeBlock(block);
        }
        return Unit.INSTANCE;
    }

    private static final Unit spawnFlyingBlock$lambda$5$lambda$4(FlyingBlock $flying, BlockData $data) {
        $flying.setBlockData($data);
        return Unit.INSTANCE;
    }

    private static final Unit spawnFlyingBlock$lambda$5(Location $renderLocation, Block $block, Vector $velocity, BlockData $blockData, List $palette) {
        Location location = $block.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        FlyingBlock flying = new FlyingBlock($renderLocation, location, $velocity, $blockData);
        SeriesScheduler series = new SeriesScheduler();
        for (Pair pair : $palette) {
            long delay = ((Number)pair.component1()).longValue();
            BlockData data = (BlockData)pair.component2();
            series.sleep(delay);
            series.run(() -> ShockwaveKt.spawnFlyingBlock$lambda$5$lambda$4(flying, data));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Material[] materialArray = new Material[]{Material.WHITE_STAINED_GLASS, Material.LIGHT_GRAY_STAINED_GLASS};
        Iterable $this$map$iv = CollectionsKt.listOf(materialArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Material material = (Material)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.createBlockData());
        }
        shockWavePalette = (List)var3_3;
    }
}

