/*
 * Decompiled with CFR 0.152.
 */
package com.heledron.sky_torch.utilities;

import com.heledron.sky_torch.utilities.CameraShakeOptions;
import com.heledron.sky_torch.utilities.SchedulingKt;
import com.heledron.sky_torch.utilities.UtilitiesKt;
import java.io.Closeable;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/heledron/sky_torch/utilities/CameraShake;", "Ljava/io/Closeable;", "player", "Lorg/bukkit/entity/Player;", "options", "Lcom/heledron/sky_torch/utilities/CameraShakeOptions;", "<init>", "(Lorg/bukkit/entity/Player;Lcom/heledron/sky_torch/utilities/CameraShakeOptions;)V", "time", "", "prevPitch", "", "prevYaw", "magnitude", "repeat", "close", "", "sky-torch"})
public final class CameraShake
implements Closeable {
    private int time;
    private double prevPitch;
    private double prevYaw;
    private double magnitude;
    @NotNull
    private final Closeable repeat;

    public CameraShake(@NotNull Player player, @NotNull CameraShakeOptions options) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(options, "options");
        this.magnitude = options.getMagnitude();
        this.repeat = SchedulingKt.interval(1L, 1L, () -> CameraShake.repeat$lambda$0(this, options, player));
    }

    @Override
    public void close() {
        this.repeat.close();
    }

    private static final Unit repeat$lambda$0(CameraShake this$0, CameraShakeOptions $options, Player $player) {
        ++this$0.time;
        this$0.magnitude -= $options.getDecay();
        if (this$0.magnitude < 0.0) {
            this$0.close();
            return Unit.INSTANCE;
        }
        double pitch = Math.sin((double)this$0.time / $options.getPitchPeriod() * (double)2 * Math.PI) * this$0.magnitude;
        double yaw = Math.cos((double)this$0.time / $options.getYawPeriod() * (double)2 * Math.PI) * this$0.magnitude;
        double relativePitch = pitch - this$0.prevPitch;
        double relativeYaw = yaw - this$0.prevYaw;
        this$0.prevPitch = pitch;
        this$0.prevYaw = yaw;
        String string = "execute as %s at @s run tp @s ~ ~ ~ ~%.3f ~%.3f";
        Object[] objectArray = new Object[]{$player.getUniqueId(), relativePitch, relativeYaw};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        String command = string2;
        UtilitiesKt.runCommandSilently(command);
        return Unit.INSTANCE;
    }
}

