/*
 * Decompiled with CFR 0.152.
 */
package com.heledron.sky_torch.utilities;

import com.heledron.sky_torch.SkyTorch;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3i;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00c8\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a&\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a?\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u00010\u0012\u00a2\u0006\u0002\u0010\u0013\u001a>\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a\u001aQ\u0010\u0014\u001a\u00020\u0001\"\u0004\b\u0000\u0010\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u0002H\r\u00a2\u0006\u0002\u0010\u001f\u001a\u001e\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0018\u00010!2\b\u0010$\u001a\u0004\u0018\u00010%\u001a\u000e\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\"\u001a \u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001a\u001a\u000e\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020\"\u001a\b\u0010/\u001a\u0004\u0018\u000100\u001a\u0016\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u0002002\u0006\u0010.\u001a\u00020\"\u001a\u001e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0007\u001a \u00108\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0:092\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u000e\u0010;\u001a\u0002042\u0006\u0010<\u001a\u00020=\u001a\u0016\u0010>\u001a\u00020\u00012\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u000204\u001a\u0016\u0010>\u001a\u00020\u00012\u0006\u0010?\u001a\u00020@2\u0006\u0010<\u001a\u00020=\u001a\u000e\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E\u001a \u0010F\u001a\u00020C2\u0018\u0010D\u001a\u0014\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020\u00010G\u001a\u0016\u0010I\u001a\u00020H2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\"\u001a\u0014\u0010M\u001a\b\u0012\u0004\u0012\u00020O0N2\u0006\u0010P\u001a\u00020\u0018\u00a8\u0006Q"}, d2={"playSound", "", "location", "Lorg/bukkit/Location;", "sound", "Lorg/bukkit/Sound;", "volume", "", "pitch", "playSoundAtPlayers", "world", "Lorg/bukkit/World;", "spawnEntity", "T", "Lorg/bukkit/entity/Entity;", "clazz", "Ljava/lang/Class;", "initializer", "Lkotlin/Function1;", "(Lorg/bukkit/Location;Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)Lorg/bukkit/entity/Entity;", "spawnParticle", "particle", "Lorg/bukkit/Particle;", "count", "", "offsetX", "", "offsetY", "offsetZ", "extra", "data", "(Lorg/bukkit/Particle;Lorg/bukkit/Location;IDDDDLjava/lang/Object;)V", "configSectionToMap", "", "", "", "section", "Lorg/bukkit/configuration/ConfigurationSection;", "runCommandSilently", "command", "raycastGround", "Lorg/bukkit/util/RayTraceResult;", "direction", "Lorg/bukkit/util/Vector;", "maxDistance", "sendDebugMessage", "message", "firstPlayer", "Lorg/bukkit/entity/Player;", "sendActionBar", "player", "centredTransform", "Lorg/bukkit/util/Transformation;", "xSize", "ySize", "zSize", "ring", "", "Lkotlin/Pair;", "transformFromMatrix", "matrix", "Lorg/joml/Matrix4f;", "applyTransformationWithInterpolation", "entity", "Lorg/bukkit/entity/BlockDisplay;", "transformation", "addEventListener", "Ljava/io/Closeable;", "listener", "Lorg/bukkit/event/Listener;", "onGestureUseItem", "Lkotlin/Function2;", "Lorg/bukkit/inventory/ItemStack;", "createNamedItem", "material", "Lorg/bukkit/Material;", "name", "sphereBlockOffsets", "Lkotlin/sequences/Sequence;", "Lorg/joml/Vector3i;", "radius", "sky-torch"})
public final class UtilitiesKt {
    public static final void playSound(@NotNull Location location, @NotNull Sound sound, float volume, float pitch) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(sound, "sound");
        World world = location.getWorld();
        Intrinsics.checkNotNull(world);
        world.playSound(location, sound, volume, pitch);
    }

    public static final void playSoundAtPlayers(@NotNull World world, @NotNull Sound sound, float volume, float pitch) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(sound, "sound");
        for (Player player : world.getPlayers()) {
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
    }

    @NotNull
    public static final <T extends Entity> T spawnEntity(@NotNull Location location, @NotNull Class<T> clazz, @NotNull Function1<? super T, Unit> initializer) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(initializer, "initializer");
        World world = location.getWorld();
        Intrinsics.checkNotNull(world);
        return (T)world.spawn(location, clazz, arg_0 -> UtilitiesKt.spawnEntity$lambda$0(initializer, arg_0));
    }

    public static final void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        Intrinsics.checkNotNullParameter(particle, "particle");
        Intrinsics.checkNotNullParameter(location, "location");
        World world = location.getWorld();
        Intrinsics.checkNotNull(world);
        world.spawnParticle(particle, location, count, offsetX, offsetY, offsetZ, extra);
    }

    public static final <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        Intrinsics.checkNotNullParameter(particle, "particle");
        Intrinsics.checkNotNullParameter(location, "location");
        World world = location.getWorld();
        Intrinsics.checkNotNull(world);
        world.spawnParticle(particle, location, count, offsetX, offsetY, offsetZ, extra, data);
    }

    @Nullable
    public static final Map<String, Object> configSectionToMap(@Nullable ConfigurationSection section) {
        if (section == null) {
            return null;
        }
        Map map = new LinkedHashMap();
        Map map2 = section.getValues(false);
        Intrinsics.checkNotNullExpressionValue(map2, "getValues(...)");
        for (Map.Entry entry : map2.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof ConfigurationSection) {
                Map map3 = map;
                Map<String, Object> map4 = UtilitiesKt.configSectionToMap((ConfigurationSection)value);
                Intrinsics.checkNotNull(map4, "null cannot be cast to non-null type kotlin.Any");
                Object object = map4;
                map3.put(key, object);
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    public static final void runCommandSilently(@NotNull String command) {
        Intrinsics.checkNotNullParameter(command, "command");
        Server server = Bukkit.getServer();
        Intrinsics.checkNotNullExpressionValue(server, "getServer(...)");
        Server server2 = server;
        List list = Bukkit.getWorlds();
        Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
        Location location = ((World)CollectionsKt.first(list)).getSpawnLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getSpawnLocation(...)");
        Location location2 = location;
        UtilitiesKt.spawnEntity(location2, CommandMinecart.class, arg_0 -> UtilitiesKt.runCommandSilently$lambda$1(command, server2, arg_0));
    }

    @Nullable
    public static final RayTraceResult raycastGround(@NotNull Location location, @NotNull Vector direction, double maxDistance) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(direction, "direction");
        World world = location.getWorld();
        Intrinsics.checkNotNull(world);
        return world.rayTraceBlocks(location, direction, maxDistance, FluidCollisionMode.NEVER, true);
    }

    public static final void sendDebugMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        Player player = UtilitiesKt.firstPlayer();
        if (player == null) {
            return;
        }
        UtilitiesKt.sendActionBar(player, message);
    }

    @Nullable
    public static final Player firstPlayer() {
        Collection collection = SkyTorch.Companion.getInstance().getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        return (Player)CollectionsKt.firstOrNull(collection);
    }

    public static final void sendActionBar(@NotNull Player player, @NotNull String message) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(message, "message");
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
    }

    @NotNull
    public static final Transformation centredTransform(float xSize, float ySize, float zSize) {
        return new Transformation(new Vector3f(-xSize / (float)2, -ySize / (float)2, -zSize / (float)2), new AxisAngle4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(xSize, ySize, zSize), new AxisAngle4f(0.0f, 0.0f, 0.0f, 1.0f));
    }

    @NotNull
    public static final List<Pair<Double, Double>> ring(int count) {
        List out = new ArrayList();
        for (int i = 0; i < count; ++i) {
            double angle = (double)i / (double)count * (double)2 * Math.PI;
            out.add(TuplesKt.to(Math.sin(angle), Math.cos(angle)));
        }
        return out;
    }

    @NotNull
    public static final Transformation transformFromMatrix(@NotNull Matrix4f matrix) {
        Intrinsics.checkNotNullParameter(matrix, "matrix");
        Vector3f translation = matrix.getTranslation(new Vector3f());
        Quaternionf rotation = matrix.getUnnormalizedRotation(new Quaternionf());
        Vector3f scale = matrix.getScale(new Vector3f());
        return new Transformation(translation, rotation, scale, new Quaternionf());
    }

    public static final void applyTransformationWithInterpolation(@NotNull BlockDisplay entity, @NotNull Transformation transformation) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(transformation, "transformation");
        if (!Intrinsics.areEqual(entity.getTransformation(), transformation)) {
            entity.setTransformation(transformation);
            entity.setInterpolationDelay(0);
        }
    }

    public static final void applyTransformationWithInterpolation(@NotNull BlockDisplay entity, @NotNull Matrix4f matrix) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(matrix, "matrix");
        UtilitiesKt.applyTransformationWithInterpolation(entity, UtilitiesKt.transformFromMatrix(matrix));
    }

    @NotNull
    public static final Closeable addEventListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        SkyTorch.Companion.getInstance().getServer().getPluginManager().registerEvents(listener, (Plugin)SkyTorch.Companion.getInstance());
        return () -> UtilitiesKt.addEventListener$lambda$2(listener);
    }

    @NotNull
    public static final Closeable onGestureUseItem(@NotNull Function2<? super Player, ? super ItemStack, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        return UtilitiesKt.addEventListener(new Listener(listener){
            final /* synthetic */ Function2<Player, ItemStack, Unit> $listener;
            {
                this.$listener = $listener;
            }

            @EventHandler
            public final void onPlayerInteract(PlayerInteractEvent event) {
                Intrinsics.checkNotNullParameter(event, "event");
                if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
                    return;
                }
                if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    Block block = event.getClickedBlock();
                    if (!(block != null && (block = block.getType()) != null ? !block.isInteractable() : false) && !event.getPlayer().isSneaking()) {
                        return;
                    }
                }
                Player player = event.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                ItemStack itemStack = event.getItem();
                if (itemStack == null) {
                    return;
                }
                this.$listener.invoke(player, itemStack);
            }
        });
    }

    @NotNull
    public static final ItemStack createNamedItem(@NotNull Material material, @NotNull String name) {
        Intrinsics.checkNotNullParameter(material, "material");
        Intrinsics.checkNotNullParameter(name, "name");
        ItemStack item = new ItemStack(material);
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            throw new IllegalStateException("ItemMeta is null for " + material);
        }
        ItemMeta meta = itemMeta;
        meta.setDisplayName(ChatColor.RESET + name);
        item.setItemMeta(meta);
        return item;
    }

    @NotNull
    public static final Sequence<Vector3i> sphereBlockOffsets(int radius) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Vector3i>, Continuation<? super Unit>, Object>(radius, null){
            int I$0;
            int I$1;
            int I$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ int $radius;
            {
                this.$radius = $radius;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        x = -this.$radius;
                        if (x > this.$radius) ** GOTO lbl41
lbl8:
                        // 2 sources

                        while (true) {
                            z = -this.$radius;
                            if (z > this.$radius) ** GOTO lbl38
lbl11:
                            // 2 sources

                            while (true) {
                                y = -this.$radius;
                                if (y > this.$radius) ** GOTO lbl35
lbl14:
                                // 2 sources

                                while (true) {
                                    if (x * x + y * y + z * z <= this.$radius * this.$radius) {
                                        this.L$0 = $this$sequence;
                                        this.I$0 = x;
                                        this.I$1 = z;
                                        this.I$2 = y;
                                        this.label = 1;
                                        v0 = $this$sequence.yield(new Vector3i(x, y, z), this);
                                        if (v0 == var6_2) {
                                            return var6_2;
                                        }
                                    }
                                    ** GOTO lbl32
                                    break;
                                }
                                break;
                            }
                            break;
                        }
                    }
                    case 1: {
                        y = this.I$2;
                        z = this.I$1;
                        x = this.I$0;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl32:
                        // 2 sources

                        if (y != this.$radius) {
                            ++y;
                            ** continue;
                        }
lbl35:
                        // 3 sources

                        if (z != this.$radius) {
                            ++z;
                            ** continue;
                        }
lbl38:
                        // 3 sources

                        if (x != this.$radius) {
                            ++x;
                            ** continue;
                        }
lbl41:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return var3_3;
            }

            public final Object invoke(SequenceScope<? super Vector3i> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final void spawnEntity$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit runCommandSilently$lambda$1(String $command, Server $server, CommandMinecart it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.setCommand($command);
        $server.dispatchCommand((CommandSender)it, $command);
        it.remove();
        return Unit.INSTANCE;
    }

    private static final void addEventListener$lambda$2(Listener $listener) {
        HandlerList.unregisterAll((Listener)$listener);
    }
}

