/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.armormod.menu;

import com.hbm_m.armormod.item.ItemArmorMod;
import com.hbm_m.armormod.menu.ArmorSidePanelSlot;
import com.hbm_m.armormod.menu.IHasTooltip;
import com.hbm_m.armormod.util.ArmorModificationHelper;
import com.hbm_m.block.ModBlocks;
import com.hbm_m.datagen.ModItemTagProvider;
import com.hbm_m.menu.ModMenuTypes;
import com.hbm_m.sound.ModSounds;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ArmorTableMenu
extends AbstractContainerMenu {
    private final ItemStackHandler armorInventory = new ItemStackHandler(1);
    private final ItemStackHandler modsInventory = new ItemStackHandler(9);
    private final ContainerLevelAccess access;
    private final Player player;
    private static final int SLOT_ARMOR_IN = 0;
    private static final int SLOT_MOD_START = 1;
    private static final int PLAYER_INVENTORY_START = 10;
    private static final int PLAYER_HOTBAR_START = 37;
    private static final int PLAYER_HOTBAR_END = 45;
    public static final int SLOT_ARMOR_SIDE_HELMET = 46;
    public static final int SLOT_ARMOR_SIDE_CHEST = 47;
    public static final int SLOT_ARMOR_SIDE_LEGS = 48;
    public static final int SLOT_ARMOR_SIDE_BOOTS = 49;
    private static final int ARMOR_PANEL_START = 46;
    private static final int ARMOR_PANEL_END = 49;
    private static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public ArmorTableMenu(int pContainerId, Inventory pPlayerInventory, BlockPos pPos) {
        super((MenuType)ModMenuTypes.ARMOR_TABLE_MENU.get(), pContainerId);
        this.player = pPlayerInventory.f_35978_;
        this.access = ContainerLevelAccess.m_39289_((Level)pPlayerInventory.f_35978_.m_9236_(), (BlockPos)pPos);
        this.m_38897_((Slot)new CentralArmorSlot(this.armorInventory, 0, 44, 63));
        this.m_38897_((Slot)new ModificationSlot(this.modsInventory, 0, 26, 27));
        this.m_38897_((Slot)new ModificationSlot(this.modsInventory, 1, 62, 27));
        this.m_38897_((Slot)new ModificationSlot(this.modsInventory, 2, 98, 27));
        this.m_38897_((Slot)new ModificationSlot(this.modsInventory, 3, 134, 45));
        this.m_38897_((Slot)new ModificationSlot(this.modsInventory, 4, 8, 63));
        this.m_38897_((Slot)new ModificationSlot(this.modsInventory, 5, 26, 99));
        this.m_38897_((Slot)new ModificationSlot(this.modsInventory, 6, 62, 99));
        this.m_38897_((Slot)new ModificationSlot(this.modsInventory, 7, 98, 99));
        this.m_38897_((Slot)new ModificationSlot(this.modsInventory, 8, 134, 81));
        this.addPlayerInventory(pPlayerInventory);
        this.addPlayerHotbar(pPlayerInventory);
        this.addPlayerArmorSlots(pPlayerInventory);
    }

    public ArmorTableMenu(int pContainerId, Inventory pPlayerInventory, FriendlyByteBuf extraData) {
        this(pContainerId, pPlayerInventory, extraData.m_130135_());
    }

    public void m_6877_(@Nonnull Player pPlayer) {
        super.m_6877_(pPlayer);
        if (!pPlayer.m_9236_().f_46443_) {
            pPlayer.m_36176_(this.armorInventory.getStackInSlot(0), false);
        }
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack sourceStack = slot.m_7993_();
            itemstack = sourceStack.m_41777_();
            if (pIndex >= 10 && pIndex <= 45) {
                Item item = sourceStack.m_41720_();
                if (item instanceof ArmorItem) {
                    ArmorItem armorItem = (ArmorItem)item;
                    if (!this.m_38903_(sourceStack, 0, 1, false)) {
                        equipmentSlot = armorItem.m_40402_();
                        int targetSlotIndex = -1;
                        if (equipmentSlot == EquipmentSlot.HEAD) {
                            targetSlotIndex = 46;
                        } else if (equipmentSlot == EquipmentSlot.CHEST) {
                            targetSlotIndex = 47;
                        } else if (equipmentSlot == EquipmentSlot.LEGS) {
                            targetSlotIndex = 48;
                        } else if (equipmentSlot == EquipmentSlot.FEET) {
                            targetSlotIndex = 49;
                        }
                        if (targetSlotIndex == -1 || !this.m_38903_(sourceStack, targetSlotIndex, targetSlotIndex + 1, false)) {
                            return ItemStack.f_41583_;
                        }
                    }
                } else {
                    equipmentSlot = sourceStack.m_41720_();
                    if (equipmentSlot instanceof ItemArmorMod) {
                        int targetModSlotIndex;
                        Slot targetSlot;
                        ItemArmorMod mod = (ItemArmorMod)equipmentSlot;
                        boolean movedToTable = false;
                        ItemStack armorStack = ((Slot)this.f_38839_.get(0)).m_7993_();
                        if (!armorStack.m_41619_() && !(targetSlot = (Slot)this.f_38839_.get(targetModSlotIndex = mod.type + 1)).m_6657_() && targetSlot.m_5857_(sourceStack) && this.m_38903_(sourceStack, targetModSlotIndex, targetModSlotIndex + 1, false)) {
                            pPlayer.m_9236_().m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), (SoundEvent)ModSounds.REPAIR_RANDOM.get(), SoundSource.PLAYERS, 0.7f, 1.0f);
                            movedToTable = true;
                        }
                        if (!movedToTable && (pIndex >= 10 && pIndex < 37 ? !this.m_38903_(sourceStack, 37, 46, false) : !this.m_38903_(sourceStack, 10, 37, false))) {
                            return ItemStack.f_41583_;
                        }
                    } else if (pIndex >= 10 && pIndex < 37 ? !this.m_38903_(sourceStack, 37, 46, false) : !this.m_38903_(sourceStack, 10, 37, false)) {
                        return ItemStack.f_41583_;
                    }
                }
            } else if (pIndex >= 46 && pIndex <= 49) {
                boolean movedToCenter = this.m_38903_(sourceStack, 0, 1, false);
                if (movedToCenter) {
                    Item movedToTable = itemstack.m_41720_();
                    if (movedToTable instanceof ArmorItem) {
                        ArmorItem armorItem = (ArmorItem)movedToTable;
                        pPlayer.m_9236_().m_5594_(null, pPlayer.m_20183_(), armorItem.m_150681_(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                } else if (!this.m_38903_(sourceStack, 10, 46, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (pIndex == 0) {
                boolean equipped;
                int targetSlotIndex = -1;
                Item movedToTable = sourceStack.m_41720_();
                if (movedToTable instanceof ArmorItem) {
                    ArmorItem armorItem = (ArmorItem)movedToTable;
                    EquipmentSlot slotType = armorItem.m_40402_();
                    if (slotType == EquipmentSlot.HEAD) {
                        targetSlotIndex = 46;
                    } else if (slotType == EquipmentSlot.CHEST) {
                        targetSlotIndex = 47;
                    } else if (slotType == EquipmentSlot.LEGS) {
                        targetSlotIndex = 48;
                    } else if (slotType == EquipmentSlot.FEET) {
                        targetSlotIndex = 49;
                    }
                }
                boolean bl = equipped = targetSlotIndex != -1 && this.m_38903_(sourceStack, targetSlotIndex, targetSlotIndex + 1, false);
                if (!equipped && !this.m_38903_(sourceStack, 10, 46, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(sourceStack, 10, 46, false)) {
                pPlayer.m_9236_().m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), (SoundEvent)ModSounds.EXTRACT_RANDOM.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
                return ItemStack.f_41583_;
            }
            if (sourceStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (sourceStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, sourceStack);
        }
        return itemstack;
    }

    public boolean m_6875_(@Nonnull Player pPlayer) {
        return ArmorTableMenu.m_38889_((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)ModBlocks.ARMOR_TABLE.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 140 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 198));
        }
    }

    private void addPlayerArmorSlots(Inventory playerInventory) {
        for (int i = 0; i < ARMOR_SLOTS.length; ++i) {
            EquipmentSlot slotType = ARMOR_SLOTS[i];
            this.m_38897_(new ArmorSidePanelSlot(playerInventory, 39 - i, -17, 36 + i * 18, this.player, slotType));
        }
    }

    private class CentralArmorSlot
    extends SlotItemHandler
    implements IHasTooltip {
        public CentralArmorSlot(ItemStackHandler handler, int index, int x, int y) {
            super((IItemHandler)handler, index, x, y);
        }

        @Override
        public Component getEmptyTooltip() {
            return Component.m_237115_((String)"tooltip.hbm_m.armor_table.main_slot").m_130940_(ChatFormatting.YELLOW);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_41720_() instanceof ArmorItem;
        }

        public int m_6641_() {
            return 1;
        }

        public void m_5852_(ItemStack pStack) {
            super.m_5852_(pStack);
            ArmorModificationHelper.loadModsIntoTable(pStack, (IItemHandler)ArmorTableMenu.this.modsInventory);
        }
    }

    private class ModificationSlot
    extends SlotItemHandler
    implements IHasTooltip {
        private static final Map<Integer, String> TOOLTIP_KEYS = Map.of(0, "tooltip.hbm_m.armor_table.helmet_slot", 1, "tooltip.hbm_m.armor_table.chestplate_slot", 2, "tooltip.hbm_m.armor_table.leggings_slot", 3, "tooltip.hbm_m.armor_table.boots_slot", 4, "tooltip.hbm_m.armor_table.battery_slot", 5, "tooltip.hbm_m.armor_table.special_slot", 6, "tooltip.hbm_m.armor_table.plating_slot", 7, "tooltip.hbm_m.armor_table.casing_slot", 8, "tooltip.hbm_m.armor_table.servos_slot");

        public ModificationSlot(ItemStackHandler handler, int index, int x, int y) {
            super((IItemHandler)handler, index, x, y);
        }

        @Override
        public Component getEmptyTooltip() {
            String key = TOOLTIP_KEYS.getOrDefault(this.getSlotIndex(), "");
            return Component.m_237115_((String)key).m_130940_(ChatFormatting.DARK_PURPLE);
        }

        public boolean m_5857_(ItemStack stack) {
            Item item;
            Item item2 = stack.m_41720_();
            if (!(item2 instanceof ItemArmorMod)) {
                return false;
            }
            ItemArmorMod mod = (ItemArmorMod)item2;
            ItemStack armorStack = ArmorTableMenu.this.armorInventory.getStackInSlot(0);
            if (armorStack.m_41619_() || !((item = armorStack.m_41720_()) instanceof ArmorItem)) {
                return false;
            }
            ArmorItem armorItem = (ArmorItem)item;
            if (mod.type != this.getSlotIndex()) {
                return false;
            }
            ArmorItem.Type armorType = armorItem.m_266204_();
            return switch (armorType) {
                case ArmorItem.Type.HELMET -> stack.m_204117_(ModItemTagProvider.REQUIRES_HELMET);
                case ArmorItem.Type.CHESTPLATE -> stack.m_204117_(ModItemTagProvider.REQUIRES_CHESTPLATE);
                case ArmorItem.Type.LEGGINGS -> stack.m_204117_(ModItemTagProvider.REQUIRES_LEGGINGS);
                case ArmorItem.Type.BOOTS -> stack.m_204117_(ModItemTagProvider.REQUIRES_BOOTS);
                default -> false;
            };
        }

        public void m_5852_(ItemStack pStack) {
            ItemStack armor;
            ItemStack oldStack = this.m_7993_();
            super.m_5852_(pStack);
            if (!pStack.m_41619_() && !ItemStack.m_41728_((ItemStack)oldStack, (ItemStack)pStack)) {
                ArmorTableMenu.this.player.m_9236_().m_6263_(null, ArmorTableMenu.this.player.m_20185_(), ArmorTableMenu.this.player.m_20186_(), ArmorTableMenu.this.player.m_20189_(), (SoundEvent)ModSounds.REPAIR_RANDOM.get(), SoundSource.PLAYERS, 0.7f, 1.0f);
            }
            if (!(armor = ArmorTableMenu.this.armorInventory.getStackInSlot(0)).m_41619_()) {
                ArmorModificationHelper.saveTableToArmor(armor, (IItemHandler)ArmorTableMenu.this.modsInventory, ArmorTableMenu.this.player);
            }
        }

        public void m_142406_(@Nonnull Player pPlayer, @Nonnull ItemStack pStack) {
            super.m_142406_(pPlayer, pStack);
            pPlayer.m_9236_().m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), (SoundEvent)ModSounds.EXTRACT_RANDOM.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
            ItemStack armor = ArmorTableMenu.this.armorInventory.getStackInSlot(0);
            if (!armor.m_41619_()) {
                ArmorModificationHelper.saveTableToArmor(armor, (IItemHandler)ArmorTableMenu.this.modsInventory, ArmorTableMenu.this.player);
            }
        }
    }
}

