/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class DetMinerBlock
extends Block {
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    private static final int EXPLOSION_RADIUS = 4;

    public DetMinerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_()) && !level.m_5776_() && level.m_276867_(pos)) {
            this.triggerMiningExplosion(level, pos);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!level.m_5776_()) {
            boolean hasSignal = level.m_276867_(pos);
            boolean wasPowered = (Boolean)state.m_61143_((Property)POWERED);
            if (hasSignal && !wasPowered) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                this.triggerMiningExplosion(level, pos);
            } else if (!hasSignal && wasPowered) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    private void triggerMiningExplosion(Level level, BlockPos pos) {
        if (level.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ArrayList collectedDrops = new ArrayList();
        Set<BlockPos> blocksToDestroy = this.getBlocksInSphere(pos, 4);
        for (BlockPos blockPos : blocksToDestroy) {
            BlockState blockState = serverLevel.m_8055_(blockPos);
            if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_50752_) || blockState.m_60713_((Block)this)) continue;
            LootParams.Builder lootParamsBuilder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_);
            collectedDrops.addAll(blockState.m_287290_(lootParamsBuilder));
        }
        for (BlockPos blockPos : blocksToDestroy) {
            if (blockPos.equals((Object)pos)) continue;
            serverLevel.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
            serverLevel.m_142346_(null, GameEvent.f_157794_, blockPos);
        }
        for (ItemStack itemStack : collectedDrops) {
            ItemEntity itemEntity = new ItemEntity((Level)serverLevel, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
            itemEntity.m_20334_((level.f_46441_.m_188500_() - 0.5) * 0.2, level.f_46441_.m_188500_() * 0.2 + 0.1, (level.f_46441_.m_188500_() - 0.5) * 0.2);
            serverLevel.m_7967_((Entity)itemEntity);
        }
        level.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123812_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    private Set<BlockPos> getBlocksInSphere(BlockPos center, int radius) {
        return BlockPos.m_121990_((BlockPos)center.m_7918_(-radius, -radius, -radius), (BlockPos)center.m_7918_(radius, radius, radius)).filter(p -> center.m_123331_((Vec3i)p) <= (double)(radius * radius)).map(BlockPos::m_7949_).collect(Collectors.toSet());
    }
}

