/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.DoorBlockEntity;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.multiblock.IMultiblockController;
import com.hbm_m.multiblock.MultiblockStructureHelper;
import com.hbm_m.multiblock.PartRole;
import com.hbm_m.util.DoorDecl;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DoorBlock
extends BaseEntityBlock
implements IMultiblockController {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<PartRole> PART_ROLE = EnumProperty.m_61587_((String)"part_role", PartRole.class);
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    private final DoorDecl doorDecl;
    private final MultiblockStructureHelper structureHelper;

    public DoorBlock(BlockBehaviour.Properties properties, DoorDecl doorDecl) {
        super(properties);
        this.doorDecl = doorDecl;
        HashMap<BlockPos, Supplier<BlockState>> structureMap = new HashMap<BlockPos, Supplier<BlockState>>();
        Supplier<BlockState> phantomSupplier = () -> ((Block)ModBlocks.UNIVERSAL_MACHINE_PART.get()).m_49966_();
        for (int x = -3; x <= 3; ++x) {
            for (int y = 0; y <= 5; ++y) {
                structureMap.put(new BlockPos(x, y, 0), phantomSupplier);
            }
        }
        this.structureHelper = new MultiblockStructureHelper(structureMap, phantomSupplier);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART_ROLE, (Comparable)((Object)PartRole.DEFAULT))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public MultiblockStructureHelper getStructureHelper() {
        return this.structureHelper;
    }

    @Override
    public PartRole getPartRole(BlockPos localOffset) {
        return PartRole.DEFAULT;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DoorBlockEntity(pos, state, this.doorDecl);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return null;
        }
        return DoorBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.DOOR_ENTITY.get()), (world, pos, blockState, blockEntity) -> DoorBlockEntity.serverTick(world, pos, blockState, blockEntity));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        DoorBlockEntity doorBE;
        DoorBlockEntity controller;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof DoorBlockEntity && (controller = (doorBE = (DoorBlockEntity)be).getController()) != null) {
            if (controller.isLocked()) {
                player.m_5661_(this.doorDecl.getLockedMessage(), true);
                return InteractionResult.FAIL;
            }
            if (controller.isMoving()) {
                return InteractionResult.CONSUME;
            }
            controller.toggle();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        DoorBlockEntity doorBE;
        DoorBlockEntity controller;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof DoorBlockEntity && (controller = (doorBE = (DoorBlockEntity)be).getController()) != null) {
            byte doorState = controller.getState();
            if (doorState == 1 || doorState == 3) {
                return Shapes.m_83040_();
            }
            if (doorState == 0 || doorState == 2) {
                if (controller.m_58899_().equals((Object)pos)) {
                    return Shapes.m_83144_();
                }
                return Shapes.m_83040_();
            }
        }
        return Shapes.m_83144_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART_ROLE, OPEN});
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.f_46443_ && !oldState.m_60713_((Block)this)) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            this.structureHelper.placeStructure(level, pos, facing, this);
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof DoorBlockEntity) {
                DoorBlockEntity doorBE = (DoorBlockEntity)be;
                doorBE.setControllerPos(pos);
                doorBE.onStructureFormed();
            }
        }
        super.m_6807_(state, level, pos, oldState, isMoving);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_()) && !level.f_46443_) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            this.structureHelper.destroyStructure(level, pos, facing);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }
}

