/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block;

import com.google.common.collect.ImmutableMap;
import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.MachineAssemblerBlockEntity;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.multiblock.IMultiblockController;
import com.hbm_m.multiblock.MultiblockStructureHelper;
import com.hbm_m.multiblock.PartRole;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class MachineAssemblerBlock
extends BaseEntityBlock
implements IMultiblockController {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    static final Lazy<Map<Direction, VoxelShape>> SHAPES_LAZY = Lazy.of(() -> ImmutableMap.builder().put((Object)Direction.NORTH, (Object)MachineAssemblerBlock.buildShapeNorth().m_83216_(0.5, 0.0, 0.5)).put((Object)Direction.SOUTH, (Object)MachineAssemblerBlock.buildShapeSouth().m_83216_(0.5, 0.0, 0.5)).put((Object)Direction.WEST, (Object)MachineAssemblerBlock.buildShapeWest().m_83216_(0.5, 0.0, 0.5)).put((Object)Direction.EAST, (Object)MachineAssemblerBlock.buildShapeEast().m_83216_(0.5, 0.0, 0.5)).build());
    private static MultiblockStructureHelper STRUCTURE_HELPER;

    private static VoxelShape buildShapeNorth() {
        return Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-16.0, (double)0.0, (double)-16.0, (double)32.0, (double)32.0, (double)32.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-24.0, (double)0.0, (double)8.0, (double)-8.0, (double)16.0, (double)24.0), Block.m_49796_((double)32.0, (double)0.0, (double)-8.0, (double)40.0, (double)16.0, (double)8.0), Block.m_49796_((double)-2.5, (double)5.5, (double)-24.0, (double)2.5, (double)10.5, (double)-16.0), Block.m_49796_((double)13.5, (double)5.5, (double)-24.0, (double)18.5, (double)10.5, (double)-16.0), Block.m_49796_((double)-2.5, (double)5.5, (double)32.0, (double)2.5, (double)10.5, (double)40.0), Block.m_49796_((double)13.5, (double)5.5, (double)32.0, (double)18.5, (double)10.5, (double)40.0)}).m_83296_();
    }

    private static VoxelShape buildShapeEast() {
        return Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-32.0, (double)0.0, (double)-16.0, (double)16.0, (double)32.0, (double)32.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-24.0, (double)0.0, (double)-24.0, (double)-8.0, (double)16.0, (double)-8.0), Block.m_49796_((double)-8.0, (double)0.0, (double)32.0, (double)8.0, (double)16.0, (double)40.0), Block.m_49796_((double)16.0, (double)5.5, (double)-2.5, (double)24.0, (double)10.5, (double)2.5), Block.m_49796_((double)16.0, (double)5.5, (double)13.5, (double)24.0, (double)10.5, (double)18.5), Block.m_49796_((double)-40.0, (double)5.5, (double)-2.5, (double)-32.0, (double)10.5, (double)2.5), Block.m_49796_((double)-40.0, (double)5.5, (double)13.5, (double)-32.0, (double)10.5, (double)18.5)}).m_83296_();
    }

    private static VoxelShape buildShapeSouth() {
        return Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-32.0, (double)0.0, (double)-32.0, (double)16.0, (double)32.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)8.0, (double)0.0, (double)-24.0, (double)24.0, (double)16.0, (double)-8.0), Block.m_49796_((double)-40.0, (double)0.0, (double)-8.0, (double)-32.0, (double)16.0, (double)8.0), Block.m_49796_((double)-2.5, (double)5.5, (double)16.0, (double)2.5, (double)10.5, (double)24.0), Block.m_49796_((double)-18.5, (double)5.5, (double)16.0, (double)-13.5, (double)10.5, (double)24.0), Block.m_49796_((double)-2.5, (double)5.5, (double)-40.0, (double)2.5, (double)10.5, (double)-32.0), Block.m_49796_((double)-18.5, (double)5.5, (double)-40.0, (double)-13.5, (double)10.5, (double)-32.0)}).m_83296_();
    }

    private static VoxelShape buildShapeWest() {
        return Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-16.0, (double)0.0, (double)-32.0, (double)32.0, (double)32.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)24.0, (double)16.0, (double)24.0), Block.m_49796_((double)-8.0, (double)0.0, (double)-40.0, (double)8.0, (double)16.0, (double)-32.0), Block.m_49796_((double)-24.0, (double)5.5, (double)-2.5, (double)-16.0, (double)10.5, (double)2.5), Block.m_49796_((double)-24.0, (double)5.5, (double)-18.5, (double)-16.0, (double)10.5, (double)-13.5), Block.m_49796_((double)32.0, (double)5.5, (double)-2.5, (double)40.0, (double)10.5, (double)2.5), Block.m_49796_((double)32.0, (double)5.5, (double)-18.5, (double)40.0, (double)10.5, (double)-13.5)}).m_83296_();
    }

    public MachineAssemblerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public PartRole getPartRole(BlockPos localOffset) {
        boolean isInput;
        boolean isOutput;
        boolean isEnergy;
        int x = localOffset.m_123341_();
        int y = localOffset.m_123342_();
        int z = localOffset.m_123343_();
        boolean bl = isEnergy = y == 0 && x >= 0 && x <= 1 && (z == -1 || z == 2);
        if (isEnergy) {
            return PartRole.ENERGY_CONNECTOR;
        }
        boolean bl2 = isOutput = y == 0 && x == -1 && (z == 0 || z == 1);
        if (isOutput) {
            return PartRole.ITEM_OUTPUT;
        }
        boolean bl3 = isInput = y == 0 && x == 2 && (z == 0 || z == 1);
        if (isInput) {
            return PartRole.ITEM_INPUT;
        }
        return PartRole.DEFAULT;
    }

    @Override
    public MultiblockStructureHelper getStructureHelper() {
        if (STRUCTURE_HELPER == null) {
            STRUCTURE_HELPER = new MultiblockStructureHelper(MachineAssemblerBlock.defineStructure(), () -> ((Block)ModBlocks.UNIVERSAL_MACHINE_PART.get()).m_49966_());
        }
        return STRUCTURE_HELPER;
    }

    @Override
    public VoxelShape getCustomMasterVoxelShape(BlockState state) {
        return (VoxelShape)((Map)SHAPES_LAZY.get()).get(state.m_61143_((Property)FACING));
    }

    private static Map<BlockPos, Supplier<BlockState>> defineStructure() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int y = 0; y <= 1; ++y) {
            for (int x = -1; x <= 2; ++x) {
                for (int z = -1; z <= 2; ++z) {
                    if (y == 0 && x == 0 && z == 0) continue;
                    builder.put((Object)new BlockPos(x, y, z), () -> ((Block)ModBlocks.UNIVERSAL_MACHINE_PART.get()).m_49966_());
                }
            }
        }
        return builder.build();
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        if (!pState.m_60713_(pOldState.m_60734_()) && !pLevel.f_46443_) {
            this.getStructureHelper().placeStructure(pLevel, pPos, (Direction)pState.m_61143_((Property)FACING), this);
        }
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof MachineAssemblerBlockEntity) {
                MachineAssemblerBlockEntity assemblerEntity = (MachineAssemblerBlockEntity)blockEntity;
                assemblerEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(i));
                    }
                });
            }
            STRUCTURE_HELPER.destroyStructure(level, pos, (Direction)state.m_61143_((Property)FACING));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BlockEntity entity;
        if (!level.f_46443_ && (entity = level.m_7702_(pos)) instanceof MenuProvider && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)((MenuProvider)entity), (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.getCustomMasterVoxelShape(pState);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.getCustomMasterVoxelShape(pState);
    }

    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new MachineAssemblerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return MachineAssemblerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.MACHINE_ASSEMBLER_BE.get()), MachineAssemblerBlockEntity::tick);
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }
}

