/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block;

import com.google.common.collect.ImmutableMap;
import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.MachinePressBlockEntity;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.multiblock.IMultiblockController;
import com.hbm_m.multiblock.MultiblockStructureHelper;
import com.hbm_m.multiblock.PartRole;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class MachinePressBlock
extends BaseEntityBlock
implements IMultiblockController {
    public static final VoxelShape SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)3.0, (double)1.0);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static MultiblockStructureHelper STRUCTURE_HELPER;

    public MachinePressBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        if (!pState.m_60713_(pOldState.m_60734_()) && !pLevel.f_46443_) {
            this.getStructureHelper().placeStructure(pLevel, pPos, (Direction)pState.m_61143_((Property)FACING), this);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof MachinePressBlockEntity) {
                ((MachinePressBlockEntity)blockEntity).drops();
            }
            this.getStructureHelper().destroyStructure(level, pos, (Direction)state.m_61143_((Property)FACING));
        }
        super.m_6810_(state, level, pos, newState, moved);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.m_5776_()) {
            BlockEntity entity = level.m_7702_(pos);
            if (entity instanceof MachinePressBlockEntity) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MachinePressBlockEntity)entity), (BlockPos)pos);
            } else {
                throw new IllegalStateException("Our Container provider is missing!");
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MachinePressBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.m_5776_()) {
            return null;
        }
        return MachinePressBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.PRESS_BE.get()), (level1, pos, state1, blockEntity) -> blockEntity.tick(level1, pos, state1));
    }

    private static Map<BlockPos, Supplier<BlockState>> defineStructure() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)new BlockPos(0, 1, 0), () -> ((Block)ModBlocks.UNIVERSAL_MACHINE_PART.get()).m_49966_());
        builder.put((Object)new BlockPos(0, 2, 0), () -> ((Block)ModBlocks.UNIVERSAL_MACHINE_PART.get()).m_49966_());
        return builder.build();
    }

    @Override
    public MultiblockStructureHelper getStructureHelper() {
        if (STRUCTURE_HELPER == null) {
            STRUCTURE_HELPER = new MultiblockStructureHelper(MachinePressBlock.defineStructure(), () -> ((Block)ModBlocks.UNIVERSAL_MACHINE_PART.get()).m_49966_());
        }
        return STRUCTURE_HELPER;
    }

    @Override
    public PartRole getPartRole(BlockPos localOffset) {
        return PartRole.DEFAULT;
    }
}

