/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block;

import com.google.common.collect.ImmutableMap;
import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.MachineWoodBurnerBlockEntity;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.multiblock.IMultiblockController;
import com.hbm_m.multiblock.MultiblockStructureHelper;
import com.hbm_m.multiblock.PartRole;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class MachineWoodBurnerBlock
extends BaseEntityBlock
implements IMultiblockController {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)2.0);
    private static MultiblockStructureHelper STRUCTURE_HELPER;

    public MachineWoodBurnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape master = this.getCustomMasterVoxelShape(pState);
        return master == null ? SHAPE : master;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape master = this.getCustomMasterVoxelShape(pState);
        return master == null ? SHAPE : master;
    }

    @Override
    public VoxelShape getCustomMasterVoxelShape(BlockState state) {
        return this.getStructureHelper().generateShapeFromParts((Direction)state.m_61143_((Property)FACING));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, LIT});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        if (!pState.m_60713_(pOldState.m_60734_()) && !pLevel.f_46443_) {
            this.getStructureHelper().placeStructure(pLevel, pPos, (Direction)pState.m_61143_((Property)FACING), this);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new MachineWoodBurnerBlockEntity(pPos, pState);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.m_60734_() != pNewState.m_60734_()) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof MachineWoodBurnerBlockEntity) {
                ((MachineWoodBurnerBlockEntity)blockEntity).drops();
            }
            this.getStructureHelper().destroyStructure(pLevel, pPos, (Direction)pState.m_61143_((Property)FACING));
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.m_5776_()) {
            BlockEntity entity = pLevel.m_7702_(pPos);
            if (entity instanceof MachineWoodBurnerBlockEntity) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)((MachineWoodBurnerBlockEntity)entity), (BlockPos)pPos);
            } else {
                throw new IllegalStateException("Our Container provider is missing!");
            }
        }
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return MachineWoodBurnerBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.WOOD_BURNER_BE.get()), MachineWoodBurnerBlockEntity::tick);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof MachineWoodBurnerBlockEntity) {
            MachineWoodBurnerBlockEntity burner = (MachineWoodBurnerBlockEntity)blockEntity;
            return burner.getComparatorPower();
        }
        return 0;
    }

    private static Map<BlockPos, Supplier<BlockState>> defineStructure() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int y = 0; y <= 1; ++y) {
            for (int x = 0; x <= 1; ++x) {
                for (int z = 0; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    int fx = x;
                    int fy = y;
                    int fz = z;
                    builder.put((Object)new BlockPos(fx, fy, fz), () -> ((Block)ModBlocks.UNIVERSAL_MACHINE_PART.get()).m_49966_());
                }
            }
        }
        return builder.build();
    }

    @Override
    public MultiblockStructureHelper getStructureHelper() {
        if (STRUCTURE_HELPER == null) {
            STRUCTURE_HELPER = new MultiblockStructureHelper(MachineWoodBurnerBlock.defineStructure(), () -> ((Block)ModBlocks.UNIVERSAL_MACHINE_PART.get()).m_49966_());
        }
        return STRUCTURE_HELPER;
    }

    @Override
    public PartRole getPartRole(BlockPos localOffset) {
        boolean isEnergyConnector;
        int x = localOffset.m_123341_();
        int y = localOffset.m_123342_();
        int z = localOffset.m_123343_();
        boolean bl = isEnergyConnector = y == 0 && z == 1 && (x == 0 || x == 1);
        if (isEnergyConnector) {
            return PartRole.ENERGY_CONNECTOR;
        }
        return PartRole.DEFAULT;
    }
}

