/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block;

import com.hbm_m.block.DoorBlock;
import com.hbm_m.block.entity.DoorBlockEntity;
import com.hbm_m.block.entity.UniversalMachinePartBlockEntity;
import com.hbm_m.multiblock.IMultiblockController;
import com.hbm_m.multiblock.IMultiblockPart;
import com.hbm_m.multiblock.MultiblockStructureHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class UniversalMachinePartBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SMALL_INTERACT_SHAPE = Shapes.m_83048_((double)0.45, (double)0.0, (double)0.45, (double)0.55, (double)0.5, (double)0.55);

    public UniversalMachinePartBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new UniversalMachinePartBlockEntity(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape masterShape;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof IMultiblockPart)) {
            return SMALL_INTERACT_SHAPE;
        }
        IMultiblockPart part = (IMultiblockPart)blockEntity;
        BlockPos controllerPos = part.getControllerPos();
        if (controllerPos == null) {
            return SMALL_INTERACT_SHAPE;
        }
        BlockState controllerState = pLevel.m_8055_(controllerPos);
        Block block = controllerState.m_60734_();
        if (!(block instanceof IMultiblockController)) {
            return SMALL_INTERACT_SHAPE;
        }
        IMultiblockController controller = (IMultiblockController)block;
        if (controller instanceof DoorBlock) {
            masterShape = controller.getStructureHelper().generateShapeFromParts((Direction)controllerState.m_61143_((Property)DoorBlock.FACING));
            if (masterShape.m_83281_()) {
                return SMALL_INTERACT_SHAPE;
            }
            BlockPos offset = pPos.m_121996_((Vec3i)controllerPos);
            return masterShape.m_83216_((double)(-offset.m_123341_()), (double)(-offset.m_123342_()), (double)(-offset.m_123343_()));
        }
        masterShape = controller.getCustomMasterVoxelShape(controllerState);
        if (masterShape == null) {
            masterShape = controller.getStructureHelper().generateShapeFromParts((Direction)controllerState.m_61143_((Property)FACING));
        }
        if (masterShape.m_83281_()) {
            return SMALL_INTERACT_SHAPE;
        }
        BlockPos offset = pPos.m_121996_((Vec3i)controllerPos);
        return masterShape.m_83216_((double)(-offset.m_123341_()), (double)(-offset.m_123342_()), (double)(-offset.m_123343_()));
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof IMultiblockPart)) {
            return Shapes.m_83040_();
        }
        IMultiblockPart part = (IMultiblockPart)blockEntity;
        BlockPos controllerPos = part.getControllerPos();
        if (controllerPos == null) {
            return Shapes.m_83040_();
        }
        BlockState controllerState = pLevel.m_8055_(controllerPos);
        Block block = controllerState.m_60734_();
        if (!(block instanceof IMultiblockController)) {
            return Shapes.m_83040_();
        }
        IMultiblockController controller = (IMultiblockController)block;
        if (controller instanceof DoorBlock) {
            BlockEntity controllerBE = pLevel.m_7702_(controllerPos);
            if (controllerBE instanceof DoorBlockEntity) {
                DoorBlockEntity doorBE = (DoorBlockEntity)controllerBE;
                byte doorState = doorBE.getState();
                if (doorState == 1 || doorState == 3) {
                    return Shapes.m_83040_();
                }
                VoxelShape masterShape = controller.getStructureHelper().generateShapeFromParts((Direction)controllerState.m_61143_((Property)DoorBlock.FACING));
                if (masterShape.m_83281_()) {
                    return Shapes.m_83040_();
                }
                BlockPos offset = pPos.m_121996_((Vec3i)controllerPos);
                return masterShape.m_83216_((double)(-offset.m_123341_()), (double)(-offset.m_123342_()), (double)(-offset.m_123343_()));
            }
            return Shapes.m_83040_();
        }
        VoxelShape masterShape = controller.getCustomMasterVoxelShape(controllerState);
        if (masterShape == null) {
            masterShape = controller.getStructureHelper().generateShapeFromParts((Direction)controllerState.m_61143_((Property)FACING));
        }
        if (masterShape.m_83281_()) {
            return Shapes.m_83040_();
        }
        BlockPos offset = pPos.m_121996_((Vec3i)controllerPos);
        return masterShape.m_83216_((double)(-offset.m_123341_()), (double)(-offset.m_123342_()), (double)(-offset.m_123343_()));
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        MultiblockStructureHelper.onNeighborChangedForPart(pLevel, pPos, pFromPos);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof IMultiblockPart) {
            IMultiblockPart part = (IMultiblockPart)blockEntity;
            BlockPos controllerPos = part.getControllerPos();
            if (controllerPos == null) {
                if (!pLevel.m_5776_()) {
                    pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 3);
                }
                return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
            }
            BlockState controllerState = pLevel.m_8055_(controllerPos);
            if (controllerState.m_60734_() instanceof IMultiblockController) {
                return controllerState.m_60664_(pLevel, pPlayer, pHand, pHit.m_82430_(controllerPos));
            }
            if (!pLevel.m_5776_()) {
                pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 3);
            }
            return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockState controllerState;
        IMultiblockPart partBe;
        BlockPos controllerPos;
        BlockEntity blockEntity;
        if (!pState.m_60713_(pNewState.m_60734_()) && (blockEntity = pLevel.m_7702_(pPos)) instanceof IMultiblockPart && (controllerPos = (partBe = (IMultiblockPart)blockEntity).getControllerPos()) != null && (controllerState = pLevel.m_8055_(controllerPos)).m_60734_() instanceof IMultiblockController) {
            pLevel.m_46961_(controllerPos, true);
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        IMultiblockPart part;
        BlockPos controllerPos;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiblockPart && (controllerPos = (part = (IMultiblockPart)blockEntity).getControllerPos()) != null) {
            BlockState controllerState = level.m_8055_(controllerPos);
            return controllerState.m_60734_().m_7397_(level, controllerPos, controllerState);
        }
        return ItemStack.f_41583_;
    }
}

