/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block;

import com.google.common.collect.ImmutableMap;
import com.hbm_m.block.UniversalMachinePartBlock;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.block.entity.UniversalMachinePartBlockEntity;
import com.hbm_m.block.entity.WireBlockEntity;
import com.hbm_m.energy.WireNetworkManager;
import com.hbm_m.multiblock.PartRole;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public class WireBlock
extends BaseEntityBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final Map<Direction, BooleanProperty> PROPERTIES_MAP = ImmutableMap.of((Object)Direction.NORTH, (Object)NORTH, (Object)Direction.SOUTH, (Object)SOUTH, (Object)Direction.WEST, (Object)WEST, (Object)Direction.EAST, (Object)EAST, (Object)Direction.UP, (Object)UP, (Object)Direction.DOWN, (Object)DOWN);
    private static final VoxelShape CORE_SHAPE = Block.m_49796_((double)5.5, (double)5.5, (double)5.5, (double)10.5, (double)10.5, (double)10.5);
    private static final Map<Direction, VoxelShape> ARM_SHAPES = ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)5.5, (double)5.5, (double)0.0, (double)10.5, (double)10.5, (double)5.5), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)5.5, (double)5.5, (double)10.5, (double)10.5, (double)10.5, (double)16.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)0.0, (double)5.5, (double)5.5, (double)5.5, (double)10.5, (double)10.5), (Object)Direction.EAST, (Object)Block.m_49796_((double)10.5, (double)5.5, (double)5.5, (double)16.0, (double)10.5, (double)10.5), (Object)Direction.UP, (Object)Block.m_49796_((double)5.5, (double)10.5, (double)5.5, (double)10.5, (double)16.0, (double)10.5), (Object)Direction.DOWN, (Object)Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)5.5, (double)10.5));

    public WireBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        BlockState defaultState = (BlockState)this.f_49792_.m_61090_();
        for (BooleanProperty property : PROPERTIES_MAP.values()) {
            defaultState = (BlockState)defaultState.m_61124_((Property)property, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(defaultState);
    }

    public VoxelShape m_5940_(@Nonnull BlockState pState, @Nonnull BlockGetter pLevel, @Nonnull BlockPos pPos, @Nonnull CollisionContext pContext) {
        VoxelShape shape = CORE_SHAPE;
        for (Direction dir : Direction.values()) {
            if (!((Boolean)pState.m_61143_((Property)PROPERTIES_MAP.get(dir))).booleanValue()) continue;
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)ARM_SHAPES.get(dir));
        }
        return shape;
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos pos = pContext.m_8083_();
        BlockState state = this.m_49966_();
        for (Direction dir : Direction.values()) {
            state = (BlockState)state.m_61124_((Property)PROPERTIES_MAP.get(dir), (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)level, pos, dir)));
        }
        return state;
    }

    public BlockState m_7417_(@Nonnull BlockState pState, @Nonnull Direction pFacing, @Nonnull BlockState pFacingState, @Nonnull LevelAccessor pLevel, @Nonnull BlockPos pCurrentPos, @Nonnull BlockPos pFacingPos) {
        Level lvl;
        BlockEntity blockEntity;
        if (pLevel.m_5776_() && pFacingState.m_60734_() instanceof UniversalMachinePartBlock && (blockEntity = pLevel.m_7702_(pCurrentPos)) instanceof WireBlockEntity) {
            WireBlockEntity wire = (WireBlockEntity)blockEntity;
            wire.scheduleRecheck();
        }
        if (pLevel instanceof Level && !(lvl = (Level)pLevel).m_5776_()) {
            WireNetworkManager.get().onWireChanged(lvl, pCurrentPos);
        }
        boolean canConnect = this.canConnectTo((BlockGetter)pLevel, pCurrentPos, pFacing);
        return (BlockState)pState.m_61124_((Property)PROPERTIES_MAP.get(pFacing), (Comparable)Boolean.valueOf(canConnect));
    }

    public boolean canConnectTo(BlockGetter level, BlockPos pos, Direction direction) {
        UniversalMachinePartBlockEntity partBe;
        BlockPos neighborPos = pos.m_121945_(direction);
        BlockState neighborState = level.m_8055_(neighborPos);
        if (neighborState.m_60713_((Block)this)) {
            return true;
        }
        BlockEntity be = level.m_7702_(neighborPos);
        if (be == null) {
            return false;
        }
        if (be instanceof UniversalMachinePartBlockEntity && (partBe = (UniversalMachinePartBlockEntity)be).getPartRole() == PartRole.ENERGY_CONNECTOR) {
            return true;
        }
        return be.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).isPresent();
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    public RenderShape m_7514_(@Nonnull BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pPos, @Nonnull BlockState pState) {
        return new WireBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level pLevel, @Nonnull BlockState pState, @Nonnull BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return WireBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.WIRE_BE.get()), WireBlockEntity::clientTick);
        }
        return null;
    }
}

