/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity;

import com.hbm_m.block.BlastFurnaceBlock;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.menu.BlastFurnaceMenu;
import com.hbm_m.recipe.BlastFurnaceRecipe;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlastFurnaceBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            BlastFurnaceBlockEntity.this.m_6596_();
            if (!BlastFurnaceBlockEntity.this.f_58857_.m_5776_()) {
                BlastFurnaceBlockEntity.this.f_58857_.m_7260_(BlastFurnaceBlockEntity.this.m_58899_(), BlastFurnaceBlockEntity.this.m_58900_(), BlastFurnaceBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    private static final int FUEL_SLOT = 0;
    private static final int INPUT_SLOT_1 = 1;
    private static final int INPUT_SLOT_2 = 2;
    private static final int OUTPUT_SLOT = 3;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> BlastFurnaceBlockEntity.this.progress;
                case 1 -> BlastFurnaceBlockEntity.this.maxProgress;
                case 2 -> BlastFurnaceBlockEntity.this.fuelLevel;
                case 3 -> BlastFurnaceBlockEntity.this.maxFuelLevel;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    BlastFurnaceBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    BlastFurnaceBlockEntity.this.maxProgress = value;
                    break;
                }
                case 2: {
                    BlastFurnaceBlockEntity.this.fuelLevel = value;
                    break;
                }
                case 3: {
                    BlastFurnaceBlockEntity.this.maxFuelLevel = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private int progress = 0;
    private int maxProgress = 100;
    private int fuelLevel = 0;
    private int maxFuelLevel = 64;

    public BlastFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BLAST_FURNACE_BE.get(), pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.hbm_m.blast_furnace");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new BlastFurnaceMenu(containerId, playerInventory, this, this.data);
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("blast_furnace.progress", this.progress);
        tag.m_128405_("blast_furnace.max_progress", this.maxProgress);
        tag.m_128405_("blast_furnace.fuel_level", this.fuelLevel);
        tag.m_128405_("blast_furnace.max_fuel_level", this.maxFuelLevel);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("blast_furnace.progress");
        this.maxProgress = tag.m_128451_("blast_furnace.max_progress");
        this.fuelLevel = tag.m_128451_("blast_furnace.fuel_level");
        this.maxFuelLevel = tag.m_128451_("blast_furnace.max_fuel_level");
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        boolean wasBurning = this.isBurning();
        boolean dirty = false;
        if (!this.isFuelFull() && this.canAddFuel()) {
            this.addFuel();
            dirty = true;
        }
        boolean hasRecipeResult = this.hasRecipe();
        boolean isBurningResult = this.isBurning();
        if (hasRecipeResult && isBurningResult) {
            this.increaseCraftingProgress();
            dirty = true;
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.consumeFuel();
                this.resetProgress();
                dirty = true;
            }
        } else if (this.progress > 0) {
            this.resetProgress();
            dirty = true;
        }
        if (wasBurning != this.isBurning()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlastFurnaceBlock.LIT, (Comparable)Boolean.valueOf(this.isBurning())), 3);
            dirty = true;
        }
        if (dirty) {
            this.m_6596_();
        }
    }

    private boolean isBurning() {
        return this.fuelLevel > 0;
    }

    private boolean isFuelFull() {
        return this.fuelLevel >= this.maxFuelLevel;
    }

    private boolean canAddFuel() {
        ItemStack fuelStack = this.itemHandler.getStackInSlot(0);
        return fuelStack.m_41720_() == Items.f_42448_ && fuelStack.m_41613_() > 0;
    }

    private void addFuel() {
        ItemStack fuelStack = this.itemHandler.getStackInSlot(0);
        if (fuelStack.m_41720_() == Items.f_42448_) {
            this.fuelLevel = Math.min(this.fuelLevel + 64, this.maxFuelLevel);
            fuelStack.m_41774_(1);
            this.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)Items.f_42446_, 1));
        }
    }

    private void consumeFuel() {
        if (this.fuelLevel > 0) {
            --this.fuelLevel;
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<BlastFurnaceRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            ItemStack output = recipe.get().m_8043_(this.m_58904_().m_9598_());
            this.itemHandler.extractItem(1, 1, false);
            this.itemHandler.extractItem(2, 1, false);
            this.itemHandler.setStackInSlot(3, new ItemStack((ItemLike)output.m_41720_(), this.itemHandler.getStackInSlot(3).m_41613_() + output.m_41613_()));
        }
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean hasRecipe() {
        Optional<BlastFurnaceRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = recipe.get().m_8043_(this.m_58904_().m_9598_());
        return this.canInsertAmountIntoOutputSlot(result.m_41613_()) && this.canInsertItemIntoOutputSlot(result.m_41720_());
    }

    private Optional<BlastFurnaceRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)BlastFurnaceRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(3).m_41619_() || this.itemHandler.getStackInSlot(3).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(3).m_41613_() + count <= this.itemHandler.getStackInSlot(3).m_41741_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

