/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity;

import com.hbm_m.block.DoorBlock;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.client.ClientSoundManager;
import com.hbm_m.multiblock.IMultiblockPart;
import com.hbm_m.multiblock.MultiblockStructureHelper;
import com.hbm_m.multiblock.PartRole;
import com.hbm_m.util.DoorDecl;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class DoorBlockEntity
extends BlockEntity
implements IMultiblockPart {
    public byte state = 0;
    private int openTicks = 0;
    public long animStartTime = 0L;
    private boolean locked = false;
    private final DoorDecl doorDecl;
    private BlockPos controllerPos = null;
    private PartRole partRole = PartRole.DEFAULT;
    private VoxelShape cachedCollisionShape = Shapes.m_83144_();
    private float lastCollisionProgress = -1.0f;
    @OnlyIn(value=Dist.CLIENT)
    private SoundInstance loopingSound;

    public DoorBlockEntity(BlockPos pos, BlockState state, DoorDecl doorDecl) {
        super((BlockEntityType)ModBlockEntities.DOOR_ENTITY.get(), pos, state);
        this.doorDecl = doorDecl;
    }

    public DoorBlockEntity(BlockPos pos, BlockState state) {
        this(pos, state, DoorDecl.LARGE_VEHICLE_DOOR);
    }

    @Override
    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.m_6596_();
    }

    @Override
    @Nullable
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Override
    public void setPartRole(PartRole role) {
        this.partRole = role;
        this.m_6596_();
    }

    @Override
    public PartRole getPartRole() {
        return this.partRole;
    }

    public boolean isController() {
        return this.controllerPos != null && this.controllerPos.equals((Object)this.f_58858_);
    }

    @Nullable
    public DoorBlockEntity getController() {
        if (this.f_58857_ == null) {
            return null;
        }
        if (this.controllerPos == null) {
            return this;
        }
        BlockEntity be = this.f_58857_.m_7702_(this.controllerPos);
        return be instanceof DoorBlockEntity ? (DoorBlockEntity)be : null;
    }

    public void onStructureFormed() {
        this.state = 0;
        this.openTicks = 0;
        this.animStartTime = System.currentTimeMillis();
        this.syncToClient();
    }

    public DoorDecl getDoorDecl() {
        return this.doorDecl;
    }

    public Direction getFacing() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)DoorBlock.FACING) ? (Direction)state.m_61143_((Property)DoorBlock.FACING) : Direction.NORTH;
    }

    public float getOpenProgress(float partialTick) {
        if (this.doorDecl.getOpenTime() == 0) {
            return this.state == 1 || this.state == 3 ? 1.0f : 0.0f;
        }
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.animStartTime;
        int totalTime = this.doorDecl.getOpenTime() * 50;
        return switch (this.state) {
            case 0 -> 0.0f;
            case 1 -> 1.0f;
            case 2 -> Math.max(0.0f, 1.0f - (float)elapsedTime / (float)totalTime);
            case 3 -> Math.min(1.0f, (float)elapsedTime / (float)totalTime);
            default -> 0.0f;
        };
    }

    public byte getState() {
        return this.state;
    }

    public long getAnimStartTime() {
        return this.animStartTime;
    }

    public int getSkinIndex() {
        return 0;
    }

    public void open() {
        if (this.state == 0 || this.state == 2) {
            this.setState((byte)3);
        }
    }

    public void close() {
        if (this.state == 1 || this.state == 3) {
            this.setState((byte)2);
        }
    }

    public void toggle() {
        if (this.state == 2 || this.state == 3) {
            return;
        }
        if (this.state == 0) {
            this.open();
        } else if (this.state == 1) {
            this.close();
        }
    }

    public boolean isMoving() {
        return this.state == 2 || this.state == 3;
    }

    private void setState(byte newState) {
        this.state = newState;
        this.animStartTime = System.currentTimeMillis();
        if (newState == 3) {
            this.openTicks = 0;
        } else if (newState == 2) {
            this.openTicks = this.doorDecl.getOpenTime();
        }
        this.syncToClient();
    }

    public boolean isOpen() {
        return this.state == 1;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.syncToClient();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DoorBlockEntity be) {
        if (be.state == 3) {
            ++be.openTicks;
            be.updatePhantomBlocks(level, pos);
            if (be.openTicks >= be.doorDecl.getOpenTime()) {
                be.state = 1;
                be.openTicks = be.doorDecl.getOpenTime();
                be.syncToClient();
                be.notifyNeighborsOfStateChange(level, pos);
            }
        } else if (be.state == 2) {
            --be.openTicks;
            be.updatePhantomBlocks(level, pos);
            if (be.openTicks <= 0) {
                be.state = 0;
                be.openTicks = 0;
                be.syncToClient();
                be.notifyNeighborsOfStateChange(level, pos);
            }
        }
    }

    private void notifyNeighborsOfStateChange(Level level, BlockPos controllerPos) {
        BlockState blockState = this.m_58900_();
        Block block = blockState.m_60734_();
        if (!(block instanceof DoorBlock)) {
            return;
        }
        DoorBlock doorBlock = (DoorBlock)block;
        Direction facing = (Direction)blockState.m_61143_((Property)DoorBlock.FACING);
        MultiblockStructureHelper structureHelper = doorBlock.getStructureHelper();
        for (BlockPos partPos : structureHelper.getAllPartPositions(controllerPos, facing)) {
            BlockState partState = level.m_8055_(partPos);
            level.m_7260_(partPos, partState, partState, 3);
        }
    }

    public VoxelShape getDynamicCollisionShape(Direction facing) {
        float progress = this.getOpenProgress(0.0f);
        if (Math.abs(progress - this.lastCollisionProgress) < 0.01f) {
            return this.cachedCollisionShape;
        }
        this.lastCollisionProgress = progress;
        List<AABB> bounds = this.doorDecl.getCollisionBounds(progress, facing);
        if (bounds.isEmpty()) {
            this.cachedCollisionShape = Shapes.m_83040_();
            return this.cachedCollisionShape;
        }
        VoxelShape shape = Shapes.m_83040_();
        for (AABB aabb : bounds) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)aabb));
        }
        this.cachedCollisionShape = shape.m_83296_();
        return this.cachedCollisionShape;
    }

    private void updatePhantomBlocks(Level level, BlockPos controllerPos) {
        Direction facing = this.getFacing();
        int[][] ranges = this.doorDecl.getDoorOpenRanges();
        block0: for (int i = 0; i < ranges.length; ++i) {
            int[] range = ranges[i];
            float time = this.doorDecl.getDoorRangeOpenTime(this.openTicks, i);
            for (int j = 0; j < Math.abs(range[3]); ++j) {
                float threshold = (float)j / (float)Math.max(1, Math.abs(range[3] - 1));
                if (this.state == 3 && threshold > time) continue block0;
                if (this.state == 2 && threshold < time) continue;
                for (int k = 0; k < range[4]; ++k) {
                    BlockState currentState;
                    BlockPos offset = this.calculateOffset(range, j, k, facing);
                    BlockPos targetPos = controllerPos.m_7918_(offset.m_123341_(), offset.m_123342_(), offset.m_123343_());
                    if (targetPos.equals((Object)controllerPos) || !(currentState = level.m_8055_(targetPos)).m_61138_((Property)DoorBlock.OPEN)) continue;
                    boolean shouldOpen = this.state == 3;
                    level.m_7731_(targetPos, (BlockState)currentState.m_61124_((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(shouldOpen)), 3);
                }
            }
        }
    }

    private BlockPos calculateOffset(int[] range, int j, int k, Direction facing) {
        BlockPos add = BlockPos.f_121853_;
        switch (range[5]) {
            case 0: {
                add = new BlockPos(0, k, (int)Math.signum(range[3]) * j);
                break;
            }
            case 1: {
                add = new BlockPos(k, (int)Math.signum(range[3]) * j, 0);
                break;
            }
            case 2: {
                add = new BlockPos((int)Math.signum(range[3]) * j, k, 0);
            }
        }
        BlockPos startPos = new BlockPos(range[0], range[1], range[2]);
        return this.rotatePos(startPos.m_121955_((Vec3i)add), facing);
    }

    private BlockPos rotatePos(BlockPos pos, Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> pos;
            case Direction.SOUTH -> new BlockPos(-pos.m_123341_(), pos.m_123342_(), -pos.m_123343_());
            case Direction.WEST -> new BlockPos(-pos.m_123343_(), pos.m_123342_(), pos.m_123341_());
            case Direction.EAST -> new BlockPos(pos.m_123343_(), pos.m_123342_(), -pos.m_123341_());
            default -> pos;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleNewState(byte oldState, byte newState) {
        if (oldState == newState) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        DoorDecl decl = this.getDoorDecl();
        if (oldState == 0 && newState == 3) {
            this.handleSoundTransition(decl.getOpenSoundStart(), decl.getOpenSoundLoop());
        } else if (oldState == 1 && newState == 2) {
            this.handleSoundTransition(decl.getCloseSoundStart(), decl.getCloseSoundLoop());
        } else if (oldState == 3 && newState == 1) {
            this.handleSoundEnd(decl.getOpenSoundEnd());
        } else if (oldState == 2 && newState == 0) {
            this.handleSoundEnd(decl.getCloseSoundEnd());
        } else {
            ClientSoundManager.stopSound(this.f_58858_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleSoundTransition(SoundEvent startSound, SoundEvent loopSound) {
        if (startSound != null) {
            ClientSoundManager.playOneShotSound(this.f_58858_, startSound, this.getDoorDecl().getSoundVolume());
        }
        if (loopSound != null) {
            ClientSoundManager.updateDoorSound(this.f_58858_, true, () -> this.createLoopingSound(loopSound));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleSoundEnd(SoundEvent endSound) {
        ClientSoundManager.stopSound(this.f_58858_);
        if (endSound != null) {
            ClientSoundManager.playOneShotSound(this.f_58858_, endSound, this.getDoorDecl().getSoundVolume());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private AbstractTickableSoundInstance createLoopingSound(SoundEvent sound) {
        return new AbstractTickableSoundInstance(sound, SoundSource.BLOCKS, RandomSource.m_216327_()){
            {
                this.f_119575_ = (double)DoorBlockEntity.this.f_58858_.m_123341_() + 0.5;
                this.f_119576_ = (double)DoorBlockEntity.this.f_58858_.m_123342_() + 0.5;
                this.f_119577_ = (double)DoorBlockEntity.this.f_58858_.m_123343_() + 0.5;
                this.f_119573_ = DoorBlockEntity.this.getDoorDecl().getSoundVolume();
                this.f_119574_ = 1.0f;
                this.f_119578_ = true;
            }

            public void m_7788_() {
                block5: {
                    block4: {
                        ClientLevel level = Minecraft.m_91087_().f_91073_;
                        if (level == null) {
                            this.m_119609_();
                            return;
                        }
                        BlockEntity be = level.m_7702_(DoorBlockEntity.this.f_58858_);
                        if (!(be instanceof DoorBlockEntity)) break block4;
                        DoorBlockEntity doorBE = (DoorBlockEntity)be;
                        if (doorBE.state == 2 || doorBE.state == 3) break block5;
                    }
                    this.m_119609_();
                }
            }
        };
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            ClientSoundManager.stopSound(this.f_58858_);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128344_("state", this.state);
        tag.m_128405_("openTicks", this.openTicks);
        tag.m_128356_("animStartTime", this.animStartTime);
        tag.m_128379_("locked", this.locked);
        if (this.controllerPos != null) {
            tag.m_128356_("controllerPos", this.controllerPos.m_121878_());
        }
        tag.m_128359_("partRole", this.partRole.name());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        byte oldState = this.state;
        this.state = tag.m_128445_("state");
        this.openTicks = tag.m_128451_("openTicks");
        this.animStartTime = tag.m_128454_("animStartTime");
        this.locked = tag.m_128471_("locked");
        if (tag.m_128441_("controllerPos")) {
            this.controllerPos = BlockPos.m_122022_((long)tag.m_128454_("controllerPos"));
        }
        if (tag.m_128441_("partRole")) {
            try {
                this.partRole = PartRole.valueOf(tag.m_128461_("partRole"));
            }
            catch (IllegalArgumentException e) {
                this.partRole = PartRole.DEFAULT;
            }
        }
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && oldState != this.state) {
            this.handleNewState(oldState, this.state);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    private void syncToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(this.doorDecl.getRenderRadius());
    }
}

