/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity;

import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.radiation.ChunkRadiationManager;
import com.hbm_m.sound.ModSounds;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class GeigerCounterBlockEntity
extends BlockEntity {
    private static final Random RANDOM = new Random();
    private int timer = 0;
    private float lastMeasuredRads = 0.0f;

    public GeigerCounterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.GEIGER_COUNTER_BE.get(), pPos, pBlockState);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        ++this.timer;
        if (this.timer >= 10) {
            this.timer = 0;
            this.lastMeasuredRads = ChunkRadiationManager.getRadiation(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            level.m_46717_(pos, this.m_58900_().m_60734_());
        }
        if (this.timer % 5 == 0) {
            this.playGeigerTickSound(level, pos, this.lastMeasuredRads);
        }
    }

    private void playGeigerTickSound(Level level, BlockPos pos, float radiationLevel) {
        int soundIndex = 0;
        ArrayList<Integer> soundOptions = new ArrayList<Integer>();
        if (radiationLevel > 0.0f) {
            if (radiationLevel < 10.0f) {
                soundOptions.add(1);
            }
            if (radiationLevel > 5.0f && radiationLevel < 15.0f) {
                soundOptions.add(2);
            }
            if (radiationLevel > 10.0f && radiationLevel < 20.0f) {
                soundOptions.add(3);
            }
            if (radiationLevel > 15.0f && radiationLevel < 25.0f) {
                soundOptions.add(4);
            }
            if (radiationLevel > 20.0f && radiationLevel < 30.0f) {
                soundOptions.add(5);
            }
            if (radiationLevel > 25.0f) {
                soundOptions.add(6);
            }
            if (!soundOptions.isEmpty()) {
                soundIndex = (Integer)soundOptions.get(RANDOM.nextInt(soundOptions.size()));
            }
        } else if (RANDOM.nextInt(50) == 0) {
            soundIndex = 1;
        }
        Optional<Object> soundRegistryObject = switch (soundIndex) {
            case 1 -> Optional.of(ModSounds.GEIGER_1);
            case 2 -> Optional.of(ModSounds.GEIGER_2);
            case 3 -> Optional.of(ModSounds.GEIGER_3);
            case 4 -> Optional.of(ModSounds.GEIGER_4);
            case 5 -> Optional.of(ModSounds.GEIGER_5);
            case 6 -> Optional.of(ModSounds.GEIGER_6);
            default -> Optional.empty();
        };
        soundRegistryObject.ifPresent(regObject -> level.m_5594_(null, pos, (SoundEvent)regObject.get(), SoundSource.BLOCKS, 1.0f, 1.0f));
    }

    public float getLastMeasuredRads() {
        return this.lastMeasuredRads;
    }

    protected void m_183515_(@Nonnull CompoundTag pTag) {
        pTag.m_128350_("lastMeasuredRads", this.lastMeasuredRads);
        super.m_183515_(pTag);
    }

    public void m_142466_(@Nonnull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.lastMeasuredRads = pTag.m_128457_("lastMeasuredRads");
    }
}

