/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity;

import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.client.ClientSoundManager;
import com.hbm_m.energy.BlockEntityEnergyStorage;
import com.hbm_m.item.ItemBlueprintFolder;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.menu.MachineAdvancedAssemblerMenu;
import com.hbm_m.module.machine.MachineModuleAdvancedAssembler;
import com.hbm_m.multiblock.IFrameSupportable;
import com.hbm_m.multiblock.MultiblockStructureHelper;
import com.hbm_m.recipe.AssemblerRecipe;
import com.hbm_m.sound.AdvancedAssemblerSoundInstance;
import com.hbm_m.sound.ModSounds;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MachineAdvancedAssemblerBlockEntity
extends BlockEntity
implements MenuProvider,
IFrameSupportable {
    private final ItemStackHandler itemHandler = new ItemStackHandler(17){

        protected void onContentsChanged(int slot) {
            String recipePool;
            AssemblerRecipe currentRecipe;
            ItemStack folderStack;
            MachineAdvancedAssemblerBlockEntity.this.m_6596_();
            if (slot == 1 && MachineAdvancedAssemblerBlockEntity.this.f_58857_ != null && !MachineAdvancedAssemblerBlockEntity.this.f_58857_.m_5776_() && (folderStack = MachineAdvancedAssemblerBlockEntity.this.getBlueprintFolder()).m_41619_() && MachineAdvancedAssemblerBlockEntity.this.selectedRecipeId != null && (currentRecipe = MachineAdvancedAssemblerBlockEntity.this.getSelectedRecipe()) != null && (recipePool = currentRecipe.getBlueprintPool()) != null && !recipePool.isEmpty()) {
                boolean wasCrafting = MachineAdvancedAssemblerBlockEntity.this.assemblerModule != null && MachineAdvancedAssemblerBlockEntity.this.assemblerModule.isProcessing();
                MachineAdvancedAssemblerBlockEntity.this.selectedRecipeId = null;
                if (MachineAdvancedAssemblerBlockEntity.this.assemblerModule != null) {
                    MachineAdvancedAssemblerBlockEntity.this.assemblerModule.setPreferredRecipe(null);
                    MachineAdvancedAssemblerBlockEntity.this.assemblerModule.resetProgress();
                }
                if (wasCrafting) {
                    MachineAdvancedAssemblerBlockEntity.this.f_58857_.m_5594_(null, MachineAdvancedAssemblerBlockEntity.this.f_58858_, (SoundEvent)ModSounds.ASSEMBLER_STOP.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
                }
                MachineAdvancedAssemblerBlockEntity.this.f_58857_.m_7260_(MachineAdvancedAssemblerBlockEntity.this.f_58858_, MachineAdvancedAssemblerBlockEntity.this.m_58900_(), MachineAdvancedAssemblerBlockEntity.this.m_58900_(), 3);
            }
            if (MachineAdvancedAssemblerBlockEntity.this.f_58857_ != null && !MachineAdvancedAssemblerBlockEntity.this.f_58857_.m_5776_()) {
                MachineAdvancedAssemblerBlockEntity.this.f_58857_.m_7260_(MachineAdvancedAssemblerBlockEntity.this.f_58858_, MachineAdvancedAssemblerBlockEntity.this.m_58900_(), MachineAdvancedAssemblerBlockEntity.this.m_58900_(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
            }
            if (slot >= 4 && slot <= 15) {
                return MachineAdvancedAssemblerBlockEntity.this.assemblerModule == null || MachineAdvancedAssemblerBlockEntity.this.assemblerModule.isItemValidForSlot(slot, stack);
            }
            return super.isItemValid(slot, stack);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }
    };
    private final BlockEntityEnergyStorage energyStorage = new BlockEntityEnergyStorage(100000, 1000){

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            if (received > 0 && !simulate) {
                MachineAdvancedAssemblerBlockEntity.this.m_6596_();
                MachineAdvancedAssemblerBlockEntity.this.syncEnergyToClients();
            }
            return received;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (extracted > 0 && !simulate) {
                MachineAdvancedAssemblerBlockEntity.this.m_6596_();
                MachineAdvancedAssemblerBlockEntity.this.syncEnergyToClients();
            }
            return extracted;
        }
    };
    public boolean frame = false;
    private final FluidTank inputTank = new FluidTank(4000);
    private final FluidTank outputTank = new FluidTank(4000);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<BlockEntityEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    private LazyOptional<FluidTank> lazyFluidHandler = LazyOptional.empty();
    private ResourceLocation selectedRecipeId = null;
    private int syncCounter = 0;
    private int previousEnergy = 0;
    private int energyDelta = 0;
    private int energyDeltaUpdateCounter = 0;
    private boolean clientIsCrafting = false;
    private boolean wasCraftingLastTick = false;
    private MachineModuleAdvancedAssembler assemblerModule;
    protected final ContainerData data;
    private static final int BLUEPRINT_FOLDER_SLOT = 1;
    @OnlyIn(value=Dist.CLIENT)
    private AdvancedAssemblerSoundInstance soundInstance;
    public final AssemblerArm[] arms = new AssemblerArm[2];
    public float ringAngle;
    public float prevRingAngle;
    private float ringTarget;
    private float ringSpeed;
    private int ringDelay;
    public long lastUseTick = 0L;

    public MachineAdvancedAssemblerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.ADVANCED_ASSEMBLY_MACHINE_BE.get(), pPos, pBlockState);
        for (int i = 0; i < this.arms.length; ++i) {
            this.arms[i] = new AssemblerArm();
        }
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> {
                        if (MachineAdvancedAssemblerBlockEntity.this.assemblerModule != null) {
                            yield MachineAdvancedAssemblerBlockEntity.this.assemblerModule.getProgressInt();
                        }
                        yield 0;
                    }
                    case 1 -> {
                        if (MachineAdvancedAssemblerBlockEntity.this.assemblerModule != null) {
                            yield MachineAdvancedAssemblerBlockEntity.this.assemblerModule.getMaxProgress();
                        }
                        yield 0;
                    }
                    case 2 -> MachineAdvancedAssemblerBlockEntity.this.energyStorage.getEnergyStored();
                    case 3 -> MachineAdvancedAssemblerBlockEntity.this.energyStorage.getMaxEnergyStored();
                    case 4 -> MachineAdvancedAssemblerBlockEntity.this.energyDelta;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
            }

            public int m_6499_() {
                return 5;
            }
        };
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getMaxProgress() {
        return this.assemblerModule != null ? this.assemblerModule.getMaxProgress() : 100;
    }

    @Override
    public boolean setFrameVisible(boolean visible) {
        if (this.frame != visible) {
            this.frame = visible;
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                MainRegistry.LOGGER.debug("[FRAME SET] \u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0440\u0430\u043c\u043a\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u043d\u0430 " + visible + ". \u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u043f\u0430\u043a\u0435\u0442 \u043a\u043b\u0438\u0435\u043d\u0442\u0443.");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isFrameVisible() {
        return this.frame;
    }

    @Override
    public void checkForFrame() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            MultiblockStructureHelper.updateFrameForController(this.f_58857_, this.f_58858_);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MachineAdvancedAssemblerBlockEntity pEntity) {
        if (level.m_5776_()) {
            pEntity.clientTick(level, pos, state);
        } else {
            pEntity.serverTick();
        }
    }

    public boolean isCrafting() {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            return this.clientIsCrafting;
        }
        return this.assemblerModule != null && this.assemblerModule.isProcessing();
    }

    public int getProgress() {
        return this.assemblerModule != null ? this.assemblerModule.getProgressInt() : 0;
    }

    private void serverTick() {
        this.chargeMachineFromBattery();
        if (this.assemblerModule == null && this.f_58857_ != null) {
            this.assemblerModule = new MachineModuleAdvancedAssembler(0, (IEnergyStorage)this.energyStorage, (IItemHandler)this.itemHandler, this.f_58857_);
        }
        if (this.assemblerModule != null) {
            AssemblerRecipe recipe;
            String currentPool;
            String recipePool;
            AssemblerRecipe currentRecipe;
            boolean wasCrafting = this.assemblerModule.isProcessing();
            ItemStack blueprintStack = this.itemHandler.getStackInSlot(1);
            if (this.selectedRecipeId != null && (currentRecipe = this.getSelectedRecipe()) != null && (recipePool = currentRecipe.getBlueprintPool()) != null && !recipePool.isEmpty() && !recipePool.equals(currentPool = ItemBlueprintFolder.getBlueprintPool(blueprintStack))) {
                this.selectedRecipeId = null;
                this.assemblerModule.setPreferredRecipe(null);
                this.assemblerModule.resetProgress();
                if (wasCrafting) {
                    this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.ASSEMBLER_STOP.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
                }
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                return;
            }
            if (this.selectedRecipeId != null && this.assemblerModule.getPreferredRecipe() == null && (recipe = this.getSelectedRecipe()) != null) {
                this.assemblerModule.setPreferredRecipe(recipe);
            }
            this.assemblerModule.update(1.0, 1.0, true, blueprintStack);
            boolean isCraftingNow = this.assemblerModule.isProcessing();
            if (wasCrafting && !isCraftingNow) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.ASSEMBLER_STOP.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            if (this.selectedRecipeId == null) {
                ResourceLocation moduleRecipeId;
                ResourceLocation resourceLocation = moduleRecipeId = this.assemblerModule.getCurrentRecipe() != null ? ((AssemblerRecipe)this.assemblerModule.getCurrentRecipe()).m_6423_() : null;
                if (!Objects.equals(this.selectedRecipeId, moduleRecipeId)) {
                    this.selectedRecipeId = moduleRecipeId;
                    this.m_6596_();
                    if (this.f_58857_ != null) {
                        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                    }
                }
            }
            if (wasCrafting != isCraftingNow) {
                this.m_6596_();
                if (this.f_58857_ != null) {
                    this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                }
            }
            if (this.assemblerModule.needsSync) {
                this.m_6596_();
            }
            if (isCraftingNow) {
                this.m_6596_();
            }
        }
        ++this.energyDeltaUpdateCounter;
        if (this.energyDeltaUpdateCounter >= 20) {
            int currentEnergy = this.energyStorage.getEnergyStored();
            int totalChange = currentEnergy - this.previousEnergy;
            this.energyDelta = totalChange / 20;
            this.previousEnergy = currentEnergy;
            this.energyDeltaUpdateCounter = 0;
        }
        ++this.syncCounter;
        if (this.syncCounter >= 5) {
            this.syncCounter = 0;
            this.m_6596_();
        }
    }

    public int getEnergyDelta() {
        return this.energyDelta;
    }

    private void syncEnergyToClients() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public ItemStack getBlueprintFolder() {
        return this.itemHandler.getStackInSlot(1);
    }

    public List<AssemblerRecipe> getAvailableRecipes() {
        if (this.f_58857_ == null) {
            return List.of();
        }
        ItemStack folderStack = this.getBlueprintFolder();
        String activePool = ItemBlueprintFolder.getBlueprintPool(folderStack);
        List allRecipes = this.f_58857_.m_7465_().m_44013_((RecipeType)AssemblerRecipe.Type.INSTANCE);
        ArrayList<AssemblerRecipe> result = new ArrayList<AssemblerRecipe>();
        for (AssemblerRecipe recipe : allRecipes) {
            String recipePool = recipe.getBlueprintPool();
            if (recipePool == null || recipePool.isEmpty()) {
                result.add(recipe);
                continue;
            }
            if (activePool == null || activePool.isEmpty() || !activePool.equals(recipePool)) continue;
            result.add(recipe);
        }
        return result;
    }

    private void chargeMachineFromBattery() {
        ItemStack batteryStack = this.itemHandler.getStackInSlot(0);
        if (batteryStack.m_41619_()) {
            return;
        }
        batteryStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(batteryEnergy -> {
            int spaceAvailable = this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored();
            if (spaceAvailable <= 0) {
                return;
            }
            int maxTransfer = Math.min(spaceAvailable, this.energyStorage.getMaxReceive());
            int extracted = batteryEnergy.extractEnergy(maxTransfer, false);
            if (extracted > 0) {
                this.energyStorage.receiveEnergy(extracted, false);
                this.m_6596_();
            }
        });
    }

    public void m_7651_() {
        if (this.f_58857_.f_46443_) {
            ClientSoundManager.updateSound(this, false, null);
        }
        super.m_7651_();
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        ClientSoundManager.updateSound(this, this.isCrafting(), () -> new AdvancedAssemblerSoundInstance(this.m_58899_()));
        this.prevRingAngle = this.ringAngle;
        for (AssemblerArm arm : this.arms) {
            arm.updateInterp();
            if (this.isCrafting()) {
                arm.updateArm(level, pos, level.f_46441_);
                continue;
            }
            arm.returnToNullPos();
        }
        boolean craftingNow = this.isCrafting();
        if (craftingNow && !this.wasCraftingLastTick) {
            this.ringTarget = (level.f_46441_.m_188501_() * 2.0f - 1.0f) * 135.0f;
            this.ringSpeed = 10.0f + level.f_46441_.m_188501_() * 5.0f;
            this.ringDelay = 0;
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)ModSounds.ASSEMBLER_START.get(), SoundSource.BLOCKS, 0.5f, 1.0f, false);
        }
        this.wasCraftingLastTick = craftingNow;
        if (craftingNow) {
            if (this.ringAngle != this.ringTarget) {
                float ringDelta = Mth.m_14177_((float)(this.ringTarget - this.ringAngle));
                if (Math.abs(ringDelta) <= this.ringSpeed) {
                    this.ringAngle = this.ringTarget;
                    this.ringDelay = 20 + level.f_46441_.m_188503_(21);
                } else {
                    this.ringAngle += Math.signum(ringDelta) * this.ringSpeed;
                }
            } else if (this.ringDelay > 0) {
                --this.ringDelay;
                if (this.ringDelay == 0) {
                    level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)ModSounds.ASSEMBLER_START.get(), SoundSource.BLOCKS, 0.3f, 1.0f, false);
                    this.ringTarget = (level.f_46441_.m_188501_() * 2.0f - 1.0f) * 135.0f;
                    this.ringSpeed = 10.0f + level.f_46441_.m_188501_() * 5.0f;
                }
            }
        } else {
            this.ringAngle = Mth.m_14179_((float)0.1f, (float)this.ringAngle, (float)0.0f);
        }
    }

    public void setSelectedRecipe(ResourceLocation recipeId) {
        boolean wasCrafting = this.assemblerModule != null && this.assemblerModule.isProcessing();
        this.selectedRecipeId = recipeId;
        if (this.assemblerModule != null && this.f_58857_ != null) {
            AssemblerRecipe recipe = this.f_58857_.m_7465_().m_44043_(recipeId).filter(r -> r instanceof AssemblerRecipe).map(r -> (AssemblerRecipe)r).orElse(null);
            this.assemblerModule.setPreferredRecipe(recipe);
            this.assemblerModule.resetProgress();
            if (wasCrafting) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.ASSEMBLER_STOP.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public ResourceLocation getSelectedRecipeId() {
        return this.selectedRecipeId;
    }

    @Nullable
    public AssemblerRecipe getSelectedRecipe() {
        if (this.selectedRecipeId == null || this.f_58857_ == null) {
            return null;
        }
        return this.f_58857_.m_7465_().m_44043_(this.selectedRecipeId).filter(recipe -> recipe instanceof AssemblerRecipe).map(recipe -> (AssemblerRecipe)recipe).orElse(null);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyHandler = LazyOptional.of(() -> this.energyStorage);
        this.lazyFluidHandler = LazyOptional.of(() -> this.inputTank);
        if (this.f_58857_ != null && this.assemblerModule == null) {
            this.assemblerModule = new MachineModuleAdvancedAssembler(0, (IEnergyStorage)this.energyStorage, (IItemHandler)this.itemHandler, this.f_58857_);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyHandler.invalidate();
        this.lazyFluidHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("energy", this.energyStorage.getEnergyStored());
        nbt.m_128365_("input_tank", (Tag)this.inputTank.writeToNBT(new CompoundTag()));
        nbt.m_128365_("output_tank", (Tag)this.outputTank.writeToNBT(new CompoundTag()));
        nbt.m_128356_("last_use_tick", this.lastUseTick);
        nbt.m_128379_("hasFrame", this.frame);
        nbt.m_128405_("PreviousEnergy", this.previousEnergy);
        nbt.m_128405_("EnergyDelta", this.energyDelta);
        nbt.m_128379_("HasRecipe", this.selectedRecipeId != null);
        if (this.selectedRecipeId != null) {
            nbt.m_128359_("SelectedRecipe", this.selectedRecipeId.toString());
        }
        if (this.assemblerModule != null) {
            CompoundTag moduleTag = new CompoundTag();
            this.assemblerModule.writeToNBT(moduleTag);
            nbt.m_128365_("AssemblerModule", (Tag)moduleTag);
        }
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        if (nbt.m_128441_("folder_data")) {
            CompoundTag folderTag = nbt.m_128469_("folder_data");
            ItemStack folderStack = this.getBlueprintFolder();
            if (!folderStack.m_41619_()) {
                String pool = folderTag.m_128461_("blueprintPool");
                ItemBlueprintFolder.writeBlueprintPool(folderStack, pool);
            }
        }
        this.energyStorage.setEnergy(nbt.m_128451_("energy"));
        this.inputTank.readFromNBT(nbt.m_128469_("input_tank"));
        this.outputTank.readFromNBT(nbt.m_128469_("output_tank"));
        this.frame = nbt.m_128471_("hasFrame");
        this.clientIsCrafting = nbt.m_128471_("is_crafting");
        this.previousEnergy = nbt.m_128451_("PreviousEnergy");
        this.energyDelta = nbt.m_128451_("EnergyDelta");
        this.selectedRecipeId = nbt.m_128441_("HasRecipe") && nbt.m_128471_("HasRecipe") ? ResourceLocation.m_135820_((String)nbt.m_128461_("SelectedRecipe")) : null;
        if (nbt.m_128441_("AssemblerModule") && this.f_58857_ != null) {
            if (this.assemblerModule == null) {
                this.assemblerModule = new MachineModuleAdvancedAssembler(0, (IEnergyStorage)this.energyStorage, (IItemHandler)this.itemHandler, this.f_58857_);
            }
            this.assemblerModule.readFromNBT(nbt.m_128469_("AssemblerModule"));
        }
        this.lastUseTick = nbt.m_128454_("last_use_tick");
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("HasRecipe", this.selectedRecipeId != null);
        if (this.selectedRecipeId != null) {
            tag.m_128359_("SelectedRecipe", this.selectedRecipeId.toString());
        }
        tag.m_128379_("is_crafting", this.isCrafting());
        tag.m_128379_("hasFrame", this.frame);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("energy", this.energyStorage.getEnergyStored());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbt = pkt.m_131708_();
        if (nbt != null) {
            boolean wasCrafting = this.isCrafting();
            this.handleUpdateTag(nbt);
            if (this.f_58857_ != null && this.f_58857_.f_46443_ && wasCrafting && !this.isCrafting()) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.ASSEMBLER_STOP.get(), SoundSource.BLOCKS, 0.25f, 1.5f);
            }
        }
        super.onDataPacket(net, pkt);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.hbm_m.advanced_assembly_machine");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new MachineAdvancedAssemblerMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public static class AssemblerArm {
        public float[] angles = new float[4];
        public float[] prevAngles = new float[4];
        private float[] targetAngles = new float[4];
        private float[] speed = new float[4];
        private ArmActionState state = ArmActionState.ASSUME_POSITION;
        private int actionDelay = 0;
        private static final float[][] POSITIONS = new float[][]{{45.0f, -15.0f, -5.0f}, {15.0f, 15.0f, -15.0f}, {25.0f, 10.0f, -15.0f}, {30.0f, 0.0f, -10.0f}, {70.0f, -10.0f, -25.0f}};

        public AssemblerArm() {
            this.resetSpeed();
        }

        public void updateInterp() {
            System.arraycopy(this.angles, 0, this.prevAngles, 0, this.angles.length);
        }

        public void returnToNullPos() {
            int i;
            for (i = 0; i < 4; ++i) {
                this.targetAngles[i] = 0.0f;
            }
            for (i = 0; i < 3; ++i) {
                this.speed[i] = 3.0f;
            }
            this.speed[3] = 0.25f;
            this.state = ArmActionState.RETRACT_STRIKER;
            this.move();
        }

        private void resetSpeed() {
            this.speed[0] = 15.0f;
            this.speed[1] = 15.0f;
            this.speed[2] = 15.0f;
            this.speed[3] = 0.5f;
        }

        public void updateArm(Level level, BlockPos pos, RandomSource random) {
            this.resetSpeed();
            if (this.actionDelay > 0) {
                --this.actionDelay;
                return;
            }
            switch (this.state) {
                case ASSUME_POSITION: {
                    if (!this.move()) break;
                    this.actionDelay = 2;
                    this.state = ArmActionState.EXTEND_STRIKER;
                    this.targetAngles[3] = -0.75f;
                    break;
                }
                case EXTEND_STRIKER: {
                    if (!this.move()) break;
                    level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)ModSounds.ASSEMBLER_STRIKE_RANDOM.get(), SoundSource.BLOCKS, 0.5f, 1.0f, false);
                    this.state = ArmActionState.RETRACT_STRIKER;
                    this.targetAngles[3] = 0.0f;
                    break;
                }
                case RETRACT_STRIKER: {
                    if (!this.move()) break;
                    this.actionDelay = 2 + random.m_188503_(5);
                    this.chooseNewArmPosition(random);
                    this.state = ArmActionState.ASSUME_POSITION;
                }
            }
        }

        public void chooseNewArmPosition(RandomSource random) {
            int chosen = random.m_188503_(POSITIONS.length);
            this.targetAngles[0] = POSITIONS[chosen][0];
            this.targetAngles[1] = POSITIONS[chosen][1];
            this.targetAngles[2] = POSITIONS[chosen][2];
        }

        private boolean move() {
            boolean didMove = false;
            for (int i = 0; i < this.angles.length; ++i) {
                if (this.angles[i] == this.targetAngles[i]) continue;
                didMove = true;
                float delta = Math.abs(this.angles[i] - this.targetAngles[i]);
                if (delta <= this.speed[i]) {
                    this.angles[i] = this.targetAngles[i];
                    continue;
                }
                int n = i;
                this.angles[n] = this.angles[n] + Math.signum(this.targetAngles[i] - this.angles[i]) * this.speed[i];
            }
            return !didMove;
        }

        private static enum ArmActionState {
            ASSUME_POSITION,
            EXTEND_STRIKER,
            RETRACT_STRIKER;

        }
    }

    public class AssemblerRecipeConfig {
        private static final Set<ResourceLocation> DISABLED_BASE_RECIPES = new HashSet<ResourceLocation>();

        public static boolean isRecipeEnabled(ResourceLocation recipeId) {
            return !DISABLED_BASE_RECIPES.contains(recipeId);
        }

        public static void loadConfig() {
        }
    }
}

