/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity;

import com.hbm_m.block.MachineAssemblerBlock;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.block.entity.UniversalMachinePartBlockEntity;
import com.hbm_m.block.entity.WireBlockEntity;
import com.hbm_m.client.ClientSoundManager;
import com.hbm_m.energy.BlockEntityEnergyStorage;
import com.hbm_m.item.ItemAssemblyTemplate;
import com.hbm_m.item.ItemCreativeBattery;
import com.hbm_m.menu.MachineAssemblerMenu;
import com.hbm_m.multiblock.MultiblockStructureHelper;
import com.hbm_m.multiblock.PartRole;
import com.hbm_m.recipe.AssemblerRecipe;
import com.hbm_m.sound.AssemblerSoundInstance;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MachineAssemblerBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(18){

        protected void onContentsChanged(int slot) {
            MachineAssemblerBlockEntity.this.m_6596_();
            if (MachineAssemblerBlockEntity.this.f_58857_ != null && !MachineAssemblerBlockEntity.this.f_58857_.m_5776_()) {
                MachineAssemblerBlockEntity.this.sendUpdateToClient();
            }
        }
    };
    private final BlockEntityEnergyStorage energyStorage = new BlockEntityEnergyStorage(100000, 250, 250);
    private boolean isCrafting = false;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 100;
    private int previousEnergy = 0;
    private int energyDelta = 0;
    private int energyDeltaUpdateCounter = 0;
    private static final int TEMPLATE_SLOT = 4;
    private static final int OUTPUT_SLOT = 5;
    private static final int INPUT_SLOT_START = 6;
    private static final int INPUT_SLOT_END = 17;
    private LazyOptional<IItemHandler> lazyInputProxy = LazyOptional.empty();
    private LazyOptional<IItemHandler> lazyOutputProxy = LazyOptional.empty();
    private static final int DATA_IS_CRAFTING = 4;
    private final Set<BlockPos> lastPullSources = new HashSet<BlockPos>();

    public MachineAssemblerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MACHINE_ASSEMBLER_BE.get(), pos, state);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> MachineAssemblerBlockEntity.this.progress;
                    case 1 -> MachineAssemblerBlockEntity.this.maxProgress;
                    case 2 -> MachineAssemblerBlockEntity.this.energyStorage.getEnergyStored();
                    case 3 -> MachineAssemblerBlockEntity.this.energyStorage.getMaxEnergyStored();
                    case 4 -> {
                        if (MachineAssemblerBlockEntity.this.isCrafting) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 5 -> MachineAssemblerBlockEntity.this.energyDelta;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        MachineAssemblerBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        MachineAssemblerBlockEntity.this.maxProgress = value;
                        break;
                    }
                    case 2: {
                        MachineAssemblerBlockEntity.this.energyStorage.setEnergy(value);
                        break;
                    }
                    case 4: {
                        MachineAssemblerBlockEntity.this.isCrafting = value != 0;
                        break;
                    }
                    case 5: {
                        MachineAssemblerBlockEntity.this.energyDelta = value;
                    }
                }
            }

            public int m_6499_() {
                return 6;
            }
        };
    }

    public LazyOptional<IItemHandler> getItemHandlerForPart(PartRole role) {
        if (role == PartRole.ITEM_INPUT) {
            if (!this.lazyInputProxy.isPresent()) {
                this.lazyInputProxy = LazyOptional.of(this::createInputProxy);
            }
            return this.lazyInputProxy;
        }
        if (role == PartRole.ITEM_OUTPUT) {
            if (!this.lazyOutputProxy.isPresent()) {
                this.lazyOutputProxy = LazyOptional.of(this::createOutputProxy);
            }
            return this.lazyOutputProxy;
        }
        return LazyOptional.empty();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyHandler.invalidate();
        this.lazyInputProxy.invalidate();
        this.lazyOutputProxy.invalidate();
    }

    @NotNull
    private IItemHandler createInputProxy() {
        return new IItemHandler(){

            public int getSlots() {
                return 12;
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return MachineAssemblerBlockEntity.this.itemHandler.getStackInSlot(slot + 6);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return MachineAssemblerBlockEntity.this.itemHandler.insertItem(slot + 6, stack, simulate);
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.f_41583_;
            }

            public int getSlotLimit(int slot) {
                return MachineAssemblerBlockEntity.this.itemHandler.getSlotLimit(slot + 6);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return MachineAssemblerBlockEntity.this.itemHandler.isItemValid(slot + 6, stack);
            }
        };
    }

    @NotNull
    private IItemHandler createOutputProxy() {
        return new IItemHandler(){

            public int getSlots() {
                return 1;
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return slot == 0 ? MachineAssemblerBlockEntity.this.itemHandler.getStackInSlot(5) : ItemStack.f_41583_;
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return slot == 0 ? MachineAssemblerBlockEntity.this.itemHandler.extractItem(5, amount, simulate) : ItemStack.f_41583_;
            }

            public int getSlotLimit(int slot) {
                return slot == 0 ? MachineAssemblerBlockEntity.this.itemHandler.getSlotLimit(5) : 0;
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return false;
            }
        };
    }

    private void pullIngredientsForOneCraft(AssemblerRecipe recipe) {
        if (this.f_58857_ == null || MachineAssemblerBlockEntity.hasResources(this, recipe)) {
            return;
        }
        this.lastPullSources.clear();
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        IdentityHashMap<Ingredient, Integer> required = new IdentityHashMap<Ingredient, Integer>();
        for (Ingredient ing : ingredients) {
            required.put(ing, required.getOrDefault(ing, 0) + 1);
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)MachineAssemblerBlock.FACING);
        MultiblockStructureHelper helper = ((MachineAssemblerBlock)this.m_58900_().m_60734_()).getStructureHelper();
        for (BlockPos localOffset : helper.getPartOffsets()) {
            Direction dirToNeighbor;
            int dz;
            int dx;
            BlockPos neighborPosGlobal;
            BlockEntity neighbor;
            BlockPos partPos;
            BlockEntity partBE;
            int x = localOffset.m_123341_();
            int y = localOffset.m_123342_();
            int z = localOffset.m_123343_();
            boolean isInputConveyor = y == 0 && x == 2 && (z == 0 || z == 1);
            if (!isInputConveyor || !((partBE = this.f_58857_.m_7702_(partPos = helper.getRotatedPos(this.f_58858_, localOffset, facing))) instanceof UniversalMachinePartBlockEntity) || (neighbor = this.f_58857_.m_7702_(neighborPosGlobal = partPos.m_7918_(dx = Integer.signum(partPos.m_123341_() - this.f_58858_.m_123341_()), 0, dz = Integer.signum(partPos.m_123343_() - this.f_58858_.m_123343_())))) == null || neighbor instanceof UniversalMachinePartBlockEntity || neighbor == this || this.lastPullSources.contains(neighborPosGlobal)) continue;
            int dxN = partPos.m_123341_() - neighborPosGlobal.m_123341_();
            int dzN = partPos.m_123343_() - neighborPosGlobal.m_123343_();
            if (dxN == 1 && dzN == 0) {
                dirToNeighbor = Direction.EAST;
            } else if (dxN == -1 && dzN == 0) {
                dirToNeighbor = Direction.WEST;
            } else if (dxN == 0 && dzN == 1) {
                dirToNeighbor = Direction.SOUTH;
            } else {
                if (dxN != 0 || dzN != -1) continue;
                dirToNeighbor = Direction.NORTH;
            }
            IItemHandler cap = (IItemHandler)neighbor.getCapability(ForgeCapabilities.ITEM_HANDLER, dirToNeighbor).orElse(null);
            if (cap == null) continue;
            for (Map.Entry entry : required.entrySet()) {
                Ingredient ingredient = (Ingredient)entry.getKey();
                int need = (Integer)entry.getValue();
                int present = 0;
                for (int i = 6; i <= 17; ++i) {
                    ItemStack s = this.itemHandler.getStackInSlot(i);
                    if (s.m_41619_() || !ingredient.test(s)) continue;
                    present += s.m_41613_();
                }
                int missing = need - present;
                if (missing <= 0) continue;
                for (int slot = 0; slot < cap.getSlots() && missing > 0; ++slot) {
                    ItemStack simulated;
                    ItemStack possible = cap.getStackInSlot(slot);
                    if (possible.m_41619_() || !ingredient.test(possible) || (simulated = cap.extractItem(slot, missing, true)).m_41619_()) continue;
                    ItemStack toInsert = simulated.m_41777_();
                    for (int dest = 6; dest <= 17 && !toInsert.m_41619_(); ++dest) {
                        ItemStack remain = this.itemHandler.insertItem(dest, toInsert.m_41777_(), true);
                        int inserted = toInsert.m_41613_() - remain.m_41613_();
                        if (inserted <= 0) continue;
                        ItemStack actuallyExtracted = cap.extractItem(slot, inserted, false);
                        this.itemHandler.insertItem(dest, actuallyExtracted.m_41777_(), false);
                        this.lastPullSources.add(neighborPosGlobal);
                        this.m_6596_();
                        missing -= inserted;
                        toInsert = remain;
                    }
                }
            }
        }
    }

    private void pushOutputToNeighbors() {
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack out = this.itemHandler.getStackInSlot(5);
        if (out.m_41619_()) {
            return;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)MachineAssemblerBlock.FACING);
        MultiblockStructureHelper helper = ((MachineAssemblerBlock)this.m_58900_().m_60734_()).getStructureHelper();
        for (BlockPos localOffset : helper.getPartOffsets()) {
            boolean isOutputConveyor;
            if (out.m_41619_()) break;
            int x = localOffset.m_123341_();
            int y = localOffset.m_123342_();
            int z = localOffset.m_123343_();
            boolean bl = isOutputConveyor = y == 0 && x == -1 && (z == 0 || z == 1);
            if (!isOutputConveyor) continue;
            BlockPos partPos = helper.getRotatedPos(this.f_58858_, localOffset, facing);
            int dxOut = Integer.signum(partPos.m_123341_() - this.f_58858_.m_123341_());
            int dzOut = Integer.signum(partPos.m_123343_() - this.f_58858_.m_123343_());
            Direction outDir = Direction.m_122372_((float)dxOut, (float)0.0f, (float)dzOut);
            Direction facingDir = (Direction)this.m_58900_().m_61143_((Property)MachineAssemblerBlock.FACING);
            BlockPos neighborPos = partPos.m_121945_(outDir).m_121945_(facingDir.m_122424_());
            BlockEntity neighbor = this.f_58857_.m_7702_(neighborPos);
            if (neighbor == null || neighbor instanceof UniversalMachinePartBlockEntity || neighbor == this || this.lastPullSources.contains(neighborPos)) continue;
            Direction side1 = outDir.m_122424_();
            Direction side2 = facingDir;
            IItemHandler cap = (IItemHandler)neighbor.getCapability(ForgeCapabilities.ITEM_HANDLER, side1).orElse((Object)((IItemHandler)neighbor.getCapability(ForgeCapabilities.ITEM_HANDLER, side2).orElse(null)));
            if (cap == null) continue;
            ItemStack toInsert = out.m_41777_();
            for (int slot = 0; slot < cap.getSlots() && !toInsert.m_41619_(); ++slot) {
                ItemStack remaining = cap.insertItem(slot, toInsert.m_41777_(), false);
                if (remaining.m_41613_() >= toInsert.m_41613_()) continue;
                this.itemHandler.getStackInSlot(5).m_41774_(toInsert.m_41613_() - remaining.m_41613_());
                toInsert = remaining;
            }
            out = this.itemHandler.getStackInSlot(5);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setCrafting(boolean crafting) {
        this.isCrafting = crafting;
    }

    public boolean isCrafting() {
        return this.isCrafting;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.hbm_m.machine_assembler");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, @Nonnull Inventory pPlayerInventory, Player pPlayer) {
        this.sendUpdateToClient();
        return new MachineAssemblerMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyHandler = LazyOptional.of(() -> this.energyStorage);
    }

    protected void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("energy", this.energyStorage.getEnergyStored());
        nbt.m_128405_("progress", this.progress);
        nbt.m_128379_("isCrafting", this.isCrafting);
        nbt.m_128405_("previousEnergy", this.previousEnergy);
        nbt.m_128405_("energyDelta", this.energyDelta);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.energyStorage.setEnergy(nbt.m_128451_("energy"));
        this.progress = nbt.m_128451_("progress");
        boolean wasCrafting = this.isCrafting;
        this.isCrafting = nbt.m_128471_("isCrafting");
        this.previousEnergy = nbt.m_128451_("previousEnergy");
        this.energyDelta = nbt.m_128451_("energyDelta");
        if (this.f_58857_ != null && this.f_58857_.m_5776_() && wasCrafting && !this.isCrafting) {
            ClientSoundManager.updateSound(this, false, null);
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, MachineAssemblerBlockEntity pBlockEntity) {
        if (pLevel.f_46443_) {
            pBlockEntity.clientTick(pLevel, pPos, pState);
        } else {
            MachineAssemblerBlockEntity.serverTick(pLevel, pPos, pState, pBlockEntity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientTick(Level level, BlockPos pos, BlockState state) {
        ClientSoundManager.updateSound(this, this.isCrafting, () -> new AssemblerSoundInstance(this.m_58899_()));
    }

    private static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, MachineAssemblerBlockEntity pBlockEntity) {
        Optional<AssemblerRecipe> recipeOpt;
        pBlockEntity.requestEnergy();
        boolean ENERGY_SLOT_INDEX = false;
        ItemStack energySourceStack = pBlockEntity.itemHandler.getStackInSlot(0);
        if (!energySourceStack.m_41619_()) {
            if (energySourceStack.m_41720_() instanceof ItemCreativeBattery) {
                pBlockEntity.energyStorage.receiveEnergy(Integer.MAX_VALUE, false);
            } else {
                energySourceStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(itemEnergy -> {
                    int maxCanReceive;
                    int energyNeeded = pBlockEntity.energyStorage.getMaxEnergyStored() - pBlockEntity.energyStorage.getEnergyStored();
                    int energyToTransfer = Math.min(energyNeeded, maxCanReceive = pBlockEntity.energyStorage.getMaxReceive());
                    if (energyToTransfer > 0) {
                        int extracted = itemEnergy.extractEnergy(energyToTransfer, false);
                        pBlockEntity.energyStorage.receiveEnergy(extracted, false);
                    }
                });
            }
        }
        ++pBlockEntity.energyDeltaUpdateCounter;
        if (pBlockEntity.energyDeltaUpdateCounter >= 20) {
            int currentEnergy = pBlockEntity.energyStorage.getEnergyStored();
            pBlockEntity.energyDelta = (currentEnergy - pBlockEntity.previousEnergy) / 20;
            pBlockEntity.previousEnergy = currentEnergy;
            pBlockEntity.energyDeltaUpdateCounter = 0;
            MachineAssemblerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
        if ((recipeOpt = MachineAssemblerBlockEntity.getRecipeFromTemplate(pLevel, pBlockEntity)).isPresent()) {
            pBlockEntity.pullIngredientsForOneCraft(recipeOpt.get());
        }
        if (recipeOpt.isPresent() && MachineAssemblerBlockEntity.hasResources(pBlockEntity, recipeOpt.get()) && MachineAssemblerBlockEntity.canInsertResult(pBlockEntity, recipeOpt.get().m_8043_(null))) {
            AssemblerRecipe recipe = recipeOpt.get();
            int energyPerTick = recipe.getPowerConsumption();
            if (pBlockEntity.energyStorage.getEnergyStored() >= energyPerTick) {
                if (!pBlockEntity.isCrafting) {
                    pBlockEntity.isCrafting = true;
                    pBlockEntity.maxProgress = recipe.getDuration();
                    MachineAssemblerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
                    pBlockEntity.sendUpdateToClient();
                }
                pBlockEntity.energyStorage.extractEnergy(energyPerTick, false);
                ++pBlockEntity.progress;
                MachineAssemblerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
                if (pBlockEntity.progress >= pBlockEntity.maxProgress) {
                    MachineAssemblerBlockEntity.craftItem(pBlockEntity, recipe);
                    pBlockEntity.progress = 0;
                    pBlockEntity.pushOutputToNeighbors();
                    MachineAssemblerBlockEntity.getRecipeFromTemplate(pLevel, pBlockEntity).ifPresent(pBlockEntity::pullIngredientsForOneCraft);
                }
            } else if (pBlockEntity.isCrafting) {
                pBlockEntity.progress = 0;
                pBlockEntity.isCrafting = false;
                MachineAssemblerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
                pBlockEntity.sendUpdateToClient();
            }
        } else if (pBlockEntity.isCrafting) {
            pBlockEntity.progress = 0;
            pBlockEntity.isCrafting = false;
            MachineAssemblerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            pBlockEntity.sendUpdateToClient();
        }
        pBlockEntity.data.m_8050_(4, pBlockEntity.isCrafting ? 1 : 0);
    }

    private void requestEnergy() {
        if (this.energyStorage.getEnergyStored() >= this.energyStorage.getMaxEnergyStored()) {
            return;
        }
        int energyNeeded = this.energyStorage.getMaxReceive();
        if (energyNeeded <= 0) {
            return;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)MachineAssemblerBlock.FACING);
        MultiblockStructureHelper helper = ((MachineAssemblerBlock)this.m_58900_().m_60734_()).getStructureHelper();
        for (BlockPos localOffset : helper.getPartOffsets()) {
            boolean isEnergyConnector;
            int x = localOffset.m_123341_();
            int y = localOffset.m_123342_();
            int z = localOffset.m_123343_();
            boolean bl = isEnergyConnector = !(y != 0 || x != 0 && x != 1 || z != -1 && z != 2);
            if (isEnergyConnector) {
                BlockPos partPos = helper.getRotatedPos(this.f_58858_, localOffset, facing);
                BlockEntity partBE = this.f_58857_.m_7702_(partPos);
                if (!(partBE instanceof UniversalMachinePartBlockEntity)) continue;
                for (Direction dir : Direction.values()) {
                    int accepted;
                    BlockEntity neighbor = this.f_58857_.m_7702_(partPos.m_121945_(dir));
                    if (neighbor == null || neighbor instanceof UniversalMachinePartBlockEntity || neighbor == this) continue;
                    int extracted = 0;
                    if (neighbor instanceof WireBlockEntity) {
                        WireBlockEntity wire = (WireBlockEntity)neighbor;
                        extracted = wire.requestEnergy(energyNeeded, false);
                    } else {
                        IEnergyStorage source = (IEnergyStorage)neighbor.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_()).orElse(null);
                        if (source != null && source.canExtract()) {
                            extracted = source.extractEnergy(energyNeeded, false);
                        }
                    }
                    if (extracted > 0 && (energyNeeded -= (accepted = this.energyStorage.receiveEnergy(extracted, false))) <= 0) break;
                }
            }
            if (energyNeeded > 0) continue;
            break;
        }
    }

    private static Optional<AssemblerRecipe> getRecipeFromTemplate(Level level, MachineAssemblerBlockEntity pBlockEntity) {
        ItemStack templateStack = pBlockEntity.itemHandler.getStackInSlot(4);
        if (!(templateStack.m_41720_() instanceof ItemAssemblyTemplate)) {
            return Optional.empty();
        }
        ItemStack outputStack = ItemAssemblyTemplate.getRecipeOutput(templateStack);
        if (outputStack.m_41619_()) {
            return Optional.empty();
        }
        RecipeManager recipeManager = level.m_7465_();
        return recipeManager.m_44013_((RecipeType)AssemblerRecipe.Type.INSTANCE).stream().filter(r -> ItemStack.m_150942_((ItemStack)r.m_8043_(null), (ItemStack)outputStack)).findFirst();
    }

    private static boolean hasResources(MachineAssemblerBlockEntity pBlockEntity, AssemblerRecipe recipe) {
        SimpleContainer inventory = new SimpleContainer(12);
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            inventory.m_6836_(i, pBlockEntity.itemHandler.getStackInSlot(6 + i));
        }
        return recipe.matches(inventory, pBlockEntity.f_58857_);
    }

    private static boolean canInsertResult(MachineAssemblerBlockEntity pBlockEntity, ItemStack result) {
        ItemStack outputSlotStack = pBlockEntity.itemHandler.getStackInSlot(5);
        return outputSlotStack.m_41619_() || ItemStack.m_150942_((ItemStack)outputSlotStack, (ItemStack)result) && outputSlotStack.m_41613_() + result.m_41613_() <= outputSlotStack.m_41741_();
    }

    private static void craftItem(MachineAssemblerBlockEntity pBlockEntity, AssemblerRecipe recipe) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        ItemStack result = recipe.m_8043_(null).m_41777_();
        block0: for (Ingredient ingredient : ingredients) {
            for (int i = 6; i <= 17; ++i) {
                ItemStack stackInSlot = pBlockEntity.itemHandler.getStackInSlot(i);
                if (!ingredient.test(stackInSlot)) continue;
                pBlockEntity.itemHandler.extractItem(i, 1, false);
                continue block0;
            }
        }
        pBlockEntity.itemHandler.insertItem(5, result, false);
        pBlockEntity.sendUpdateToClient();
    }

    private void sendUpdateToClient() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("isCrafting", this.isCrafting);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.isCrafting = tag.m_128471_("isCrafting");
            if (tag.m_128441_("inventory")) {
                this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
            }
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
    }

    public void m_7651_() {
        if (this.f_58857_.f_46443_) {
            ClientSoundManager.updateSound(this, false, null);
        }
        super.m_7651_();
    }
}

