/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity;

import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.block.entity.WireBlockEntity;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.energy.BlockEntityEnergyStorage;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.menu.MachineBatteryMenu;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MachineBatteryBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2);
    private final BlockEntityEnergyStorage energyStorage = new BlockEntityEnergyStorage(1000000, 5000, 5000);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    protected final ContainerData data;
    private int energyDelta = 0;
    private int lastEnergy = 0;
    private Component customName;
    public int modeOnNoSignal = 0;
    public int modeOnSignal = 0;
    private final IEnergyStorage energyWrapper = this.createEnergyWrapper();
    public Priority priority = Priority.NORMAL;

    private IEnergyStorage createEnergyWrapper() {
        return new IEnergyStorage(){

            private boolean isInputAllowed() {
                if (MachineBatteryBlockEntity.this.f_58857_ == null) {
                    return false;
                }
                boolean hasSignal = MachineBatteryBlockEntity.this.f_58857_.m_276867_(MachineBatteryBlockEntity.this.f_58858_);
                int activeMode = hasSignal ? MachineBatteryBlockEntity.this.modeOnSignal : MachineBatteryBlockEntity.this.modeOnNoSignal;
                return activeMode == 0 || activeMode == 1;
            }

            private boolean isOutputAllowed() {
                if (MachineBatteryBlockEntity.this.f_58857_ == null) {
                    return false;
                }
                boolean hasSignal = MachineBatteryBlockEntity.this.f_58857_.m_276867_(MachineBatteryBlockEntity.this.f_58858_);
                int activeMode = hasSignal ? MachineBatteryBlockEntity.this.modeOnSignal : MachineBatteryBlockEntity.this.modeOnNoSignal;
                return activeMode == 0 || activeMode == 2;
            }

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return !this.isInputAllowed() ? 0 : MachineBatteryBlockEntity.this.energyStorage.receiveEnergy(maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return !this.isOutputAllowed() ? 0 : MachineBatteryBlockEntity.this.energyStorage.extractEnergy(maxExtract, simulate);
            }

            public int getEnergyStored() {
                return MachineBatteryBlockEntity.this.energyStorage.getEnergyStored();
            }

            public int getMaxEnergyStored() {
                return MachineBatteryBlockEntity.this.energyStorage.getMaxEnergyStored();
            }

            public boolean canExtract() {
                return this.isOutputAllowed() && MachineBatteryBlockEntity.this.energyStorage.canExtract();
            }

            public boolean canReceive() {
                return this.isInputAllowed() && MachineBatteryBlockEntity.this.energyStorage.canReceive();
            }
        };
    }

    public MachineBatteryBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.MACHINE_BATTERY_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> MachineBatteryBlockEntity.this.energyStorage.getEnergyStored();
                    case 1 -> MachineBatteryBlockEntity.this.energyStorage.getMaxEnergyStored();
                    case 2 -> MachineBatteryBlockEntity.this.energyDelta;
                    case 3 -> MachineBatteryBlockEntity.this.modeOnNoSignal;
                    case 4 -> MachineBatteryBlockEntity.this.modeOnSignal;
                    case 5 -> MachineBatteryBlockEntity.this.priority.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        MachineBatteryBlockEntity.this.energyStorage.setEnergy(pValue);
                        break;
                    }
                    case 2: {
                        MachineBatteryBlockEntity.this.energyDelta = pValue;
                        break;
                    }
                    case 3: {
                        MachineBatteryBlockEntity.this.modeOnNoSignal = pValue;
                        break;
                    }
                    case 4: {
                        MachineBatteryBlockEntity.this.modeOnSignal = pValue;
                        break;
                    }
                    case 5: {
                        MachineBatteryBlockEntity.this.priority = Priority.values()[pValue];
                    }
                }
            }

            public int m_6499_() {
                return 6;
            }
        };
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, MachineBatteryBlockEntity pBlockEntity) {
        if (pLevel.m_5776_()) {
            return;
        }
        boolean hasSignal = pLevel.m_276867_(pPos);
        int activeMode = hasSignal ? pBlockEntity.modeOnSignal : pBlockEntity.modeOnNoSignal;
        boolean canInput = false;
        boolean canOutput = false;
        switch (activeMode) {
            case 0: {
                canInput = true;
                canOutput = true;
                break;
            }
            case 1: {
                canInput = true;
                canOutput = false;
                break;
            }
            case 2: {
                canInput = false;
                canOutput = true;
                break;
            }
            case 3: {
                canInput = false;
                canOutput = false;
            }
        }
        if (canInput) {
            pBlockEntity.chargeFromItem();
        }
        if (canOutput) {
            pBlockEntity.dischargeToItem();
            pBlockEntity.pushEnergyToNeighbors();
        }
        pBlockEntity.energyDelta = pBlockEntity.energyStorage.getEnergyStored() - pBlockEntity.lastEnergy;
        pBlockEntity.lastEnergy = pBlockEntity.energyStorage.getEnergyStored();
        MachineBatteryBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
    }

    private void chargeFromItem() {
        this.itemHandler.getStackInSlot(0).getCapability(ForgeCapabilities.ENERGY).ifPresent(source -> {
            int canExtract = source.extractEnergy(this.energyStorage.getMaxReceive(), true);
            if (canExtract > 0) {
                int received = this.energyStorage.receiveEnergy(canExtract, false);
                source.extractEnergy(received, false);
            }
        });
    }

    private void dischargeToItem() {
        this.itemHandler.getStackInSlot(1).getCapability(ForgeCapabilities.ENERGY).ifPresent(target -> {
            int canReceive = target.receiveEnergy(this.energyStorage.getMaxExtract(), true);
            if (canReceive > 0) {
                int extracted = this.energyStorage.extractEnergy(canReceive, false);
                target.receiveEnergy(extracted, false);
            }
        });
    }

    private void pushEnergyToNeighbors() {
        if (ModClothConfig.get().enableDebugLogging) {
            MainRegistry.LOGGER.debug("[BATTERY >>>] pushEnergyToNeighbors at {} currentEnergy={}", (Object)this.f_58858_, (Object)this.energyStorage.getEnergyStored());
        }
        int energyToSend = this.energyStorage.extractEnergy(this.energyStorage.getMaxExtract(), true);
        UUID pushId = UUID.randomUUID();
        if (energyToSend <= 0) {
            return;
        }
        Level lvl = this.f_58857_;
        if (lvl == null) {
            return;
        }
        int[] totalSent = new int[]{0};
        for (Direction direction : Direction.values()) {
            if (totalSent[0] >= energyToSend) break;
            BlockEntity neighbor = lvl.m_7702_(this.f_58858_.m_121945_(direction));
            if (neighbor == null) continue;
            if (neighbor instanceof MachineBatteryBlockEntity) {
                int accepted;
                int theirEnergy;
                MachineBatteryBlockEntity otherBattery = (MachineBatteryBlockEntity)neighbor;
                int myEnergy = this.energyStorage.getEnergyStored();
                if (myEnergy <= (theirEnergy = otherBattery.energyStorage.getEnergyStored())) {
                    if (!ModClothConfig.get().enableDebugLogging) continue;
                    MainRegistry.LOGGER.debug("[BATTERY >>>] Skipping battery at {} (my: {}, their: {})", (Object)neighbor.m_58899_(), (Object)myEnergy, (Object)theirEnergy);
                    continue;
                }
                int difference = myEnergy - theirEnergy;
                int toSend = Math.min(difference / 2, energyToSend - totalSent[0]);
                if (toSend <= 0 || (accepted = otherBattery.energyWrapper.receiveEnergy(toSend, false)) <= 0) continue;
                this.energyStorage.extractEnergy(accepted, false);
                totalSent[0] = totalSent[0] + accepted;
                if (!ModClothConfig.get().enableDebugLogging) continue;
                MainRegistry.LOGGER.debug("[BATTERY >>>] Balanced {} FE to battery at {}", (Object)accepted, (Object)neighbor.m_58899_());
                continue;
            }
            if (neighbor instanceof WireBlockEntity) {
                WireBlockEntity wire = (WireBlockEntity)neighbor;
                int remaining = energyToSend - totalSent[0];
                int accepted = wire.acceptEnergy(remaining, pushId, this.f_58858_);
                if (accepted <= 0) continue;
                this.energyStorage.extractEnergy(accepted, false);
                totalSent[0] = totalSent[0] + accepted;
                continue;
            }
            LazyOptional neighborCapability = neighbor.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_());
            neighborCapability.ifPresent(neighborStorage -> {
                int remaining;
                int accepted;
                if (neighborStorage.canReceive() && (accepted = neighborStorage.receiveEnergy(remaining = energyToSend - totalSent[0], false)) > 0) {
                    this.energyStorage.extractEnergy(accepted, false);
                    totalSent[0] = totalSent[0] + accepted;
                }
            });
        }
    }

    public void handleButtonPress(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.modeOnNoSignal = (this.modeOnNoSignal + 1) % 4;
                break;
            }
            case 1: {
                this.modeOnSignal = (this.modeOnSignal + 1) % 4;
                break;
            }
            case 2: {
                this.priority = Priority.values()[(this.priority.ordinal() + 1) % Priority.values().length];
            }
        }
        this.m_6596_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, @Nonnull Inventory pPlayerInventory, @Nonnull Player pPlayer) {
        return new MachineBatteryMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyHandler = LazyOptional.of(() -> this.energyWrapper);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyHandler.invalidate();
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public Component getCustomName() {
        return this.customName;
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public Component m_5446_() {
        return this.hasCustomName() ? this.customName : Component.m_237115_((String)"block.hbm_m.machine_battery");
    }

    protected void m_183515_(@Nonnull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("energy", this.energyStorage.getEnergyStored());
        pTag.m_128405_("modeOnNoSignal", this.modeOnNoSignal);
        pTag.m_128405_("modeOnSignal", this.modeOnSignal);
        pTag.m_128405_("priority", this.priority.ordinal());
        if (this.customName != null) {
            pTag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public void m_142466_(@Nonnull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.energyStorage.setEnergy(pTag.m_128451_("energy"));
        this.modeOnNoSignal = pTag.m_128451_("modeOnNoSignal");
        this.modeOnSignal = pTag.m_128451_("modeOnSignal");
        this.priority = Priority.values()[pTag.m_128451_("priority")];
        if (pTag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)pTag.m_128461_("CustomName"));
        }
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    public int getComparatorPower() {
        return (int)Math.floor((double)this.energyStorage.getEnergyStored() / (double)this.energyStorage.getMaxEnergyStored() * 15.0);
    }

    public static enum Priority {
        LOW,
        NORMAL,
        HIGH;

    }
}

