/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity;

import com.hbm_m.block.MachineWoodBurnerBlock;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.block.entity.UniversalMachinePartBlockEntity;
import com.hbm_m.block.entity.WireBlockEntity;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.energy.BlockEntityEnergyStorage;
import com.hbm_m.item.ModItems;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.menu.MachineWoodBurnerMenu;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MachineWoodBurnerBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            MachineWoodBurnerBlockEntity.this.m_6596_();
        }
    };
    private final BlockEntityEnergyStorage energyStorage = new BlockEntityEnergyStorage(100000, 1000, 1000);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    private final IEnergyStorage energyWrapper = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return MachineWoodBurnerBlockEntity.this.energyStorage.extractEnergy(maxExtract, simulate);
        }

        public int getEnergyStored() {
            return MachineWoodBurnerBlockEntity.this.energyStorage.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return MachineWoodBurnerBlockEntity.this.energyStorage.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return MachineWoodBurnerBlockEntity.this.energyStorage.canExtract();
        }

        public boolean canReceive() {
            return false;
        }
    };
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> MachineWoodBurnerBlockEntity.this.energyStorage.getEnergyStored();
                case 1 -> MachineWoodBurnerBlockEntity.this.energyStorage.getMaxEnergyStored();
                case 2 -> MachineWoodBurnerBlockEntity.this.burnTime;
                case 3 -> MachineWoodBurnerBlockEntity.this.maxBurnTime;
                case 4 -> {
                    if (MachineWoodBurnerBlockEntity.this.isLit) {
                        yield 1;
                    }
                    yield 0;
                }
                case 5 -> {
                    if (MachineWoodBurnerBlockEntity.this.enabled) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    MachineWoodBurnerBlockEntity.this.energyStorage.setEnergy(pValue);
                    break;
                }
                case 2: {
                    MachineWoodBurnerBlockEntity.this.burnTime = pValue;
                    break;
                }
                case 3: {
                    MachineWoodBurnerBlockEntity.this.maxBurnTime = pValue;
                    break;
                }
                case 4: {
                    MachineWoodBurnerBlockEntity.this.isLit = pValue != 0;
                    break;
                }
                case 5: {
                    if (pValue == -1) {
                        MachineWoodBurnerBlockEntity.this.enabled = !MachineWoodBurnerBlockEntity.this.enabled;
                        MachineWoodBurnerBlockEntity.this.m_6596_();
                        break;
                    }
                    MachineWoodBurnerBlockEntity.this.enabled = pValue != 0;
                }
            }
        }

        public int m_6499_() {
            return 6;
        }
    };
    private int burnTime = 0;
    private int maxBurnTime = 0;
    private boolean isLit = false;
    private static final int FUEL_SLOT = 0;
    private static final int ASH_SLOT = 1;
    private boolean enabled = true;

    public MachineWoodBurnerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.WOOD_BURNER_BE.get(), pPos, pBlockState);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, MachineWoodBurnerBlockEntity pBlockEntity) {
        if (pLevel.m_5776_()) {
            return;
        }
        boolean wasLit = pBlockEntity.isLit;
        if (!pBlockEntity.enabled) {
            if (pBlockEntity.isLit) {
                pBlockEntity.isLit = false;
                pBlockEntity.burnTime = 0;
            }
        } else {
            if (pBlockEntity.burnTime <= 0 && pBlockEntity.canBurn()) {
                pBlockEntity.startBurning();
            }
            if (pBlockEntity.burnTime > 0) {
                --pBlockEntity.burnTime;
                pBlockEntity.isLit = true;
                if (pBlockEntity.energyStorage.getEnergyStored() < pBlockEntity.energyStorage.getMaxEnergyStored()) {
                    pBlockEntity.energyStorage.receiveEnergy(50, false);
                }
                if (pBlockEntity.burnTime <= 0) {
                    pBlockEntity.isLit = false;
                    pBlockEntity.maxBurnTime = 0;
                    if (pLevel.f_46441_.m_188501_() < 0.5f) {
                        ItemStack ashSlotStack = pBlockEntity.itemHandler.getStackInSlot(1);
                        if (ashSlotStack.m_41619_()) {
                            pBlockEntity.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)ModItems.WOOD_ASH_POWDER.get()));
                        } else if (ashSlotStack.m_41720_() == ModItems.WOOD_ASH_POWDER.get() && ashSlotStack.m_41613_() < 64) {
                            ashSlotStack.m_41769_(1);
                        }
                    }
                }
            } else {
                pBlockEntity.isLit = false;
            }
        }
        pBlockEntity.distributeEnergyToConnectors(pLevel, pPos, pState);
        if (wasLit != pBlockEntity.isLit) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)MachineWoodBurnerBlock.LIT, (Comparable)Boolean.valueOf(pBlockEntity.isLit)), 3);
        }
        MachineWoodBurnerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
    }

    private void distributeEnergyToConnectors(Level level, BlockPos controllerPos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)MachineWoodBurnerBlock.FACING);
        int energyAvailable = this.energyStorage.extractEnergy(this.energyStorage.getMaxExtract(), true);
        if (energyAvailable <= 0) {
            return;
        }
        BlockPos[] connectorOffsets = new BlockPos[]{new BlockPos(0, 0, 1), new BlockPos(1, 0, 1)};
        UUID pushId = UUID.randomUUID();
        int[] totalSent = new int[]{0};
        block0: for (BlockPos localOffset : connectorOffsets) {
            if (totalSent[0] >= energyAvailable) break;
            BlockPos worldOffset = this.rotateOffset(localOffset, facing);
            BlockPos connectorPos = controllerPos.m_121955_((Vec3i)worldOffset);
            for (Direction dir : Direction.values()) {
                if (totalSent[0] >= energyAvailable) continue block0;
                BlockPos neighborPos = connectorPos.m_121945_(dir);
                BlockEntity neighbor = level.m_7702_(neighborPos);
                if (neighbor == null || neighbor instanceof UniversalMachinePartBlockEntity || neighbor instanceof MachineWoodBurnerBlockEntity) continue;
                if (neighbor instanceof WireBlockEntity) {
                    WireBlockEntity wire = (WireBlockEntity)neighbor;
                    int remaining = energyAvailable - totalSent[0];
                    int accepted = wire.acceptEnergy(remaining, pushId, this.f_58858_);
                    if (accepted <= 0) continue;
                    this.energyStorage.extractEnergy(accepted, false);
                    totalSent[0] = totalSent[0] + accepted;
                    if (!ModClothConfig.get().enableDebugLogging) continue;
                    MainRegistry.LOGGER.debug("[GENERATOR] Sent {} FE to wire at {} via connector {}", (Object)accepted, (Object)neighborPos, (Object)connectorPos);
                    continue;
                }
                neighbor.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_()).ifPresent(storage -> {
                    int remaining;
                    int accepted;
                    if (storage.canReceive() && (accepted = storage.receiveEnergy(remaining = energyAvailable - totalSent[0], false)) > 0) {
                        this.energyStorage.extractEnergy(accepted, false);
                        totalSent[0] = totalSent[0] + accepted;
                        if (ModClothConfig.get().enableDebugLogging) {
                            MainRegistry.LOGGER.debug("[GENERATOR] Sent {} FE to {} at {} via connector {}", (Object)accepted, (Object)neighbor.getClass().getSimpleName(), (Object)neighborPos, (Object)connectorPos);
                        }
                    }
                });
            }
        }
    }

    private BlockPos rotateOffset(BlockPos local, Direction facing) {
        int x = local.m_123341_();
        int y = local.m_123342_();
        int z = local.m_123343_();
        return switch (facing) {
            case Direction.NORTH -> new BlockPos(x, y, z);
            case Direction.SOUTH -> new BlockPos(-x, y, -z);
            case Direction.WEST -> new BlockPos(z, y, -x);
            case Direction.EAST -> new BlockPos(-z, y, x);
            default -> local;
        };
    }

    private boolean canBurn() {
        ItemStack fuelStack = this.itemHandler.getStackInSlot(0);
        return !fuelStack.m_41619_() && this.getBurnTime(fuelStack.m_41720_()) > 0 && this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored();
    }

    private void startBurning() {
        ItemStack fuelStack = this.itemHandler.getStackInSlot(0);
        if (!fuelStack.m_41619_()) {
            this.burnTime = this.maxBurnTime = this.getBurnTime(fuelStack.m_41720_()) * 20;
            fuelStack.m_41774_(1);
        }
    }

    public int getBurnTime(Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        if (item == Items.f_42448_) {
            return 0;
        }
        int vanillaBurnTime = ForgeHooks.getBurnTime((ItemStack)stack, null);
        if (vanillaBurnTime <= 0) {
            return 0;
        }
        return vanillaBurnTime / 20;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, @Nonnull Inventory pPlayerInventory, @Nonnull Player pPlayer) {
        return new MachineWoodBurnerMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyHandler = LazyOptional.of(() -> this.energyWrapper);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyHandler.invalidate();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.hbm_m.wood_burner");
    }

    protected void m_183515_(@Nonnull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("energy", this.energyStorage.getEnergyStored());
        pTag.m_128405_("burnTime", this.burnTime);
        pTag.m_128405_("maxBurnTime", this.maxBurnTime);
        pTag.m_128379_("isLit", this.isLit);
        pTag.m_128379_("enabled", this.enabled);
    }

    public void m_142466_(@Nonnull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.energyStorage.setEnergy(pTag.m_128451_("energy"));
        this.burnTime = pTag.m_128451_("burnTime");
        this.maxBurnTime = pTag.m_128451_("maxBurnTime");
        this.isLit = pTag.m_128471_("isLit");
        this.enabled = pTag.m_128471_("enabled");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    public int getComparatorPower() {
        return (int)Math.floor((double)this.energyStorage.getEnergyStored() / (double)this.energyStorage.getMaxEnergyStored() * 15.0);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.m_6596_();
    }

    public BlockEntityEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }
}

