/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity;

import com.hbm_m.block.WireBlock;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.energy.WireNetworkManager;
import com.hbm_m.main.MainRegistry;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WireBlockEntity
extends BlockEntity {
    private int recheckTimer = 0;
    private final IEnergyStorage energyProxy = this.createEnergyProxy();
    private final LazyOptional<IEnergyStorage> lazyProxy = LazyOptional.of(() -> this.energyProxy);

    public WireBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ModBlockEntities.WIRE_BE.get(), pPos, pState);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            WireNetworkManager.get().onWireAdded(this.f_58857_, this.f_58858_);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            WireNetworkManager.get().onWireRemoved(this.f_58857_, this.f_58858_);
        }
    }

    public void scheduleRecheck() {
        this.recheckTimer = 20;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, WireBlockEntity be) {
        if (be.recheckTimer <= 0) {
            return;
        }
        --be.recheckTimer;
        if (be.recheckTimer == 0) {
            BlockState currentState = level.m_8055_(pos);
            Block block = currentState.m_60734_();
            if (!(block instanceof WireBlock)) {
                return;
            }
            WireBlock wireBlock = (WireBlock)block;
            BlockState correctState = wireBlock.m_49966_();
            for (Direction dir : Direction.values()) {
                correctState = (BlockState)correctState.m_61124_((Property)WireBlock.PROPERTIES_MAP.get(dir), (Comparable)Boolean.valueOf(wireBlock.canConnectTo((BlockGetter)level, pos, dir)));
            }
            if (currentState != correctState) {
                level.m_7731_(pos, correctState, 2);
            }
        }
    }

    public int requestEnergy(int maxRequest, boolean simulate) {
        Level lvl = this.f_58857_;
        if (lvl == null) {
            return 0;
        }
        return WireNetworkManager.get().requestEnergy(lvl, this.f_58858_, maxRequest, simulate);
    }

    public int acceptEnergy(int amount, UUID pushId) {
        Level lvl = this.f_58857_;
        if (lvl == null) {
            return 0;
        }
        if (ModClothConfig.get().enableDebugLogging) {
            MainRegistry.LOGGER.debug("[WIRE <<<] acceptEnergy id={} pos={} amount={}", (Object)pushId, (Object)this.f_58858_, (Object)amount);
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        return this.acceptEnergyInternal(amount, pushId, null, visited);
    }

    public int acceptEnergy(int amount, UUID pushId, BlockPos origin) {
        Level lvl = this.f_58857_;
        if (lvl == null) {
            return 0;
        }
        if (ModClothConfig.get().enableDebugLogging) {
            MainRegistry.LOGGER.debug("[WIRE <<<] acceptEnergy id={} pos={} amount={} origin={}", (Object)pushId, (Object)this.f_58858_, (Object)amount, (Object)origin);
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        return this.acceptEnergyInternal(amount, pushId, origin, visited);
    }

    private int acceptEnergyInternal(int amount, UUID pushId, BlockPos origin, Set<BlockPos> visited) {
        Level lvl = this.f_58857_;
        if (lvl == null) {
            return 0;
        }
        if (!visited.add(this.f_58858_)) {
            return 0;
        }
        int totalAccepted = 0;
        for (Direction dir : Direction.values()) {
            int accepted;
            IEnergyStorage target;
            if (totalAccepted >= amount) break;
            BlockEntity neighbor = lvl.m_7702_(this.f_58858_.m_121945_(dir));
            if (neighbor == null || origin != null && neighbor.m_58899_().equals((Object)origin)) continue;
            if (neighbor instanceof WireBlockEntity) {
                WireBlockEntity wireNeighbor = (WireBlockEntity)neighbor;
                if (visited.contains(wireNeighbor.f_58858_)) continue;
                totalAccepted += wireNeighbor.acceptEnergyInternal(amount - totalAccepted, pushId, origin, visited);
                continue;
            }
            LazyOptional cap = neighbor.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_());
            if (!cap.isPresent() || (target = (IEnergyStorage)cap.resolve().orElse(null)) == null || !target.canReceive() || (accepted = target.receiveEnergy(amount - totalAccepted, false)) <= 0) continue;
            if (ModClothConfig.get().enableDebugLogging) {
                MainRegistry.LOGGER.debug("[WIRE <<<] Delivered {} FE to {} at {}", (Object)accepted, (Object)target.getClass().getSimpleName(), (Object)neighbor.m_58899_());
            }
            totalAccepted += accepted;
        }
        return totalAccepted;
    }

    public int acceptEnergy(int amount, BlockPos origin) {
        return this.acceptEnergy(amount, UUID.randomUUID(), origin);
    }

    public int acceptEnergy(int amount) {
        return this.acceptEnergy(amount, UUID.randomUUID());
    }

    private IEnergyStorage createEnergyProxy() {
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return 0;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return 0;
            }

            public int getEnergyStored() {
                return 0;
            }

            public int getMaxEnergyStored() {
                return 0;
            }

            public boolean canExtract() {
                return true;
            }

            public boolean canReceive() {
                return true;
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyProxy.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyProxy.invalidate();
    }

    protected void m_183515_(@Nonnull CompoundTag pTag) {
        super.m_183515_(pTag);
    }

    public void m_142466_(@Nonnull CompoundTag pTag) {
        super.m_142466_(pTag);
    }
}

