/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.capability;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemEnergyStorage
implements IEnergyStorage {
    private final ItemStack stack;
    private final int capacity;
    private final int maxReceive;
    private final int maxExtract;
    private static final String NBT_KEY = "energy";

    public ItemEnergyStorage(ItemStack stack, int capacity, int maxReceive, int maxExtract) {
        this.stack = stack;
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public void setEnergy(int energy) {
        if (energy < 0) {
            energy = 0;
        }
        if (energy > this.capacity) {
            energy = this.capacity;
        }
        this.stack.m_41784_().m_128405_(NBT_KEY, energy);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energy = this.getEnergyStored();
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.setEnergy(energy + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energy = this.getEnergyStored();
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.setEnergy(energy - energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.stack.m_41782_() ? this.stack.m_41783_().m_128451_(NBT_KEY) : 0;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }
}

