/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client;

import com.hbm_m.client.ClientRadiationData;
import com.hbm_m.config.ModClothConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ChunkRadiationDebugRenderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        boolean isCreativeOrSpectator;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (player == null || level == null) {
            return;
        }
        ResourceLocation dimension = level.m_46472_().m_135782_();
        if (!ModClothConfig.get().enableDebugRender || !mc.f_91066_.f_92063_) {
            return;
        }
        boolean bl = isCreativeOrSpectator = player.m_7500_() || player.m_5833_();
        if (!ModClothConfig.get().debugRenderInSurvival && !isCreativeOrSpectator) {
            return;
        }
        Vec3 camPos = event.getCamera().m_90583_();
        int radius = ModClothConfig.get().debugRenderDistance;
        float scale = ModClothConfig.get().debugRenderTextSize;
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        Font font = mc.f_91062_;
        int playerChunkX = player.m_146902_().f_45578_;
        int playerChunkZ = player.m_146902_().f_45579_;
        boolean hasCeiling = level.m_6042_().f_63856_();
        try {
            poseStack.m_85836_();
            RenderSystem.disableDepthTest();
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    int chunkX = playerChunkX + dx;
                    int chunkZ = playerChunkZ + dz;
                    ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                    float value = ClientRadiationData.getRadiationForChunk(dimension, chunkPos);
                    if (value <= 1.0E-4f) continue;
                    double x = (chunkX << 4) + 8;
                    double z = (chunkZ << 4) + 8;
                    double y = hasCeiling ? player.m_20186_() + 1.0 : (double)level.m_5452_(Heightmap.Types.WORLD_SURFACE, BlockPos.m_274561_((double)x, (double)0.0, (double)z)).m_123342_() + 1.5;
                    String text = String.format("Rad: %.2f", Float.valueOf(value));
                    poseStack.m_85836_();
                    poseStack.m_85837_(x - camPos.f_82479_, y - camPos.f_82480_, z - camPos.f_82481_);
                    poseStack.m_252781_(mc.m_91290_().m_253208_());
                    poseStack.m_85841_(-scale, -scale, scale);
                    font.m_271703_(text, (float)(-font.m_92895_(text)) / 2.0f, 0.0f, 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)buffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                    poseStack.m_85849_();
                }
            }
            buffer.m_109911_();
        }
        finally {
            RenderSystem.enableDepthTest();
            poseStack.m_85849_();
        }
    }
}

