/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.client.ChunkRadiationDebugRenderer;
import com.hbm_m.client.ClientRenderHandler;
import com.hbm_m.client.DarkParticleHandler;
import com.hbm_m.client.model.TemplateModelLoader;
import com.hbm_m.client.model.loader.DoorModelLoader;
import com.hbm_m.client.model.loader.MachineAdvancedAssemblerModelLoader;
import com.hbm_m.client.model.loader.ProceduralWireLoader;
import com.hbm_m.client.model.render.DoorRenderer;
import com.hbm_m.client.model.render.MachineAdvancedAssemblerRenderer;
import com.hbm_m.client.overlay.GUIArmorTable;
import com.hbm_m.client.overlay.GUIBlastFurnace;
import com.hbm_m.client.overlay.GUIMachineAdvancedAssembler;
import com.hbm_m.client.overlay.GUIMachineAssembler;
import com.hbm_m.client.overlay.GUIMachineBattery;
import com.hbm_m.client.overlay.GUIMachinePress;
import com.hbm_m.client.overlay.GUIMachineWoodBurner;
import com.hbm_m.client.overlay.GUIShredder;
import com.hbm_m.client.overlay.OverlayGeiger;
import com.hbm_m.client.overlay.OverlayRadiationVisuals;
import com.hbm_m.client.tooltip.ItemTooltipComponent;
import com.hbm_m.client.tooltip.ItemTooltipComponentRenderer;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.config.ModConfigKeybindHandler;
import com.hbm_m.entity.ModEntities;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.menu.ModMenuTypes;
import com.hbm_m.particle.ModParticleTypes;
import com.hbm_m.particle.custom.DarkParticle;
import com.hbm_m.particle.custom.RadFogParticle;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="hbm_m", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        MainRegistry.LOGGER.info("FMLClientSetupEvent fired. Registering client-side FORGE event handlers.");
        MinecraftForge.EVENT_BUS.register(ModConfigKeybindHandler.class);
        MinecraftForge.EVENT_BUS.register(DarkParticleHandler.class);
        MinecraftForge.EVENT_BUS.register(ChunkRadiationDebugRenderer.class);
        MinecraftForge.EVENT_BUS.register(ClientRenderHandler.class);
        ModEntities.GRENADE_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        ModEntities.GRENADEHE_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        ModEntities.GRENADEFIRE_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        ModEntities.GRENADESMART_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        ModEntities.GRENADESLIME_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        ModEntities.GRENADEIF_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.ARMOR_TABLE_MENU.get()), GUIArmorTable::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.MACHINE_ASSEMBLER_MENU.get()), GUIMachineAssembler::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.ADVANCED_ASSEMBLY_MACHINE_MENU.get()), GUIMachineAdvancedAssembler::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.MACHINE_BATTERY_MENU.get()), GUIMachineBattery::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.BLAST_FURNACE_MENU.get()), GUIBlastFurnace::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.PRESS_MENU.get()), GUIMachinePress::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.SHREDDER_MENU.get()), GUIShredder::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.WOOD_BURNER_MENU.get()), GUIMachineWoodBurner::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.ADVANCED_ASSEMBLY_MACHINE_BE.get()), MachineAdvancedAssemblerRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.DOOR_ENTITY.get()), DoorRenderer::new);
        });
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation leavesLocation;
        Map modelRegistry = event.getModels();
        BakedModel originalModel = (BakedModel)modelRegistry.get(leavesLocation = new ModelResourceLocation(ModBlocks.WASTE_LEAVES.getId(), ""));
        if (originalModel != null) {
            LeavesModelWrapper wrappedModel = new LeavesModelWrapper(originalModel);
            event.getModels().put(leavesLocation, wrappedModel);
            if (ModClothConfig.get().enableDebugLogging) {
                MainRegistry.LOGGER.debug("Successfully wrapped waste_leaves model for dynamic render types.");
            }
        } else if (ModClothConfig.get().enableDebugLogging) {
            MainRegistry.LOGGER.warn("Could not find model for waste_leaves to wrap.");
        }
    }

    @SubscribeEvent
    public static void onModelRegister(ModelEvent.RegisterGeometryLoaders event) {
        event.register("procedural_wire", (IGeometryLoader)new ProceduralWireLoader());
        event.register("advanced_assembly_machine_loader", (IGeometryLoader)new MachineAdvancedAssemblerModelLoader());
        event.register("door", (IGeometryLoader)new DoorModelLoader());
        MainRegistry.LOGGER.info("Registered geometry loaders: procedural_wire, advanced_assembly_machine_loader, door");
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        ModConfigKeybindHandler.onRegisterKeyMappings(event);
        MainRegistry.LOGGER.info("Registered key mappings.");
    }

    @SubscribeEvent
    public static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticleTypes.DARK_PARTICLE.get(), DarkParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.RAD_FOG_PARTICLE.get(), RadFogParticle.Provider::new);
        MainRegistry.LOGGER.info("Registered custom particle providers.");
    }

    @SubscribeEvent
    public static void onRegisterGuiOverlays(RegisterGuiOverlaysEvent event) {
        MainRegistry.LOGGER.info("Registering GUI overlays...");
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "geiger_counter_hud", OverlayGeiger.GEIGER_HUD_OVERLAY);
        event.registerAbove(VanillaGuiOverlay.PORTAL.id(), "radiation_pixels", OverlayRadiationVisuals.RADIATION_PIXELS_OVERLAY);
        MainRegistry.LOGGER.info("GUI overlays registered.");
    }

    @SubscribeEvent
    public static void registerTooltipFactories(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(ItemTooltipComponent.class, ItemTooltipComponentRenderer::new);
    }

    @SubscribeEvent
    public static void onRegisterGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("template_loader", (IGeometryLoader)new TemplateModelLoader());
    }

    private static class LeavesModelWrapper
    extends BakedModelWrapper<BakedModel> {
        public LeavesModelWrapper(BakedModel originalModel) {
            super(originalModel);
        }

        public ChunkRenderTypeSet getRenderTypes(@Nonnull BlockState state, @Nonnull RandomSource rand, @Nonnull ModelData data) {
            GraphicsStatus graphics = (GraphicsStatus)Minecraft.m_91087_().f_91066_.m_232060_().m_231551_();
            if (graphics == GraphicsStatus.FANCY || graphics == GraphicsStatus.FABULOUS) {
                return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110457_()});
            }
            return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110451_()});
        }
    }
}

