/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.model;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.joml.Vector3f;

public class ModelHelper {
    public static void createCuboid(List<BakedQuad> quads, Vector3f from, Vector3f to, TextureAtlasSprite sprite, Map<Direction, UVSpec> uvMap, Set<Direction> facesToSkip) {
        for (Direction direction : Direction.values()) {
            UVSpec spec;
            if (facesToSkip.contains(direction) || (spec = uvMap.get(direction)) == null) continue;
            quads.add(ModelHelper.createQuad(from, to, direction, sprite, spec));
        }
    }

    private static BakedQuad createQuad(Vector3f from, Vector3f to, Direction direction, TextureAtlasSprite sprite, UVSpec spec) {
        QuadBakingVertexConsumer.Buffered builder = new QuadBakingVertexConsumer.Buffered();
        builder.setSprite(sprite);
        builder.setDirection(direction);
        builder.setHasAmbientOcclusion(true);
        Vector3f normal = direction.m_253071_();
        float x0 = from.x() / 16.0f;
        float y0 = from.y() / 16.0f;
        float z0 = from.z() / 16.0f;
        float x1 = to.x() / 16.0f;
        float y1 = to.y() / 16.0f;
        float z1 = to.z() / 16.0f;
        UVBox uv = spec.box();
        float u0 = sprite.m_118367_((double)uv.u0);
        float v0 = sprite.m_118393_((double)uv.v0);
        float u1 = sprite.m_118367_((double)uv.u1);
        float v1 = sprite.m_118393_((double)uv.v1);
        switch (direction) {
            case DOWN: {
                ModelHelper.putVertices((QuadBakingVertexConsumer)builder, normal, spec.rotate90(), new float[]{x0, y0, z1, u0, v1}, new float[]{x0, y0, z0, u0, v0}, new float[]{x1, y0, z0, u1, v0}, new float[]{x1, y0, z1, u1, v1});
                break;
            }
            case UP: {
                ModelHelper.putVertices((QuadBakingVertexConsumer)builder, normal, spec.rotate90(), new float[]{x0, y1, z0, u0, v0}, new float[]{x0, y1, z1, u0, v1}, new float[]{x1, y1, z1, u1, v1}, new float[]{x1, y1, z0, u1, v0});
                break;
            }
            case NORTH: {
                ModelHelper.putVertices((QuadBakingVertexConsumer)builder, normal, spec.rotate90(), new float[]{x0, y1, z0, u0, v0}, new float[]{x1, y1, z0, u1, v0}, new float[]{x1, y0, z0, u1, v1}, new float[]{x0, y0, z0, u0, v1});
                break;
            }
            case SOUTH: {
                ModelHelper.putVertices((QuadBakingVertexConsumer)builder, normal, spec.rotate90(), new float[]{x0, y0, z1, u0, v1}, new float[]{x1, y0, z1, u1, v1}, new float[]{x1, y1, z1, u1, v0}, new float[]{x0, y1, z1, u0, v0});
                break;
            }
            case WEST: {
                ModelHelper.putVertices((QuadBakingVertexConsumer)builder, normal, spec.rotate90(), new float[]{x0, y0, z1, u0, v1}, new float[]{x0, y1, z1, u0, v0}, new float[]{x0, y1, z0, u1, v0}, new float[]{x0, y0, z0, u1, v1});
                break;
            }
            case EAST: {
                ModelHelper.putVertices((QuadBakingVertexConsumer)builder, normal, spec.rotate90(), new float[]{x1, y0, z0, u0, v1}, new float[]{x1, y1, z0, u0, v0}, new float[]{x1, y1, z1, u1, v0}, new float[]{x1, y0, z1, u1, v1});
            }
        }
        return builder.getQuad();
    }

    private static void putVertices(QuadBakingVertexConsumer builder, Vector3f normal, boolean rotate, float[] v1, float[] v2, float[] v3, float[] v4) {
        if (!rotate) {
            ModelHelper.putVertex(builder, normal, v1[0], v1[1], v1[2], v1[3], v1[4]);
            ModelHelper.putVertex(builder, normal, v2[0], v2[1], v2[2], v2[3], v2[4]);
            ModelHelper.putVertex(builder, normal, v3[0], v3[1], v3[2], v3[3], v3[4]);
            ModelHelper.putVertex(builder, normal, v4[0], v4[1], v4[2], v4[3], v4[4]);
        } else {
            ModelHelper.putVertex(builder, normal, v1[0], v1[1], v1[2], v2[3], v2[4]);
            ModelHelper.putVertex(builder, normal, v2[0], v2[1], v2[2], v3[3], v3[4]);
            ModelHelper.putVertex(builder, normal, v3[0], v3[1], v3[2], v4[3], v4[4]);
            ModelHelper.putVertex(builder, normal, v4[0], v4[1], v4[2], v1[3], v1[4]);
        }
    }

    private static void putVertex(QuadBakingVertexConsumer builder, Vector3f normal, float x, float y, float z, float u, float v) {
        builder.m_5483_((double)x, (double)y, (double)z).m_7421_(u, v).m_7120_(0, 0).m_5601_(normal.x(), normal.y(), normal.z()).m_193479_(-1).m_5752_();
    }

    public record UVSpec(UVBox box, boolean rotate90) {
        public UVSpec(UVBox box) {
            this(box, false);
        }
    }

    public record UVBox(float u0, float v0, float u1, float v1) {
    }
}

