/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.model;

import com.hbm_m.block.WireBlock;
import com.hbm_m.client.model.ModelHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ProceduralWireBakedModel
implements BakedModel {
    private final TextureAtlasSprite sprite;
    private static final ModelHelper.UVSpec BODY_SPEC = new ModelHelper.UVSpec(new ModelHelper.UVBox(2.0f, 0.0f, 7.0f, 5.0f));
    private static final ModelHelper.UVSpec BODY_ROTATED_SPEC = new ModelHelper.UVSpec(new ModelHelper.UVBox(2.0f, 0.0f, 7.0f, 5.0f), true);
    private static final ModelHelper.UVSpec END_CONTACT_SPEC = new ModelHelper.UVSpec(new ModelHelper.UVBox(7.0f, 13.0f, 10.0f, 16.0f));
    private static final ModelHelper.UVSpec CORNER_CONTACT_SPEC = new ModelHelper.UVSpec(new ModelHelper.UVBox(4.0f, 11.0f, 9.0f, 16.0f));

    public ProceduralWireBakedModel(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        float min = 5.5f;
        float max = 10.5f;
        if (state == null) {
            ModelHelper.createCuboid(quads, new Vector3f(min, min, min), new Vector3f(max, max, max), this.sprite, Map.of(Direction.UP, CORNER_CONTACT_SPEC, Direction.DOWN, CORNER_CONTACT_SPEC, Direction.NORTH, BODY_SPEC, Direction.SOUTH, BODY_SPEC, Direction.WEST, BODY_SPEC, Direction.EAST, BODY_SPEC), Collections.emptySet());
            return quads;
        }
        HashSet<Direction> connections = new HashSet<Direction>();
        for (Direction dir : Direction.values()) {
            if (!((Boolean)state.m_61143_((Property)WireBlock.PROPERTIES_MAP.get(dir))).booleanValue()) continue;
            connections.add(dir);
        }
        boolean isStraight = connections.size() == 2 && connections.stream().anyMatch(d -> connections.contains(d.m_122424_()));
        boolean showCornerContacts = connections.size() <= 1 || !isStraight;
        Direction wireDirection = null;
        if (isStraight) {
            wireDirection = (Direction)connections.iterator().next();
        }
        HashMap<Direction, ModelHelper.UVSpec> coreUvMap = new HashMap<Direction, ModelHelper.UVSpec>();
        for (Direction direction : Direction.values()) {
            if (connections.contains(direction)) continue;
            if (showCornerContacts) {
                coreUvMap.put(direction, CORNER_CONTACT_SPEC);
                continue;
            }
            coreUvMap.put(direction, this.getBodyTextureForArmFace(wireDirection, direction));
        }
        ModelHelper.createCuboid(quads, new Vector3f(min, min, min), new Vector3f(max, max, max), this.sprite, coreUvMap, Collections.emptySet());
        for (Direction armDir : connections) {
            HashMap<Direction, ModelHelper.UVSpec> armUvMap = new HashMap<Direction, ModelHelper.UVSpec>();
            armUvMap.put(armDir, END_CONTACT_SPEC);
            for (Direction faceDir : Direction.values()) {
                if (faceDir.m_122434_() == armDir.m_122434_()) continue;
                armUvMap.put(faceDir, this.getBodyTextureForArmFace(armDir, faceDir));
            }
            Vector3f vector3f = new Vector3f(min, min, min);
            Vector3f to = new Vector3f(max, max, max);
            boolean isNegative = armDir.m_122421_() == Direction.AxisDirection.NEGATIVE;
            vector3f.setComponent(armDir.m_122434_().ordinal(), isNegative ? 0.0f : max);
            to.setComponent(armDir.m_122434_().ordinal(), isNegative ? min : 16.0f);
            ModelHelper.createCuboid(quads, vector3f, to, this.sprite, armUvMap, Set.of(armDir.m_122424_()));
        }
        return quads;
    }

    private ModelHelper.UVSpec getBodyTextureForArmFace(Direction armDir, Direction faceDir) {
        Direction.Axis armAxis = armDir.m_122434_();
        Direction.Axis faceAxis = faceDir.m_122434_();
        if (armAxis == Direction.Axis.Y) {
            return BODY_SPEC;
        }
        if (faceAxis == Direction.Axis.Y) {
            return armAxis == Direction.Axis.X ? BODY_ROTATED_SPEC : BODY_SPEC;
        }
        return BODY_ROTATED_SPEC;
    }

    @NotNull
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.sprite;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }
}

