/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.model.loader;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.hbm_m.client.model.DoorBakedModel;
import com.hbm_m.main.MainRegistry;
import com.mojang.math.Transformation;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.obj.ObjLoader;
import net.minecraftforge.client.model.obj.ObjModel;
import org.jetbrains.annotations.NotNull;

public class DoorModelLoader
implements IGeometryLoader<Geometry> {
    public Geometry read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
        String modelStr = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"model");
        MainRegistry.LOGGER.debug("DoorModelLoader.read: model string='{}'", (Object)modelStr);
        ResourceLocation model = ResourceLocation.parse((String)modelStr);
        String[] partNames = null;
        if (jsonObject.has("parts")) {
            JsonArray partsArray = jsonObject.getAsJsonArray("parts");
            partNames = new String[partsArray.size()];
            for (int i = 0; i < partsArray.size(); ++i) {
                partNames[i] = partsArray.get(i).getAsString();
            }
        }
        return new Geometry(model, partNames);
    }

    public static class Geometry
    implements IUnbakedGeometry<Geometry> {
        private final ResourceLocation modelLocation;
        private final String[] customPartNames;
        private static final Set<String> DEFAULT_PART_NAMES = Set.of("frame", "doorLeft", "doorRight");

        public Geometry(ResourceLocation modelLocation, String[] customPartNames) {
            this.modelLocation = modelLocation;
            this.customPartNames = customPartNames;
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelName) {
            ObjModel model;
            try {
                model = ObjLoader.INSTANCE.loadModel(new ObjModel.ModelSettings(this.modelLocation, true, false, true, true, null));
                MainRegistry.LOGGER.info("DoorModelLoader: Successfully loaded OBJ model: {}", (Object)this.modelLocation);
            }
            catch (Exception e) {
                MainRegistry.LOGGER.error("Failed to load OBJ door model: " + String.valueOf(this.modelLocation), (Throwable)e);
                throw new RuntimeException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c OBJ \u043c\u043e\u0434\u0435\u043b\u044c \u0434\u0432\u0435\u0440\u0438: " + String.valueOf(this.modelLocation), e);
            }
            Set<String> partNames = this.customPartNames != null ? Set.of(this.customPartNames) : DEFAULT_PART_NAMES;
            HashMap<String, BakedModel> bakedParts = new HashMap<String, BakedModel>();
            ModelState identityState = new ModelState(){

                @NotNull
                public Transformation m_6189_() {
                    return Transformation.m_121093_();
                }
            };
            for (String partName : partNames) {
                SinglePartBakingContext partContext = new SinglePartBakingContext(context, partName);
                BakedModel bakedPart = model.bake((IGeometryBakingContext)partContext, baker, spriteGetter, identityState, overrides, modelName);
                bakedParts.put(partName, bakedPart);
                MainRegistry.LOGGER.info("DoorModelLoader: Baked part '{}', quads count: {}", (Object)partName, (Object)bakedPart.m_213637_(null, null, RandomSource.m_216327_()).size());
            }
            if (!bakedParts.containsKey("Base")) {
                bakedParts.put("Base", model.bake((IGeometryBakingContext)new SinglePartBakingContext(context, "Base"), baker, spriteGetter, identityState, overrides, modelName));
            }
            MainRegistry.LOGGER.info("DoorModelLoader: Total baked parts: {}", (Object)bakedParts.size());
            return new DoorBakedModel(bakedParts, context.getTransforms());
        }

        private static class SinglePartBakingContext
        implements IGeometryBakingContext {
            private final IGeometryBakingContext parent;
            private final String visiblePart;

            public SinglePartBakingContext(IGeometryBakingContext parent, String visiblePart) {
                this.parent = parent;
                this.visiblePart = visiblePart;
            }

            public String getModelName() {
                return this.parent.getModelName();
            }

            public boolean isGui3d() {
                return this.parent.isGui3d();
            }

            public boolean useBlockLight() {
                return this.parent.useBlockLight();
            }

            public boolean useAmbientOcclusion() {
                return this.parent.useAmbientOcclusion();
            }

            public ItemTransforms getTransforms() {
                return this.parent.getTransforms();
            }

            public Material getMaterial(String name) {
                return this.parent.getMaterial(name);
            }

            public Transformation getRootTransform() {
                return this.parent.getRootTransform();
            }

            public boolean hasMaterial(String name) {
                return this.parent.hasMaterial(name);
            }

            public ResourceLocation getRenderTypeHint() {
                return this.parent.getRenderTypeHint();
            }

            public boolean isComponentVisible(String component, boolean fallback) {
                return component.equals(this.visiblePart) || component.startsWith(this.visiblePart + "/");
            }
        }
    }
}

