/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.model.loader;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.hbm_m.client.model.MachineAdvancedAssemblerBakedModel;
import com.hbm_m.main.MainRegistry;
import com.mojang.math.Transformation;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.obj.ObjLoader;
import net.minecraftforge.client.model.obj.ObjModel;
import org.jetbrains.annotations.NotNull;

public class MachineAdvancedAssemblerModelLoader
implements IGeometryLoader<Geometry> {
    public Geometry read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
        String modelStr = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"model");
        MainRegistry.LOGGER.debug("AdvancedAssemblyMachineModelLoader.read: model string='{}'", (Object)modelStr);
        ResourceLocation model = ResourceLocation.parse((String)modelStr);
        return new Geometry(model);
    }

    public static class Geometry
    implements IUnbakedGeometry<Geometry> {
        private final ResourceLocation modelLocation;
        private static final Set<String> PART_NAMES = Set.of("Base", "Frame", "Ring", "ArmLower1", "ArmUpper1", "Head1", "Spike1", "ArmLower2", "ArmUpper2", "Head2", "Spike2");

        public Geometry(ResourceLocation modelLocation) {
            this.modelLocation = modelLocation;
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelName) {
            ObjModel model;
            try {
                model = ObjLoader.INSTANCE.loadModel(new ObjModel.ModelSettings(this.modelLocation, true, false, true, true, null));
            }
            catch (Exception e) {
                throw new RuntimeException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c OBJ \u043c\u043e\u0434\u0435\u043b\u044c: " + String.valueOf(this.modelLocation), e);
            }
            HashMap<String, BakedModel> bakedParts = new HashMap<String, BakedModel>();
            ModelState identityState = new ModelState(){

                @NotNull
                public Transformation m_6189_() {
                    return Transformation.m_121093_();
                }
            };
            for (String partName : PART_NAMES) {
                SinglePartBakingContext partContext = new SinglePartBakingContext(context, partName);
                bakedParts.put(partName, model.bake((IGeometryBakingContext)partContext, baker, spriteGetter, identityState, overrides, modelName));
            }
            if (!bakedParts.containsKey("Base")) {
                bakedParts.put("Base", model.bake((IGeometryBakingContext)new SinglePartBakingContext(context, "Base"), baker, spriteGetter, identityState, overrides, modelName));
            }
            return new MachineAdvancedAssemblerBakedModel(bakedParts, context.getTransforms());
        }
    }

    private static class SinglePartBakingContext
    implements IGeometryBakingContext {
        private final IGeometryBakingContext parent;
        private final String visiblePart;

        public SinglePartBakingContext(IGeometryBakingContext parent, String visiblePart) {
            this.parent = parent;
            this.visiblePart = visiblePart;
        }

        public String getModelName() {
            return this.parent.getModelName();
        }

        public boolean isGui3d() {
            return this.parent.isGui3d();
        }

        public boolean useBlockLight() {
            return this.parent.useBlockLight();
        }

        public boolean useAmbientOcclusion() {
            return this.parent.useAmbientOcclusion();
        }

        public ItemTransforms getTransforms() {
            return this.parent.getTransforms();
        }

        public Material getMaterial(String name) {
            return this.parent.getMaterial(name);
        }

        public Transformation getRootTransform() {
            return this.parent.getRootTransform();
        }

        public boolean hasMaterial(String name) {
            return this.parent.hasMaterial(name);
        }

        public ResourceLocation getRenderTypeHint() {
            return this.parent.getRenderTypeHint();
        }

        public boolean isComponentVisible(String component, boolean fallback) {
            return component.equals(this.visiblePart) || component.startsWith(this.visiblePart + "/");
        }
    }
}

