/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.model.render;

import com.hbm_m.block.entity.DoorBlockEntity;
import com.hbm_m.client.model.DoorBakedModel;
import com.hbm_m.util.DoorDecl;
import com.hbm_m.util.LegacyAnimator;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;

public class DoorRenderer
implements BlockEntityRenderer<DoorBlockEntity> {
    private final float[] translation = new float[3];
    private final float[] origin = new float[3];
    private final float[] rotation = new float[3];

    public DoorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(DoorBlockEntity be, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        String[] partNames;
        if (!be.isController()) {
            return;
        }
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BakedModel originalModel = blockRenderer.m_110910_(be.m_58900_());
        if (!(originalModel instanceof DoorBakedModel)) {
            return;
        }
        DoorBakedModel model = (DoorBakedModel)originalModel;
        DoorDecl doorDecl = be.getDoorDecl();
        LegacyAnimator animator = new LegacyAnimator(poseStack, bufferSource, blockRenderer, packedLight, packedOverlay);
        float openTicks = be.getOpenProgress(partialTick) * (float)doorDecl.getOpenTime();
        animator.push();
        Direction facing = be.getFacing();
        animator.setupBlockTransform(facing);
        doorDecl.doOffsetTransform(animator);
        for (String partName : partNames = model.getPartNames()) {
            if (!doorDecl.doesRender(partName, false)) continue;
            animator.push();
            this.doPartTransform(animator, doorDecl, partName, openTicks);
            BakedModel partModel = model.getPart(partName);
            animator.renderPart(partModel);
            animator.pop();
        }
        animator.pop();
    }

    private void doPartTransform(LegacyAnimator animator, DoorDecl doorDecl, String partName, float openTicks) {
        doorDecl.getTranslation(partName, openTicks, false, this.translation);
        doorDecl.getOrigin(partName, this.origin);
        doorDecl.getRotation(partName, openTicks, this.rotation);
        animator.translate(this.origin[0], this.origin[1], this.origin[2]);
        if (this.rotation[0] != 0.0f) {
            animator.rotate(this.rotation[0], 1.0, 0.0, 0.0);
        }
        if (this.rotation[1] != 0.0f) {
            animator.rotate(this.rotation[1], 0.0, 1.0, 0.0);
        }
        if (this.rotation[2] != 0.0f) {
            animator.rotate(this.rotation[2], 0.0, 0.0, 1.0);
        }
        animator.translate(-this.origin[0] + this.translation[0], -this.origin[1] + this.translation[1], -this.origin[2] + this.translation[2]);
    }

    public int m_142163_() {
        return 256;
    }
}

