/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.model.render;

import com.hbm_m.block.MachineAdvancedAssemblerBlock;
import com.hbm_m.block.entity.MachineAdvancedAssemblerBlockEntity;
import com.hbm_m.client.model.MachineAdvancedAssemblerBakedModel;
import com.hbm_m.recipe.AssemblerRecipe;
import com.hbm_m.util.LegacyAnimator;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;

public class MachineAdvancedAssemblerRenderer
implements BlockEntityRenderer<MachineAdvancedAssemblerBlockEntity> {
    public MachineAdvancedAssemblerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(MachineAdvancedAssemblerBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BakedModel originalModel = blockRenderer.m_110910_(pBlockEntity.m_58900_());
        if (!(originalModel instanceof MachineAdvancedAssemblerBakedModel)) {
            return;
        }
        MachineAdvancedAssemblerBakedModel model = (MachineAdvancedAssemblerBakedModel)originalModel;
        LegacyAnimator animator = new LegacyAnimator(pPoseStack, pBufferSource, blockRenderer, pPackedLight, pPackedOverlay);
        animator.push();
        Direction facing = (Direction)pBlockEntity.m_58900_().m_61143_((Property)MachineAdvancedAssemblerBlock.FACING);
        animator.setupBlockTransform(facing);
        animator.renderPart(model.getPart("Base"));
        if (pBlockEntity.frame) {
            animator.renderPart(model.getPart("Frame"));
        }
        animator.push();
        float ringSpin = Mth.m_14179_((float)pPartialTick, (float)pBlockEntity.prevRingAngle, (float)pBlockEntity.ringAngle);
        float[] arm1Angles = this.getInterpolatedAngles(pBlockEntity.arms[0], pPartialTick);
        float[] arm2Angles = this.getInterpolatedAngles(pBlockEntity.arms[1], pPartialTick);
        animator.rotate(ringSpin, 0.0, 1.0, 0.0);
        animator.renderPart(model.getPart("Ring"));
        animator.push();
        animator.translate(0.0, 1.625, 0.9375);
        animator.rotate(arm1Angles[0], 1.0, 0.0, 0.0);
        animator.translate(0.0, -1.625, -0.9375);
        animator.renderPart(model.getPart("ArmLower1"));
        animator.translate(0.0, 2.375, 0.9375);
        animator.rotate(arm1Angles[1], 1.0, 0.0, 0.0);
        animator.translate(0.0, -2.375, -0.9375);
        animator.renderPart(model.getPart("ArmUpper1"));
        animator.translate(0.0, 2.375, 0.4375);
        animator.rotate(arm1Angles[2], 1.0, 0.0, 0.0);
        animator.translate(0.0, -2.375, -0.4375);
        animator.renderPart(model.getPart("Head1"));
        animator.translate(0.0, arm1Angles[3], 0.0);
        animator.renderPart(model.getPart("Spike1"));
        animator.pop();
        animator.push();
        animator.translate(0.0, 1.625, -0.9375);
        animator.rotate(-arm2Angles[0], 1.0, 0.0, 0.0);
        animator.translate(0.0, -1.625, 0.9375);
        animator.renderPart(model.getPart("ArmLower2"));
        animator.translate(0.0, 2.375, -0.9375);
        animator.rotate(-arm2Angles[1], 1.0, 0.0, 0.0);
        animator.translate(0.0, -2.375, 0.9375);
        animator.renderPart(model.getPart("ArmUpper2"));
        animator.translate(0.0, 2.375, -0.4375);
        animator.rotate(-arm2Angles[2], 1.0, 0.0, 0.0);
        animator.translate(0.0, -2.375, 0.4375);
        animator.renderPart(model.getPart("Head2"));
        animator.translate(0.0, arm2Angles[3], 0.0);
        animator.renderPart(model.getPart("Spike2"));
        animator.pop();
        animator.pop();
        animator.pop();
        this.renderRecipeIcon(pBlockEntity, pPartialTick, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay);
    }

    private void renderRecipeIcon(MachineAdvancedAssemblerBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        ResourceLocation selectedRecipeId = pBlockEntity.getSelectedRecipeId();
        if (selectedRecipeId == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        double distSq = mc.f_91074_.m_20275_((double)pBlockEntity.m_58899_().m_123341_() + 0.5, (double)pBlockEntity.m_58899_().m_123342_() + 1.0, (double)pBlockEntity.m_58899_().m_123343_() + 0.5);
        if (distSq > 1225.0) {
            return;
        }
        if (pBlockEntity.m_58904_() == null) {
            return;
        }
        pBlockEntity.m_58904_().m_7465_().m_44043_(selectedRecipeId).ifPresent(recipe -> {
            if (!(recipe instanceof AssemblerRecipe)) {
                return;
            }
            AssemblerRecipe assemblerRecipe = (AssemblerRecipe)recipe;
            ItemStack iconStack = assemblerRecipe.m_8043_(null);
            if (iconStack.m_41619_()) {
                return;
            }
            pPoseStack.m_85836_();
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            pPoseStack.m_85837_(0.0, 1.0625, 0.0);
            Item patt7083$temp = iconStack.m_41720_();
            if (patt7083$temp instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)patt7083$temp;
                Block block = blockItem.m_40614_();
                BakedModel blockModel = mc.m_91289_().m_110910_(block.m_49966_());
                if (blockModel.m_7539_()) {
                    pPoseStack.m_85837_(0.0, -0.0625, 0.0);
                } else {
                    pPoseStack.m_85837_(0.0, -0.125, 0.0);
                    pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
                }
            } else {
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                pPoseStack.m_85837_(-0.5, -0.5, -0.03);
            }
            pPoseStack.m_85841_(1.0f, 1.0f, 1.0f);
            ItemRenderer itemRenderer = mc.m_91291_();
            itemRenderer.m_269128_(iconStack, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, pBlockEntity.m_58904_(), 0);
            pPoseStack.m_85849_();
        });
    }

    private float[] getInterpolatedAngles(MachineAdvancedAssemblerBlockEntity.AssemblerArm arm, float pPartialTick) {
        float[] angles = new float[4];
        for (int i = 0; i < 4; ++i) {
            angles[i] = Mth.m_14179_((float)pPartialTick, (float)arm.prevAngles[i], (float)arm.angles[i]);
        }
        return angles;
    }
}

