/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.overlay;

import com.hbm_m.item.ItemAssemblyTemplate;
import com.hbm_m.menu.MachineAssemblerMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class GUIMachineAssembler
extends AbstractContainerScreen<MachineAssemblerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/gui/gui_assembler_old.png");
    private static final int TEMPLATE_SLOT_GUI_INDEX = 40;

    public GUIMachineAssembler(MachineAssemblerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 176;
        this.f_97727_ = 222;
        this.f_97729_ = 6;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7286_(@Nonnull GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.f_97735_;
        int y = this.f_97736_;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        int energyBarHeight = 52;
        int energy = ((MachineAssemblerMenu)this.f_97732_).getEnergyScaled(energyBarHeight);
        guiGraphics.m_280218_(TEXTURE, x + 116, y + 70 - energy, 176, 52 - energy, 16, energy);
        if (((MachineAssemblerMenu)this.f_97732_).isCrafting()) {
            int progressWidth = 83;
            guiGraphics.m_280218_(TEXTURE, x + 45, y + 82, 2, 222, ((MachineAssemblerMenu)this.f_97732_).getProgressScaled(progressWidth), 32);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        this.drawInfoPanels(guiGraphics, x, y);
    }

    private void drawInfoPanels(GuiGraphics guiGraphics, int x, int y) {
        this.drawInfoPanel(guiGraphics, x - 16, y + 16, 16, 16, 11);
        ItemStack templateStack = ((MachineAssemblerMenu)this.f_97732_).m_38853_(40).m_7993_();
        if (templateStack.m_41619_() || !(templateStack.m_41720_() instanceof ItemAssemblyTemplate)) {
            this.drawInfoPanel(guiGraphics, x - 16, y + 36, 16, 16, 6);
        }
    }

    private void drawInfoPanel(GuiGraphics guiGraphics, int x, int y, int width, int height, int id) {
        int u = 192;
        int v = 0;
        switch (id) {
            case 6: {
                v = 16;
                break;
            }
            case 11: {
                v = 0;
                break;
            }
            default: {
                return;
            }
        }
        guiGraphics.m_280218_(TEXTURE, x, y, u, v, width, height);
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(@Nonnull GuiGraphics pGuiGraphics, int pX, int pY) {
        super.m_280072_(pGuiGraphics, pX, pY);
        this.renderEnergyTooltip(pGuiGraphics, pX, pY);
        this.renderInfoPanelTooltips(pGuiGraphics, pX, pY);
    }

    private void renderEnergyTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        int energyBarX = this.f_97735_ + 116;
        int energyBarY = this.f_97736_ + 18;
        int energyBarWidth = 16;
        int energyBarHeight = 52;
        if (pX >= energyBarX && pX < energyBarX + energyBarWidth && pY >= energyBarY && pY < energyBarY + energyBarHeight) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237113_((String)(((MachineAssemblerMenu)this.f_97732_).getEnergy() + " / " + ((MachineAssemblerMenu)this.f_97732_).getMaxEnergy() + " FE")));
            int delta = ((MachineAssemblerMenu)this.f_97732_).getEnergyDelta();
            String deltaText = (delta >= 0 ? "+" : "") + delta + " FE/t";
            ChatFormatting deltaColor = delta > 0 ? ChatFormatting.GREEN : (delta < 0 ? ChatFormatting.RED : ChatFormatting.YELLOW);
            tooltip.add(Component.m_237113_((String)deltaText).m_130940_(deltaColor));
            pGuiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), pX, pY);
        }
    }

    private void renderInfoPanelTooltips(GuiGraphics pGuiGraphics, int pX, int pY) {
        ItemStack templateStack;
        int x = this.f_97735_;
        int y = this.f_97736_;
        if (this.isMouseOver(pX, pY, x - 16, y + 16, 16, 16)) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237115_((String)"desc.gui.template"));
            pGuiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), pX, pY);
        }
        if (((templateStack = ((MachineAssemblerMenu)this.f_97732_).m_38853_(40).m_7993_()).m_41619_() || !(templateStack.m_41720_() instanceof ItemAssemblyTemplate)) && this.isMouseOver(pX, pY, x - 16, y + 36, 16, 16)) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237115_((String)"desc.gui.assembler.warning").m_130940_(ChatFormatting.RED));
            pGuiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), pX, pY);
        }
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }
}

