/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.overlay;

import com.hbm_m.menu.MachineBatteryMenu;
import com.hbm_m.network.ModPacketHandler;
import com.hbm_m.network.UpdateBatteryC2SPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class GUIMachineBattery
extends AbstractContainerScreen<MachineBatteryMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/gui/storage/gui_battery.png");

    public GUIMachineBattery(MachineBatteryMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = -9999;
        this.f_97731_ = this.f_97727_ - 94;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = this.f_97735_;
        int y = this.f_97736_;
        pGuiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderEnergyBar(pGuiGraphics, x, y);
        this.renderButtons(pGuiGraphics, x, y);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        String titleText = this.f_96539_.getString() + " (" + ((MachineBatteryMenu)this.f_97732_).getEnergy() + " FE)";
        pGuiGraphics.m_280056_(this.f_96547_, titleText, (this.f_97726_ - this.f_96547_.m_92895_(titleText)) / 2, 6, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    private void renderEnergyBar(GuiGraphics graphics, int x, int y) {
        if (((MachineBatteryMenu)this.f_97732_).getEnergy() > 0) {
            int totalHeight = 52;
            int barHeight = (int)((float)totalHeight * ((float)((MachineBatteryMenu)this.f_97732_).getEnergy() / (float)((MachineBatteryMenu)this.f_97732_).getMaxEnergy()));
            graphics.m_280218_(TEXTURE, x + 62, y + 17 + (totalHeight - barHeight), 176, totalHeight - barHeight, 52, barHeight);
        }
    }

    private int getVForMode(int mode) {
        return switch (mode) {
            case 0 -> 70;
            case 1 -> 52;
            case 2 -> 88;
            case 3 -> 106;
            default -> 52;
        };
    }

    private void renderButtons(GuiGraphics graphics, int x, int y) {
        int vOnNoSignal = this.getVForMode(((MachineBatteryMenu)this.f_97732_).getModeOnNoSignal());
        graphics.m_280218_(TEXTURE, x + 133, y + 16, 176, vOnNoSignal, 18, 18);
        int vOnSignal = this.getVForMode(((MachineBatteryMenu)this.f_97732_).getModeOnSignal());
        graphics.m_280218_(TEXTURE, x + 133, y + 52, 176, vOnSignal, 18, 18);
        int priorityV = 52 + ((MachineBatteryMenu)this.f_97732_).getPriorityOrdinal() * 16;
        graphics.m_280218_(TEXTURE, x + 152, y + 35, 194, priorityV, 16, 16);
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        ArrayList<MutableComponent> tooltip;
        super.m_280072_(pGuiGraphics, pMouseX, pMouseY);
        if (this.isMouseOver(pMouseX, pMouseY, 62, 17, 52, 52)) {
            tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237113_((String)(((MachineBatteryMenu)this.f_97732_).getEnergy() + " / " + ((MachineBatteryMenu)this.f_97732_).getMaxEnergy() + " FE")));
            String deltaText = (((MachineBatteryMenu)this.f_97732_).getEnergyDelta() >= 0 ? "+" : "") + ((MachineBatteryMenu)this.f_97732_).getEnergyDelta() + " FE/t";
            ChatFormatting deltaColor = ((MachineBatteryMenu)this.f_97732_).getEnergyDelta() > 0 ? ChatFormatting.GREEN : (((MachineBatteryMenu)this.f_97732_).getEnergyDelta() < 0 ? ChatFormatting.RED : ChatFormatting.YELLOW);
            tooltip.add(Component.m_237113_((String)deltaText).m_130940_(deltaColor));
            pGuiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), pMouseX, pMouseY);
        }
        if (this.isMouseOver(pMouseX, pMouseY, 152, 35, 16, 16)) {
            tooltip = new ArrayList();
            String priorityKey = "gui.hbm_m.battery.priority." + ((MachineBatteryMenu)this.f_97732_).getPriorityOrdinal();
            tooltip.add(Component.m_237115_((String)priorityKey));
            tooltip.add(Component.m_237115_((String)"gui.hbm_m.battery.priority.recommended").m_130940_(ChatFormatting.DARK_GRAY));
            tooltip.add(Component.m_237115_((String)(priorityKey + ".desc")).m_130940_(ChatFormatting.GRAY));
            pGuiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), pMouseX, pMouseY);
        }
        if (this.isMouseOver(pMouseX, pMouseY, 133, 16, 18, 18)) {
            this.renderRedstoneTooltip(pGuiGraphics, pMouseX, pMouseY, ((MachineBatteryMenu)this.f_97732_).getModeOnNoSignal(), "no_signal");
        }
        if (this.isMouseOver(pMouseX, pMouseY, 133, 52, 18, 18)) {
            this.renderRedstoneTooltip(pGuiGraphics, pMouseX, pMouseY, ((MachineBatteryMenu)this.f_97732_).getModeOnSignal(), "with_signal");
        }
    }

    private void renderRedstoneTooltip(GuiGraphics graphics, int mouseX, int mouseY, int mode, String conditionKey) {
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        tooltip.add(Component.m_237115_((String)("gui.hbm_m.battery.condition." + conditionKey)));
        String modeKey = switch (mode) {
            case 0 -> "both";
            case 1 -> "input";
            case 2 -> "output";
            case 3 -> "locked";
            default -> "both";
        };
        String titleKey = "gui.hbm_m.battery.mode." + modeKey;
        String descKey = "gui.hbm_m.battery.mode." + modeKey + ".desc";
        tooltip.add(Component.m_237115_((String)titleKey).m_130940_(ChatFormatting.AQUA));
        tooltip.add(Component.m_237115_((String)descKey).m_130940_(ChatFormatting.GRAY));
        graphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            if (this.isMouseOver(pMouseX, pMouseY, 133, 16, 18, 18)) {
                this.playSound();
                ModPacketHandler.INSTANCE.sendToServer((Object)new UpdateBatteryC2SPacket(((MachineBatteryMenu)this.f_97732_).blockEntity.m_58899_(), 0));
                return true;
            }
            if (this.isMouseOver(pMouseX, pMouseY, 133, 52, 18, 18)) {
                this.playSound();
                ModPacketHandler.INSTANCE.sendToServer((Object)new UpdateBatteryC2SPacket(((MachineBatteryMenu)this.f_97732_).blockEntity.m_58899_(), 1));
                return true;
            }
            if (this.isMouseOver(pMouseX, pMouseY, 152, 35, 16, 16)) {
                this.playSound();
                ModPacketHandler.INSTANCE.sendToServer((Object)new UpdateBatteryC2SPacket(((MachineBatteryMenu)this.f_97732_).blockEntity.m_58899_(), 2));
                return true;
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    private boolean isMouseOver(double mouseX, double mouseY, int x, int y, int sizeX, int sizeY) {
        return mouseX >= (double)(this.f_97735_ + x) && mouseX <= (double)(this.f_97735_ + x + sizeX) && mouseY >= (double)(this.f_97736_ + y) && mouseY <= (double)(this.f_97736_ + y + sizeY);
    }

    private void playSound() {
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }
}

