/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client.overlay;

import com.hbm_m.menu.MachineWoodBurnerMenu;
import com.hbm_m.network.ModPacketHandler;
import com.hbm_m.network.ToggleWoodBurnerPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class GUIMachineWoodBurner
extends AbstractContainerScreen<MachineWoodBurnerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/gui/wood_burner/345345.png");
    private static final ResourceLocation BURN_TIME_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/gui/wood_burner/fuel_bar.png");
    private static final ResourceLocation ENERGY_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"textures/gui/wood_burner/energy_bar.png");

    public GUIMachineWoodBurner(MachineWoodBurnerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 176;
        this.f_97727_ = 200;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97736_ -= 20;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97729_ = 6;
        this.f_97728_ = 17;
        this.f_97731_ = this.f_97727_ - 110;
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0xFFFFFF, false);
        pGuiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = this.f_97735_;
        int y = this.f_97736_;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        pGuiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderBurnTimeBar(pGuiGraphics, x, y);
        this.renderEnergyBar(pGuiGraphics, x, y);
        this.renderToggleButton(pGuiGraphics, x, y);
    }

    private void renderBurnTimeBar(GuiGraphics graphics, int x, int y) {
        if (((MachineWoodBurnerMenu)this.f_97732_).getBurnTime() > 0) {
            int totalHeight = 52;
            int barHeight = ((MachineWoodBurnerMenu)this.f_97732_).getBurnTimeScaled(totalHeight);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BURN_TIME_BAR_TEXTURE);
            int startY = y + 18 + (totalHeight - barHeight);
            int textureStartY = totalHeight - barHeight;
            graphics.m_280218_(BURN_TIME_BAR_TEXTURE, x + 17, startY, 0, textureStartY, 4, barHeight);
        }
    }

    private void renderEnergyBar(GuiGraphics graphics, int x, int y) {
        if (((MachineWoodBurnerMenu)this.f_97732_).getEnergy() > 0) {
            int totalHeight = 34;
            int barHeight = ((MachineWoodBurnerMenu)this.f_97732_).getEnergyScaled(totalHeight);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ENERGY_BAR_TEXTURE);
            int startY = y + 18 + (totalHeight - barHeight);
            int textureStartY = totalHeight - barHeight;
            graphics.m_280218_(ENERGY_BAR_TEXTURE, x + 143, startY, 0, textureStartY, 16, barHeight);
        }
    }

    private void renderToggleButton(GuiGraphics graphics, int x, int y) {
        if (!((MachineWoodBurnerMenu)this.f_97732_).isEnabled()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            graphics.m_280218_(TEXTURE, x + 53, y + 17, 196, 0, 16, 16);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isMouseOver((int)mouseX, (int)mouseY, 53, 17, 16, 16)) {
            ModPacketHandler.INSTANCE.sendToServer((Object)new ToggleWoodBurnerPacket(((MachineWoodBurnerMenu)this.f_97732_).getBlockEntity().m_58899_()));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int pX, int pY) {
        ArrayList<MutableComponent> tooltip;
        super.m_280072_(pGuiGraphics, pX, pY);
        if (this.isMouseOver(pX, pY, 53, 17, 16, 16)) {
            ArrayList<MutableComponent> tooltip2 = new ArrayList<MutableComponent>();
            if (((MachineWoodBurnerMenu)this.f_97732_).isEnabled()) {
                tooltip2.add(Component.m_237113_((String)"Generator: ON").m_130940_(ChatFormatting.GREEN));
                tooltip2.add(Component.m_237113_((String)"Click to turn OFF").m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip2.add(Component.m_237113_((String)"Generator: OFF").m_130940_(ChatFormatting.RED));
                tooltip2.add(Component.m_237113_((String)"Click to turn ON").m_130940_(ChatFormatting.GRAY));
            }
            pGuiGraphics.m_280677_(this.f_96547_, tooltip2, Optional.empty(), pX, pY);
            return;
        }
        if (this.isMouseOver(pX, pY, 17, 17, 4, 52)) {
            tooltip = new ArrayList<MutableComponent>();
            if (((MachineWoodBurnerMenu)this.f_97732_).isLit()) {
                int burnTimeSeconds = ((MachineWoodBurnerMenu)this.f_97732_).getBurnTime() / 20;
                tooltip.add(Component.m_237113_((String)("Burn Time: " + burnTimeSeconds + "s")).m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add(Component.m_237113_((String)"Not burning").m_130940_(ChatFormatting.GRAY));
            }
            pGuiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), pX, pY);
        }
        if (this.isMouseOver(pX, pY, 143, 18, 16, 34)) {
            tooltip = new ArrayList();
            tooltip.add(Component.m_237113_((String)String.format("%,d / %,d FE", ((MachineWoodBurnerMenu)this.f_97732_).getEnergy(), ((MachineWoodBurnerMenu)this.f_97732_).getMaxEnergy())).m_130940_(ChatFormatting.GREEN));
            if (((MachineWoodBurnerMenu)this.f_97732_).isLit()) {
                tooltip.add(Component.m_237113_((String)"+50 FE/t").m_130940_(ChatFormatting.YELLOW));
            } else {
                tooltip.add(Component.m_237113_((String)"Not generating").m_130940_(ChatFormatting.GRAY));
            }
            int percentage = (int)((float)((MachineWoodBurnerMenu)this.f_97732_).getEnergy() / (float)((MachineWoodBurnerMenu)this.f_97732_).getMaxEnergy() * 100.0f);
            tooltip.add(Component.m_237113_((String)(percentage + "%")).m_130940_(ChatFormatting.AQUA));
            pGuiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), pX, pY);
        }
        if (this.isMouseOver(pX, pY, 56, 36, 14, 14) && ((MachineWoodBurnerMenu)this.f_97732_).isLit()) {
            tooltip = new ArrayList();
            tooltip.add(Component.m_237113_((String)"Burning fuel").m_130940_(ChatFormatting.RED));
            pGuiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), pX, pY);
        }
    }

    private boolean isMouseOver(double mouseX, double mouseY, int x, int y, int sizeX, int sizeY) {
        return mouseX >= (double)(this.f_97735_ + x) && mouseX <= (double)(this.f_97735_ + x + sizeX) && mouseY >= (double)(this.f_97736_ + y) && mouseY <= (double)(this.f_97736_ + y + sizeY);
    }
}

