/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hbm_m.recipe.AssemblerRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class AssemblerRecipeBuilder
implements RecipeBuilder {
    private final ItemStack output;
    private final int duration;
    private final int power;
    private final List<CountableIngredient> ingredients = new ArrayList<CountableIngredient>();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String blueprintPool = null;

    private AssemblerRecipeBuilder(ItemStack output, int duration, int power) {
        this.output = output;
        this.duration = duration;
        this.power = power;
    }

    public static AssemblerRecipeBuilder assemblerRecipe(ItemStack output, int duration, int power) {
        return new AssemblerRecipeBuilder(output, duration, power);
    }

    public AssemblerRecipeBuilder addIngredient(Ingredient ingredient, int count) {
        this.ingredients.add(new CountableIngredient(ingredient, count));
        return this;
    }

    public AssemblerRecipeBuilder addIngredient(Item item, int count) {
        return this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), count);
    }

    public AssemblerRecipeBuilder withBlueprintPool(String pool) {
        this.blueprintPool = pool;
        return this;
    }

    public RecipeBuilder m_126132_(@Nonnull String pCriterionName, @Nonnull CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        return this;
    }

    public Item m_142372_() {
        return this.output.m_41720_();
    }

    public void m_126140_(@Nonnull Consumer<FinishedRecipe> pFinishedRecipeConsumer, @Nonnull ResourceLocation pRecipeId) {
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this));
    }

    private record CountableIngredient(Ingredient ingredient, int count) {
    }

    private static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final AssemblerRecipeBuilder builder;

        public Result(ResourceLocation id, AssemblerRecipeBuilder builder) {
            this.id = id;
            this.builder = builder;
        }

        public void m_7917_(@Nonnull JsonObject pJson) {
            JsonArray jsonIngredients = new JsonArray();
            for (CountableIngredient countableIng : this.builder.ingredients) {
                JsonObject ingredientJson = countableIng.ingredient().m_43942_().getAsJsonObject();
                ingredientJson.addProperty("count", (Number)countableIng.count());
                jsonIngredients.add((JsonElement)ingredientJson);
            }
            pJson.add("ingredients", (JsonElement)jsonIngredients);
            JsonObject jsonOutput = new JsonObject();
            jsonOutput.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.builder.output.m_41720_()).toString());
            if (this.builder.output.m_41613_() > 1) {
                jsonOutput.addProperty("count", (Number)this.builder.output.m_41613_());
            }
            pJson.add("output", (JsonElement)jsonOutput);
            pJson.addProperty("duration", (Number)this.builder.duration);
            pJson.addProperty("power", (Number)this.builder.power);
            if (this.builder.blueprintPool != null) {
                pJson.addProperty("blueprint_pool", this.builder.blueprintPool);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return AssemblerRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

