/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.energy;

import com.hbm_m.config.ModClothConfig;
import com.hbm_m.main.MainRegistry;
import net.minecraftforge.energy.EnergyStorage;

public class BlockEntityEnergyStorage
extends EnergyStorage {
    public BlockEntityEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer, maxTransfer, 0);
    }

    public BlockEntityEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract, 0);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = super.receiveEnergy(maxReceive, simulate);
        if (energyReceived > 0 && !simulate && ModClothConfig.get().enableDebugLogging) {
            MainRegistry.LOGGER.debug("[EnergyStorage]: Received {} FE (now {})", (Object)energyReceived, (Object)this.energy);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = super.extractEnergy(maxExtract, simulate);
        if (energyExtracted > 0 && !simulate && ModClothConfig.get().enableDebugLogging) {
            MainRegistry.LOGGER.debug("[EnergyStorage]: Extracted {} FE (now {})", (Object)energyExtracted, (Object)this.energy);
        }
        return energyExtracted;
    }

    public void setEnergy(int energy) {
        if (energy < 0) {
            energy = 0;
        }
        if (energy > this.capacity) {
            energy = this.capacity;
        }
        this.energy = energy;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }
}

