/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.energy;

import com.hbm_m.block.WireBlock;
import com.hbm_m.block.entity.MachineBatteryBlockEntity;
import com.hbm_m.block.entity.WireBlockEntity;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;

public class WireNetworkManager {
    private static final WireNetworkManager INSTANCE = new WireNetworkManager();
    private final Map<Level, PerLevel> levels = Collections.synchronizedMap(new WeakHashMap());

    public static WireNetworkManager get() {
        return INSTANCE;
    }

    public void onWireAdded(Level level, BlockPos pos) {
        PerLevel pl = this.levels.computeIfAbsent(level, l -> new PerLevel());
        pl.addWire(level, pos);
    }

    public void onWireRemoved(Level level, BlockPos pos) {
        PerLevel pl = this.levels.get(level);
        if (pl != null) {
            pl.removeWire(level, pos);
        }
    }

    public void onWireChanged(Level level, BlockPos pos) {
        if (level.m_8055_(pos).m_60734_() instanceof WireBlock) {
            this.onWireAdded(level, pos);
        } else {
            this.onWireRemoved(level, pos);
        }
    }

    public int requestEnergy(Level level, BlockPos start, int maxRequest, boolean simulate) {
        PerLevel pl = this.levels.get(level);
        if (pl == null) {
            return 0;
        }
        return pl.requestEnergy(level, start, maxRequest, simulate);
    }

    private static class PerLevel {
        private final Map<BlockPos, Set<BlockPos>> adj = new HashMap<BlockPos, Set<BlockPos>>();
        private final Map<BlockPos, BlockPos> parent = new HashMap<BlockPos, BlockPos>();
        private final Map<BlockPos, Set<BlockPos>> members = new HashMap<BlockPos, Set<BlockPos>>();
        private final Set<Edge> treeEdges = new HashSet<Edge>();
        private final Map<BlockPos, List<EnergySource>> sources = new HashMap<BlockPos, List<EnergySource>>();
        private static final int MAX_SOURCES_PER_COMPONENT = 2048;

        private PerLevel() {
        }

        private BlockPos find(BlockPos p) {
            BlockPos r = this.parent.get(p);
            if (r == null) {
                return null;
            }
            if (r.equals((Object)p)) {
                return r;
            }
            BlockPos root = this.find(r);
            this.parent.put(p, root);
            return root;
        }

        private void makeSet(BlockPos p) {
            this.parent.put(p, p);
            HashSet<BlockPos> s = new HashSet<BlockPos>();
            s.add(p);
            this.members.put(p, s);
            this.adj.computeIfAbsent(p, k -> new HashSet());
            this.sources.put(p, new ArrayList());
        }

        private void unionRoots(BlockPos r1, BlockPos r2) {
            if (r1.equals(r2)) {
                return;
            }
            Set<BlockPos> s1 = this.members.get(r1);
            Set<BlockPos> s2 = this.members.get(r2);
            if (s1 == null || s2 == null) {
                return;
            }
            if (s1.size() < s2.size()) {
                BlockPos tmp = r1;
                r1 = r2;
                r2 = tmp;
                Set<BlockPos> tmpSet = s1;
                s1 = s2;
                s2 = tmpSet;
            }
            for (BlockPos p : s2) {
                this.parent.put(p, r1);
            }
            s1.addAll(s2);
            this.members.remove(r2);
            List<EnergySource> l1 = this.sources.get(r1);
            List<EnergySource> l2 = this.sources.get(r2);
            if (l1 == null) {
                l1 = new ArrayList<EnergySource>();
            }
            if (l2 != null) {
                for (EnergySource es : l2) {
                    if (l1.size() >= 2048) continue;
                    l1.add(es);
                }
            }
            this.sources.put(r1, l1);
            this.sources.remove(r2);
        }

        void addWire(Level level, BlockPos pos) {
            if (this.parent.containsKey(pos)) {
                this.updateSourcesForComponent(level, pos);
                return;
            }
            this.makeSet(pos);
            for (Direction d : Direction.values()) {
                BlockPos npos = pos.m_121945_(d);
                if (this.parent.containsKey(npos) || !this.adj.containsKey(npos)) {
                    // empty if block
                }
                if (!this.adj.containsKey(npos)) continue;
                this.adj.get(npos).add(pos);
                this.adj.get(pos).add(npos);
                BlockPos r1 = this.find(pos);
                BlockPos r2 = this.find(npos);
                if (r1 == null || r2 == null || r1.equals((Object)r2)) continue;
                this.treeEdges.add(new Edge(pos, npos));
                this.unionRoots(r1, r2);
            }
            BlockPos root = this.find(pos);
            if (root != null) {
                this.updateSourcesForRoot(level, root);
            }
        }

        void removeWire(Level level, BlockPos pos) {
            if (!this.parent.containsKey(pos)) {
                return;
            }
            BlockPos root = this.find(pos);
            Set<BlockPos> compMembers = this.members.get(root);
            if (compMembers == null) {
                compMembers = Set.of(pos);
            }
            HashSet<BlockPos> compSnapshot = new HashSet<BlockPos>(compMembers);
            ArrayList<Edge> removedTreeEdges = new ArrayList<Edge>();
            Set neighbors = this.adj.getOrDefault(pos, Collections.emptySet());
            for (BlockPos nb : new ArrayList(neighbors)) {
                this.adj.getOrDefault(nb, Collections.emptySet()).remove(pos);
                this.adj.getOrDefault(pos, Collections.emptySet()).remove(nb);
                Edge e2 = new Edge(pos, nb);
                if (!this.treeEdges.remove(e2)) continue;
                removedTreeEdges.add(e2);
            }
            this.adj.remove(pos);
            this.parent.remove(pos);
            if (this.members.get(root) != null) {
                this.members.get(root).remove(pos);
            }
            if (removedTreeEdges.isEmpty()) {
                if (this.members.get(root) != null) {
                    this.updateSourcesForRoot(level, root);
                }
                return;
            }
            for (Edge removed : removedTreeEdges) {
                boolean stillConnected;
                BlockPos a = removed.a;
                BlockPos b = removed.b;
                if (a.equals((Object)pos) || b.equals((Object)pos) || (stillConnected = this.isReachableExcludingEdge(a, b, removed))) continue;
                HashSet<BlockPos> leftover = new HashSet<BlockPos>(compSnapshot);
                leftover.remove(pos);
                for (BlockPos p : compSnapshot) {
                    this.parent.remove(p);
                    this.members.remove(p);
                }
                this.treeEdges.removeIf(e -> compSnapshot.contains(e.a) || compSnapshot.contains(e.b));
                this.rebuildComponents(level, leftover);
            }
        }

        private boolean isReachableExcludingEdge(BlockPos start, BlockPos target, Edge excluded) {
            ArrayDeque<BlockPos> q = new ArrayDeque<BlockPos>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            q.add(start);
            visited.add(start);
            while (!q.isEmpty()) {
                BlockPos cur = (BlockPos)q.poll();
                if (cur.equals((Object)target)) {
                    return true;
                }
                for (BlockPos nb : this.adj.getOrDefault(cur, Collections.emptySet())) {
                    Edge ecur = new Edge(cur, nb);
                    if (ecur.equals(excluded) || !visited.add(nb)) continue;
                    q.add(nb);
                }
            }
            return false;
        }

        private void rebuildComponents(Level level, Set<BlockPos> nodes) {
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            for (BlockPos start : nodes) {
                if (visited.contains(start)) continue;
                ArrayDeque<BlockPos> q = new ArrayDeque<BlockPos>();
                HashSet<BlockPos> comp = new HashSet<BlockPos>();
                q.add(start);
                visited.add(start);
                comp.add(start);
                while (!q.isEmpty()) {
                    BlockPos cur = (BlockPos)q.poll();
                    for (BlockPos nb : this.adj.getOrDefault(cur, Collections.emptySet())) {
                        if (!nodes.contains(nb) || !visited.add(nb)) continue;
                        visited.add(nb);
                        q.add(nb);
                        comp.add(nb);
                    }
                }
                BlockPos root = (BlockPos)comp.iterator().next();
                for (BlockPos p : comp) {
                    this.parent.put(p, root);
                }
                this.members.put(root, comp);
                this.buildSpanningTreeForComponent(root, comp);
                this.updateSourcesForRoot(level, root);
            }
        }

        private void buildSpanningTreeForComponent(BlockPos root, Set<BlockPos> comp) {
            ArrayDeque<BlockPos> q = new ArrayDeque<BlockPos>();
            HashSet<BlockPos> vis = new HashSet<BlockPos>();
            q.add(root);
            vis.add(root);
            while (!q.isEmpty()) {
                BlockPos cur = (BlockPos)q.poll();
                for (BlockPos nb : this.adj.getOrDefault(cur, Collections.emptySet())) {
                    if (!comp.contains(nb) || vis.contains(nb)) continue;
                    this.treeEdges.add(new Edge(cur, nb));
                    this.parent.put(nb, root);
                    this.members.get(root).add(nb);
                    q.add(nb);
                    vis.add(nb);
                }
            }
            this.parent.put(root, root);
        }

        private void updateSourcesForComponent(Level level, BlockPos anyMember) {
            BlockPos r = this.find(anyMember);
            if (r != null) {
                this.updateSourcesForRoot(level, r);
            }
        }

        private void updateSourcesForRoot(Level level, BlockPos root) {
            Set<BlockPos> mem = this.members.get(root);
            if (mem == null) {
                return;
            }
            ArrayList<EnergySource> list = new ArrayList<EnergySource>();
            for (BlockPos p : mem) {
                for (Direction d : Direction.values()) {
                    BlockPos np = p.m_121945_(d);
                    BlockEntity nbe = level.m_7702_(np);
                    if (nbe == null || nbe instanceof WireBlockEntity || !nbe.getCapability(ForgeCapabilities.ENERGY, d.m_122424_()).isPresent() || list.size() >= 2048) continue;
                    int pr = 1;
                    if (nbe instanceof MachineBatteryBlockEntity) {
                        MachineBatteryBlockEntity mb = (MachineBatteryBlockEntity)nbe;
                        try {
                            pr = mb.priority.ordinal();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    list.add(new EnergySource(np, d.m_122424_(), pr));
                }
            }
            this.sources.put(root, list);
        }

        int requestEnergy(Level level, BlockPos start, int need, boolean simulate) {
            BlockPos root = this.find(start);
            if (root == null) {
                return this.bfsRequest(level, start, need, simulate, 2000);
            }
            List<EnergySource> list = this.sources.get(root);
            if (list == null || list.isEmpty()) {
                return 0;
            }
            list.sort(Comparator.comparingInt(es -> es.priority()).reversed());
            int taken = 0;
            for (EnergySource es2 : list) {
                IEnergyStorage storage;
                if (taken >= need) break;
                BlockEntity be = level.m_7702_(es2.pos());
                if (be == null || (storage = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY, es2.side()).resolve().orElse(null)) == null || !storage.canExtract()) continue;
                try {
                    int got = storage.extractEnergy(need - taken, simulate);
                    if (got <= 0) continue;
                    taken += got;
                }
                catch (Exception exception) {}
            }
            return taken;
        }

        private int bfsRequest(Level level, BlockPos start, int need, boolean simulate, int maxNodes) {
            ArrayDeque<BlockPos> q = new ArrayDeque<BlockPos>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            ArrayList<EnergySource> found = new ArrayList<EnergySource>();
            q.add(start);
            visited.add(start);
            int nodes = 0;
            while (!q.isEmpty() && nodes < maxNodes && found.size() < 2048) {
                BlockPos cur = (BlockPos)q.poll();
                ++nodes;
                for (Direction d : Direction.values()) {
                    BlockEntity nbe;
                    BlockPos np = cur.m_121945_(d);
                    if (!visited.add(np) || (nbe = level.m_7702_(np)) == null) continue;
                    if (nbe instanceof WireBlockEntity) {
                        q.add(np);
                        continue;
                    }
                    if (!nbe.getCapability(ForgeCapabilities.ENERGY, d.m_122424_()).isPresent()) continue;
                    int pr = 1;
                    if (nbe instanceof MachineBatteryBlockEntity) {
                        MachineBatteryBlockEntity mb = (MachineBatteryBlockEntity)nbe;
                        try {
                            pr = mb.priority.ordinal();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    found.add(new EnergySource(np, d.m_122424_(), pr));
                }
            }
            found.sort(Comparator.comparingInt(es -> es.priority()).reversed());
            int taken = 0;
            for (EnergySource es2 : found) {
                IEnergyStorage storage;
                if (taken >= need) break;
                BlockEntity be = level.m_7702_(es2.pos());
                if (be == null || (storage = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY, es2.side()).resolve().orElse(null)) == null || !storage.canExtract()) continue;
                try {
                    int got = storage.extractEnergy(need - taken, simulate);
                    if (got <= 0) continue;
                    taken += got;
                }
                catch (Exception exception) {}
            }
            return taken;
        }

        private record EnergySource(BlockPos pos, Direction side, int priority) {
        }

        private static final class Edge {
            final BlockPos a;
            final BlockPos b;

            Edge(BlockPos a, BlockPos b) {
                if (a.hashCode() <= b.hashCode()) {
                    this.a = a;
                    this.b = b;
                } else {
                    this.a = b;
                    this.b = a;
                }
            }

            public boolean equals(Object o) {
                if (!(o instanceof Edge)) {
                    return false;
                }
                Edge e = (Edge)o;
                return this.a.equals((Object)e.a) && this.b.equals((Object)e.b);
            }

            public int hashCode() {
                return Objects.hash(this.a, this.b);
            }
        }
    }
}

