/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.event;

import com.hbm_m.hazard.HazardSystem;
import com.hbm_m.hazard.HazardType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HazardEventHandler {
    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.side.isClient() || event.phase != TickEvent.Phase.END) {
            return;
        }
        ServerLevel level = (ServerLevel)event.level;
        for (Entity entity : level.m_8583_()) {
            float radiationLevel;
            float explosiveStrength;
            ItemStack stack;
            ItemEntity itemEntity;
            if (!(entity instanceof ItemEntity) || (itemEntity = (ItemEntity)entity).m_213877_() || (stack = itemEntity.m_32055_()).m_41619_()) continue;
            boolean itemDestroyed = false;
            float hydroStrength = HazardSystem.getHazardLevelFromStack(stack, HazardType.HYDRO_REACTIVE);
            if (hydroStrength > 0.0f && itemEntity.m_20070_()) {
                itemEntity.m_146870_();
                level.m_254849_((Entity)itemEntity, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), hydroStrength, Level.ExplosionInteraction.TNT);
                itemDestroyed = true;
            }
            if (!itemDestroyed && (explosiveStrength = HazardSystem.getHazardLevelFromStack(stack, HazardType.EXPLOSIVE_ON_FIRE)) > 0.0f && itemEntity.m_6060_()) {
                itemEntity.m_146870_();
                level.m_254849_((Entity)itemEntity, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), explosiveStrength, Level.ExplosionInteraction.TNT);
                itemDestroyed = true;
            }
            if (!itemDestroyed && !((radiationLevel = HazardSystem.getHazardLevelFromStack(stack, HazardType.RADIATION)) > 0.0f)) continue;
        }
    }
}

