/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.item;

import com.hbm_m.armormod.util.ArmorModificationHelper;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.network.ModPacketHandler;
import com.hbm_m.network.sounds.GeigerSoundPacket;
import com.hbm_m.radiation.ChunkRadiationManager;
import com.hbm_m.radiation.PlayerRadiationHandler;
import com.hbm_m.sound.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public abstract class AbstractRadiationMeterItem
extends Item {
    public AbstractRadiationMeterItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level pLevel, @Nonnull Player pPlayer, @Nonnull InteractionHand pUsedHand) {
        if (!pLevel.m_5776_() && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            RadiationData data = this.measureRadiation(pLevel, (Player)serverPlayer);
            Component message = this.createUsageMessage(data);
            pPlayer.m_213846_(message);
            this.playSoundOnClick(serverPlayer);
        }
        return InteractionResultHolder.m_19090_((Object)pPlayer.m_21120_(pUsedHand));
    }

    protected RadiationData measureRadiation(Level level, Player player) {
        float chunkRad = 0.0f;
        float invRad = 0.0f;
        if (ModClothConfig.get().enableRadiation) {
            chunkRad = ChunkRadiationManager.getRadiation(level, player.m_146903_(), (int)Math.floor(player.m_20186_() + (double)player.m_20206_() * 0.5), player.m_146907_());
            invRad = PlayerRadiationHandler.getInventoryRadiation(player);
        }
        float playerRads = PlayerRadiationHandler.getPlayerRads(player);
        float totalAbsoluteProtection = 0.0f;
        for (ItemStack armorStack : player.m_6168_()) {
            totalAbsoluteProtection += ArmorModificationHelper.getTotalAbsoluteRadProtection(armorStack);
        }
        float protectionPercent = ArmorModificationHelper.convertAbsoluteToPercent(totalAbsoluteProtection);
        return new RadiationData(chunkRad, invRad, playerRads, protectionPercent, totalAbsoluteProtection);
    }

    protected abstract Component createUsageMessage(RadiationData var1);

    protected void playSoundOnClick(ServerPlayer player) {
        SoundEvent soundEvent;
        if (ModSounds.TOOL_TECH_BOOP.isPresent() && (soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BOOP.get()) != null) {
            ResourceLocation soundLocation = soundEvent.m_11660_();
            ModPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new GeigerSoundPacket(soundLocation, 1.0f, 1.0f));
        }
    }

    protected static String getRadColor(float rads) {
        if (rads < 0.01f) {
            return "\u00a7a";
        }
        if (rads < 1.0f) {
            return "\u00a7e";
        }
        if (rads < 10.0f) {
            return "\u00a76";
        }
        if (rads < 100.0f) {
            return "\u00a7c";
        }
        if (rads < 1000.0f) {
            return "\u00a74";
        }
        return "\u00a77";
    }

    protected record RadiationData(float chunkRad, float inventoryRad, float playerRad, float protectionPercent, float protectionAbsolute) {
        public float getTotalEnvironmentRad() {
            return this.chunkRad + this.inventoryRad;
        }
    }
}

