/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.item;

import com.hbm_m.recipe.AssemblerRecipe;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemBlueprintFolder
extends Item {
    public ItemBlueprintFolder(Item.Properties properties) {
        super(properties);
    }

    public static void writeBlueprintPool(ItemStack folderStack, String poolName) {
        if (folderStack.m_41720_() instanceof ItemBlueprintFolder) {
            CompoundTag nbt = folderStack.m_41784_();
            nbt.m_128359_("blueprintPool", poolName);
        }
    }

    public static String getBlueprintPool(ItemStack folderStack) {
        if (folderStack.m_41782_() && folderStack.m_41783_().m_128441_("blueprintPool")) {
            return folderStack.m_41783_().m_128461_("blueprintPool");
        }
        return "";
    }

    public Component m_7626_(@Nonnull ItemStack stack) {
        String pool = ItemBlueprintFolder.getBlueprintPool(stack);
        if (!pool.isEmpty()) {
            return Component.m_237115_((String)"item.hbm_m.blueprint_folder.named").m_130946_(": ").m_130946_(pool);
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        String pool = ItemBlueprintFolder.getBlueprintPool(stack);
        if (pool.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"item.hbm_m.blueprint_folder.empty").m_130940_(ChatFormatting.GRAY));
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)"item.hbm_m.blueprint_folder.desc").m_130940_(ChatFormatting.GRAY));
        if (level != null && level.m_7465_() != null) {
            List<AssemblerRecipe> recipes = level.m_7465_().m_44013_((RecipeType)AssemblerRecipe.Type.INSTANCE).stream().filter(r -> pool.equals(r.getBlueprintPool())).toList();
            if (recipes.isEmpty()) {
                tooltip.add((Component)Component.m_237119_());
                tooltip.add((Component)Component.m_237115_((String)"item.hbm_m.blueprint_folder.obsolete").m_130940_(ChatFormatting.RED));
                return;
            }
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"item.hbm_m.blueprint_folder.recipes").m_130940_(ChatFormatting.GOLD));
            int count = 0;
            for (AssemblerRecipe recipe : recipes) {
                if (count >= 10) {
                    tooltip.add((Component)Component.m_237113_((String)" ...").m_130940_(ChatFormatting.DARK_GRAY));
                    break;
                }
                tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_(recipe.m_8043_(level.m_9598_()).m_41786_()).m_130940_(ChatFormatting.YELLOW));
                ++count;
            }
        }
    }
}

