/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.item;

import com.hbm_m.config.ModClothConfig;
import com.hbm_m.item.AbstractRadiationMeterItem;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.network.ModPacketHandler;
import com.hbm_m.network.RadiationDataPacket;
import com.hbm_m.network.sounds.GeigerSoundPacket;
import com.hbm_m.sound.ModSounds;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class ItemGeigerCounter
extends AbstractRadiationMeterItem {
    private static final Random RANDOM = new Random();
    private int soundTickCounter = 0;

    public ItemGeigerCounter(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    protected Component createUsageMessage(AbstractRadiationMeterItem.RadiationData data) {
        String chunkRadStr = ItemGeigerCounter.getRadColor(data.chunkRad()) + String.format("%.1f RAD/s", Float.valueOf(data.chunkRad()));
        String envRadStr = ItemGeigerCounter.getRadColor(data.getTotalEnvironmentRad()) + String.format("%.1f RAD/s\n", Float.valueOf(data.getTotalEnvironmentRad()));
        String playerRadStr = ItemGeigerCounter.getRadColor(data.playerRad()) + String.format("%.1f RAD", Float.valueOf(data.playerRad()));
        String protectionPercentStr = String.format("%.2f%%", Float.valueOf(data.protectionPercent() * 100.0f));
        String protectionAbsoluteStr = String.format("%.3f", Float.valueOf(data.protectionAbsolute()));
        String titleString = "\n\u00a76===== \u2622 " + Component.m_237115_((String)"item.hbm_m.meter.geiger_counter.name").getString() + " \u2622 =====\n";
        MutableComponent message = Component.m_237110_((String)"item.hbm_m.meter.title_format", (Object[])new Object[]{titleString});
        message.m_7220_((Component)Component.m_237110_((String)"item.hbm_m.meter.chunk_rads", (Object[])new Object[]{chunkRadStr}));
        message.m_7220_((Component)Component.m_237110_((String)"item.hbm_m.meter.env_rads", (Object[])new Object[]{envRadStr}));
        message.m_7220_((Component)Component.m_237110_((String)"item.hbm_m.meter.player_rads", (Object[])new Object[]{playerRadStr}));
        message.m_7220_((Component)Component.m_237110_((String)"item.hbm_m.meter.protection", (Object[])new Object[]{protectionPercentStr, protectionAbsoluteStr}));
        return message;
    }

    public void m_6883_(@Nonnull ItemStack pStack, @Nonnull Level pLevel, @Nonnull Entity pEntity, int pSlotId, boolean pIsSelected) {
        ServerPlayer serverPlayer;
        if (!pLevel.m_5776_() && pEntity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)pEntity).m_6084_()) {
            ++this.soundTickCounter;
            int SOUND_INTERVAL_TICKS = 5;
            if (this.soundTickCounter >= 5) {
                this.soundTickCounter = 0;
                AbstractRadiationMeterItem.RadiationData data = this.measureRadiation(pLevel, (Player)serverPlayer);
                float totalEnvironmentRads = data.getTotalEnvironmentRad();
                if (ModClothConfig.get().enableDebugLogging) {
                    MainRegistry.LOGGER.debug("GeigerCounter: chunkRad = {}, invRad = {}, totalEnvironmentRads = {}", (Object)Float.valueOf(data.chunkRad()), (Object)Float.valueOf(data.inventoryRad()), (Object)Float.valueOf(totalEnvironmentRads));
                }
                if (!serverPlayer.m_7500_() && !serverPlayer.m_5833_()) {
                    ModPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new RadiationDataPacket(data.getTotalEnvironmentRad(), data.playerRad()));
                }
                this.playGeigerTickSound(serverPlayer, totalEnvironmentRads);
            }
        }
    }

    private void playGeigerTickSound(ServerPlayer player, float radiationLevel) {
        int soundIndex = 0;
        ArrayList<Integer> soundOptions = new ArrayList<Integer>();
        if (radiationLevel > 0.0f) {
            if (radiationLevel < 10.0f) {
                soundOptions.add(1);
            }
            if (radiationLevel > 5.0f && radiationLevel < 15.0f) {
                soundOptions.add(2);
            }
            if (radiationLevel > 10.0f && radiationLevel < 20.0f) {
                soundOptions.add(3);
            }
            if (radiationLevel > 15.0f && radiationLevel < 25.0f) {
                soundOptions.add(4);
            }
            if (radiationLevel > 20.0f && radiationLevel < 30.0f) {
                soundOptions.add(5);
            }
            if (radiationLevel > 25.0f) {
                soundOptions.add(6);
            }
            if (!soundOptions.isEmpty()) {
                soundIndex = (Integer)soundOptions.get(RANDOM.nextInt(soundOptions.size()));
            }
        } else if (RANDOM.nextInt(50) == 0) {
            soundIndex = 1;
        }
        Optional<Object> soundRegistryObject = switch (soundIndex) {
            case 1 -> Optional.of(ModSounds.GEIGER_1);
            case 2 -> Optional.of(ModSounds.GEIGER_2);
            case 3 -> Optional.of(ModSounds.GEIGER_3);
            case 4 -> Optional.of(ModSounds.GEIGER_4);
            case 5 -> Optional.of(ModSounds.GEIGER_5);
            case 6 -> Optional.of(ModSounds.GEIGER_6);
            default -> Optional.empty();
        };
        soundRegistryObject.ifPresent(regObject -> {
            SoundEvent soundEvent = (SoundEvent)regObject.get();
            if (soundEvent != null) {
                ResourceLocation soundLocation = soundEvent.m_11660_();
                ModPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new GeigerSoundPacket(soundLocation, 0.4f, 1.0f));
            }
        });
    }
}

