/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.item;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.item.ModItems;
import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "hbm_m", existingFileHelper);
    }

    protected void registerModels() {
        this.trimmedArmorItem(ModItems.ALLOY_HELMET);
        this.trimmedArmorItem(ModItems.ALLOY_CHESTPLATE);
        this.trimmedArmorItem(ModItems.ALLOY_LEGGINGS);
        this.trimmedArmorItem(ModItems.ALLOY_BOOTS);
        this.trimmedArmorItem(ModItems.TITANIUM_HELMET);
        this.trimmedArmorItem(ModItems.TITANIUM_CHESTPLATE);
        this.trimmedArmorItem(ModItems.TITANIUM_LEGGINGS);
        this.trimmedArmorItem(ModItems.TITANIUM_BOOTS);
        this.trimmedArmorItem(ModItems.SECURITY_HELMET);
        this.trimmedArmorItem(ModItems.SECURITY_CHESTPLATE);
        this.trimmedArmorItem(ModItems.SECURITY_LEGGINGS);
        this.trimmedArmorItem(ModItems.SECURITY_BOOTS);
        this.trimmedArmorItem(ModItems.ASBESTOS_HELMET);
        this.trimmedArmorItem(ModItems.ASBESTOS_CHESTPLATE);
        this.trimmedArmorItem(ModItems.ASBESTOS_LEGGINGS);
        this.trimmedArmorItem(ModItems.ASBESTOS_BOOTS);
        this.trimmedArmorItem(ModItems.AJR_HELMET);
        this.trimmedArmorItem(ModItems.AJR_CHESTPLATE);
        this.trimmedArmorItem(ModItems.AJR_LEGGINGS);
        this.trimmedArmorItem(ModItems.AJR_BOOTS);
        this.trimmedArmorItem(ModItems.STEEL_HELMET);
        this.trimmedArmorItem(ModItems.STEEL_CHESTPLATE);
        this.trimmedArmorItem(ModItems.STEEL_LEGGINGS);
        this.trimmedArmorItem(ModItems.STEEL_BOOTS);
        this.trimmedArmorItem(ModItems.PAA_HELMET);
        this.trimmedArmorItem(ModItems.PAA_CHESTPLATE);
        this.trimmedArmorItem(ModItems.PAA_LEGGINGS);
        this.trimmedArmorItem(ModItems.PAA_BOOTS);
        this.trimmedArmorItem(ModItems.LIQUIDATOR_HELMET);
        this.trimmedArmorItem(ModItems.LIQUIDATOR_CHESTPLATE);
        this.trimmedArmorItem(ModItems.LIQUIDATOR_LEGGINGS);
        this.trimmedArmorItem(ModItems.LIQUIDATOR_BOOTS);
        this.trimmedArmorItem(ModItems.HAZMAT_HELMET);
        this.trimmedArmorItem(ModItems.HAZMAT_CHESTPLATE);
        this.trimmedArmorItem(ModItems.HAZMAT_LEGGINGS);
        this.trimmedArmorItem(ModItems.HAZMAT_BOOTS);
        this.trimmedArmorItem(ModItems.STARMETAL_HELMET);
        this.trimmedArmorItem(ModItems.STARMETAL_CHESTPLATE);
        this.trimmedArmorItem(ModItems.STARMETAL_LEGGINGS);
        this.trimmedArmorItem(ModItems.STARMETAL_BOOTS);
        this.trimmedArmorItem(ModItems.COBALT_HELMET);
        this.trimmedArmorItem(ModItems.COBALT_CHESTPLATE);
        this.trimmedArmorItem(ModItems.COBALT_LEGGINGS);
        this.trimmedArmorItem(ModItems.COBALT_BOOTS);
        this.evenSimplerBlockItem(ModBlocks.REINFORCED_STONE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.REINFORCED_STONE_SLAB);
        this.evenSimplerBlockItem(ModBlocks.CONCRETE_HAZARD_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.CONCRETE_HAZARD_SLAB);
        this.simpleBlockItem(ModBlocks.DOOR_BUNKER);
        this.simpleBlockItem(ModBlocks.DOOR_OFFICE);
        this.simpleBlockItem(ModBlocks.METAL_DOOR);
        this.simpleItem(ModItems.GRENADEHE);
        this.simpleItem(ModItems.GRENADEFIRE);
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "hbm_m";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.entrySet().forEach(entry -> {
                ResourceKey trimMaterial = (ResourceKey)entry.getKey();
                float trimValue = ((Float)entry.getValue()).floatValue();
                String armorType = switch (armorItem.m_40402_()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = "item/" + String.valueOf(armorItem);
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_();
                String currentTrimName = armorItemPath + "_" + trimMaterial.m_135782_().m_135815_() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.parse((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc)).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().m_135815_(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc)).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)("item/" + itemRegistryObject.getId().m_135815_())));
            });
        }
    }

    public void evenSimplerBlockItem(RegistryObject<Block> block) {
        this.withExistingParent("hbm_m:" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_()));
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)("item/" + item.getId().m_135815_())));
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("hbm_m", "item/" + item.getId().m_135815_()));
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265905_, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266000_, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265896_, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265870_, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265969_, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265937_, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266071_, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266027_, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265981_, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, Float.valueOf(1.0f));
    }
}

