/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.item;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ModShovelItem
extends ShovelItem {
    private static final String NBT_VEIN_MINER = "VeinMinerEnabled";
    private static final String NBT_SILK_TOUCH = "SilkTouchEnabled";
    private static final String NBT_FORTUNE = "FortuneEnabled";
    private static final Set<Block> EXCLUDED_BLOCKS = Set.of(Blocks.f_50069_, Blocks.f_50334_, Blocks.f_50228_, Blocks.f_50122_, Blocks.f_152550_, Blocks.f_50134_, Blocks.f_50259_, Blocks.f_50652_);
    private final int veinMinerLevel;
    private final int silkTouchLevel;
    private final int fortuneLevel;

    public ModShovelItem(Tier tier, int attackDamage, float attackSpeed, Item.Properties properties, int veinMinerLevel, int silkTouchLevel, int fortuneLevel) {
        super(tier, (float)attackDamage, attackSpeed, properties);
        this.veinMinerLevel = Math.max(0, Math.min(6, veinMinerLevel));
        this.silkTouchLevel = Math.max(0, Math.min(1, silkTouchLevel));
        this.fortuneLevel = Math.max(0, Math.min(5, fortuneLevel));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        ChatFormatting color;
        boolean isActive;
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.abilities").m_130940_(ChatFormatting.BLUE));
        if (this.veinMinerLevel > 0) {
            isActive = this.isVeinMinerEnabled(stack);
            color = isActive ? ChatFormatting.YELLOW : ChatFormatting.GOLD;
            tooltip.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237110_((String)"tooltip.hbm_m.vein_miner", (Object[])new Object[]{this.veinMinerLevel}).m_130940_(color)));
        }
        if (this.silkTouchLevel > 0) {
            isActive = this.isSilkTouchEnabled(stack);
            color = isActive ? ChatFormatting.YELLOW : ChatFormatting.GOLD;
            tooltip.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"tooltip.hbm_m.silk_touch").m_130940_(color)));
        }
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.right_click").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.shift_right_click").m_130940_(ChatFormatting.GRAY));
    }

    public boolean m_5812_(ItemStack stack) {
        return this.isVeinMinerEnabled(stack) || this.isSilkTouchEnabled(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_()) {
            if (player.m_6144_()) {
                this.disableAllAbilities(stack, player);
            } else {
                this.cycleAbilities(stack, player);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private void cycleAbilities(ItemStack stack, Player player) {
        boolean anyActive;
        boolean bl = anyActive = this.isVeinMinerEnabled(stack) || this.isSilkTouchEnabled(stack);
        if (!anyActive) {
            if (this.veinMinerLevel > 0) {
                this.toggleVeinMiner(stack, player, true);
            } else if (this.silkTouchLevel > 0) {
                this.toggleSilkTouch(stack, player, true);
            }
        } else if (this.isVeinMinerEnabled(stack)) {
            this.toggleVeinMiner(stack, player, false);
            if (this.silkTouchLevel > 0) {
                this.toggleSilkTouch(stack, player, true);
            } else {
                this.disableAllAbilities(stack, player);
            }
        } else if (this.isSilkTouchEnabled(stack)) {
            this.disableAllAbilities(stack, player);
        }
    }

    private void disableAllAbilities(ItemStack stack, Player player) {
        stack.m_41784_().m_128379_(NBT_VEIN_MINER, false);
        stack.m_41784_().m_128379_(NBT_SILK_TOUCH, false);
        this.removeAllEnchantments(stack);
        this.playToggleSound(player, false);
        player.m_5661_((Component)Component.m_237115_((String)"message.hbm_m.disabled").m_130940_(ChatFormatting.RED), true);
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        boolean result = super.m_6813_(stack, level, state, pos, entity);
        if (level.m_5776_()) {
            return result;
        }
        Block minedBlock = state.m_60734_();
        if (this.veinMinerLevel > 0 && this.isVeinMinerEnabled(stack) && !EXCLUDED_BLOCKS.contains(minedBlock)) {
            int radius = 2 + this.veinMinerLevel;
            this.veinMine(level, pos, minedBlock, stack, entity, radius);
        }
        return result;
    }

    private void toggleVeinMiner(ItemStack stack, Player player, boolean enable) {
        stack.m_41784_().m_128379_(NBT_VEIN_MINER, enable);
        if (enable) {
            stack.m_41784_().m_128379_(NBT_SILK_TOUCH, false);
            this.removeAllEnchantments(stack);
        }
        this.playToggleSound(player, enable);
        player.m_5661_((Component)Component.m_237110_((String)(enable ? "message.hbm_m.vein_miner.enabled" : "message.hbm_m.vein_miner.disabled"), (Object[])new Object[]{this.veinMinerLevel}).m_130940_(enable ? ChatFormatting.YELLOW : ChatFormatting.RED), true);
    }

    private void toggleSilkTouch(ItemStack stack, Player player, boolean enable) {
        stack.m_41784_().m_128379_(NBT_SILK_TOUCH, enable);
        if (enable) {
            stack.m_41784_().m_128379_(NBT_VEIN_MINER, false);
            this.removeAllEnchantments(stack);
            stack.m_41663_(Enchantments.f_44985_, 1);
        } else {
            this.removeAllEnchantments(stack);
        }
        this.playToggleSound(player, enable);
        player.m_5661_((Component)Component.m_237115_((String)(enable ? "message.hbm_m.silk_touch.enabled" : "message.hbm_m.silk_touch.disabled")).m_130940_(enable ? ChatFormatting.YELLOW : ChatFormatting.RED), true);
    }

    private void removeAllEnchantments(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Enchantments")) {
            stack.m_41783_().m_128473_("Enchantments");
        }
    }

    private void playToggleSound(Player player, boolean enable) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.7f, enable ? 1.2f : 0.8f);
    }

    private boolean isVeinMinerEnabled(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_(NBT_VEIN_MINER);
    }

    private boolean isSilkTouchEnabled(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_(NBT_SILK_TOUCH);
    }

    private void veinMine(Level level, BlockPos startPos, Block targetBlock, ItemStack stack, LivingEntity entity, int radius) {
        int maxBlocks;
        Player player;
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        HashSet<BlockPos> toMine = new HashSet<BlockPos>();
        toCheck.add(startPos);
        visited.add(startPos);
        boolean isCreative = entity instanceof Player && (player = (Player)entity).m_7500_();
        int n = maxBlocks = isCreative ? 512 : 64;
        while (!toCheck.isEmpty() && toMine.size() < maxBlocks) {
            BlockPos current = (BlockPos)toCheck.poll();
            for (BlockPos neighbor : this.getNeighbors(current, startPos, radius)) {
                if (visited.contains(neighbor)) continue;
                visited.add(neighbor);
                BlockState neighborState = level.m_8055_(neighbor);
                Block neighborBlock = neighborState.m_60734_();
                if (neighborBlock != targetBlock) continue;
                toMine.add(neighbor);
                toCheck.add(neighbor);
            }
        }
        for (BlockPos pos : toMine) {
            this.mineBlockWithSilkTouch(level, pos, stack, entity);
            if (isCreative || !stack.m_41619_()) continue;
            break;
        }
    }

    private Set<BlockPos> getNeighbors(BlockPos pos, BlockPos startPos, int radius) {
        BlockPos[] directions;
        HashSet<BlockPos> neighbors = new HashSet<BlockPos>();
        for (BlockPos neighbor : directions = new BlockPos[]{pos.m_7494_(), pos.m_7495_(), pos.m_122012_(), pos.m_122019_(), pos.m_122024_(), pos.m_122029_()}) {
            if (neighbor.m_123333_((Vec3i)startPos) > radius) continue;
            neighbors.add(neighbor);
        }
        return neighbors;
    }

    private void mineBlockWithSilkTouch(Level level, BlockPos pos, ItemStack stack, LivingEntity entity) {
        Player player;
        BlockState blockState = level.m_8055_(pos);
        if (!stack.m_41735_(blockState)) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block.m_49881_((BlockState)blockState, (Level)level, (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)entity, (ItemStack)stack);
            level.m_7471_(pos, false);
        }
        if (!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) {
            stack.m_41622_(1, entity, e -> e.m_21190_(InteractionHand.MAIN_HAND));
        }
    }
}

