/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.main;

import com.hbm_m.armormod.item.ItemArmorMod;
import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.capability.ChunkRadiationProvider;
import com.hbm_m.client.ClientSetup;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.effect.ModEffects;
import com.hbm_m.entity.ModEntities;
import com.hbm_m.hazard.ModHazards;
import com.hbm_m.item.ItemAssemblyTemplate;
import com.hbm_m.item.ItemBlueprintFolder;
import com.hbm_m.item.ModItems;
import com.hbm_m.main.ModCreativeTabs;
import com.hbm_m.menu.ModMenuTypes;
import com.hbm_m.network.ModPacketHandler;
import com.hbm_m.particle.ModParticleTypes;
import com.hbm_m.radiation.ChunkRadiationManager;
import com.hbm_m.radiation.PlayerRadiationHandler;
import com.hbm_m.recipe.AssemblerRecipe;
import com.hbm_m.recipe.ModRecipes;
import com.hbm_m.sound.ModSounds;
import com.hbm_m.worldgen.ModWorldGen;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hbm_m")
public class MainRegistry {
    public static final Logger LOGGER = LogManager.getLogger((String)"hbm_m");
    public static final String MOD_ID = "hbm_m";

    public MainRegistry(FMLJavaModLoadingContext context) {
        LOGGER.info("Initializing Hbm's Nuclear Tech Mod Modernized");
        IEventBus modEventBus = context.getModEventBus();
        ModBlocks.BLOCKS.register(modEventBus);
        ModEntities.ENTITY_TYPES.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModMenuTypes.MENUS.register(modEventBus);
        ModCreativeTabs.CREATIVE_MODE_TABS.register(modEventBus);
        ModSounds.SOUND_EVENTS.register(modEventBus);
        ModParticleTypes.PARTICLES.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModWorldGen.BIOME_MODIFIERS.register(modEventBus);
        ModEffects.register(modEventBus);
        ModRecipes.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::addCreative);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)ChunkRadiationManager.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerRadiationHandler());
        new ClientSetup();
        LOGGER.info("Radiation handlers registered. Using {}.", (Object)(ModClothConfig.get().usePrismSystem ? "ChunkRadiationHandlerPRISM" : "ChunkRadiationHandlerSimple"));
        LOGGER.info("Registered event listeners for Radiation System.");
        LOGGER.info("!!! MainRegistry: ClientSetup instance created, its Forge listeners should now be registered !!!");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModPacketHandler.register();
            ModHazards.registerHazards();
            LOGGER.info("HazardSystem initialized successfully");
        });
    }

    @SubscribeEvent
    public void onAttachCapabilitiesChunk(AttachCapabilitiesEvent<LevelChunk> event) {
        ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"chunk_radiation");
        if (!event.getCapabilities().containsKey(key)) {
            ChunkRadiationProvider provider = new ChunkRadiationProvider();
            event.addCapability(key, (ICapabilityProvider)provider);
            event.addListener(() -> ((LazyOptional)provider.getCapability(ChunkRadiationProvider.CHUNK_RADIATION_CAPABILITY)).invalidate());
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        LOGGER.info("Building creative tab contents for: " + String.valueOf(event.getTabKey()));
        if (event.getTab() == ModCreativeTabs.NTM_WEAPONS_TAB.get()) {
            event.accept(ModItems.GRENADE);
            event.accept(ModItems.GRENADEHE);
            event.accept(ModItems.GRENADEFIRE);
            event.accept(ModItems.GRENADESMART);
            event.accept(ModItems.GRENADESLIME);
            event.accept(ModItems.GRENADEIF);
            event.accept(ModBlocks.DET_MINER);
            event.accept(ModBlocks.EXPLOSIVE_CHARGE);
            if (ModClothConfig.get().enableDebugLogging) {
                LOGGER.info("Added Alloy Sword to NTM Weapons tab");
            }
        }
        if (event.getTabKey() == CreativeModeTabs.f_256797_) {
            event.accept(ModItems.ALLOY_SWORD);
            event.accept(ModItems.ALLOY_AXE);
            event.accept(ModItems.ALLOY_PICKAXE);
            event.accept(ModItems.ALLOY_HOE);
            event.accept(ModItems.ALLOY_SHOVEL);
            event.accept(ModItems.STEEL_SWORD);
            event.accept(ModItems.STEEL_AXE);
            event.accept(ModItems.STEEL_PICKAXE);
            event.accept(ModItems.STEEL_HOE);
            event.accept(ModItems.STEEL_SHOVEL);
            event.accept(ModItems.TITANIUM_SWORD);
            event.accept(ModItems.TITANIUM_AXE);
            event.accept(ModItems.TITANIUM_PICKAXE);
            event.accept(ModItems.TITANIUM_HOE);
            event.accept(ModItems.TITANIUM_SHOVEL);
            event.accept(ModItems.STARMETAL_SWORD);
            event.accept(ModItems.STARMETAL_AXE);
            event.accept(ModItems.STARMETAL_PICKAXE);
            event.accept(ModItems.STARMETAL_HOE);
            event.accept(ModItems.STARMETAL_SHOVEL);
            event.accept(ModItems.ALLOY_HELMET);
            event.accept(ModItems.ALLOY_CHESTPLATE);
            event.accept(ModItems.ALLOY_LEGGINGS);
            event.accept(ModItems.ALLOY_BOOTS);
            event.accept(ModItems.COBALT_HELMET);
            event.accept(ModItems.COBALT_CHESTPLATE);
            event.accept(ModItems.COBALT_LEGGINGS);
            event.accept(ModItems.COBALT_BOOTS);
            event.accept(ModItems.TITANIUM_HELMET);
            event.accept(ModItems.TITANIUM_CHESTPLATE);
            event.accept(ModItems.TITANIUM_LEGGINGS);
            event.accept(ModItems.TITANIUM_BOOTS);
            event.accept(ModItems.SECURITY_HELMET);
            event.accept(ModItems.SECURITY_CHESTPLATE);
            event.accept(ModItems.SECURITY_LEGGINGS);
            event.accept(ModItems.SECURITY_BOOTS);
            event.accept(ModItems.AJR_HELMET);
            event.accept(ModItems.AJR_CHESTPLATE);
            event.accept(ModItems.AJR_LEGGINGS);
            event.accept(ModItems.AJR_BOOTS);
            event.accept(ModItems.STEEL_HELMET);
            event.accept(ModItems.STEEL_CHESTPLATE);
            event.accept(ModItems.STEEL_LEGGINGS);
            event.accept(ModItems.STEEL_BOOTS);
            event.accept(ModItems.ASBESTOS_HELMET);
            event.accept(ModItems.ASBESTOS_CHESTPLATE);
            event.accept(ModItems.ASBESTOS_LEGGINGS);
            event.accept(ModItems.ASBESTOS_BOOTS);
            event.accept(ModItems.HAZMAT_HELMET);
            event.accept(ModItems.HAZMAT_CHESTPLATE);
            event.accept(ModItems.HAZMAT_LEGGINGS);
            event.accept(ModItems.HAZMAT_BOOTS);
            event.accept(ModItems.LIQUIDATOR_HELMET);
            event.accept(ModItems.LIQUIDATOR_CHESTPLATE);
            event.accept(ModItems.LIQUIDATOR_LEGGINGS);
            event.accept(ModItems.LIQUIDATOR_BOOTS);
            event.accept(ModItems.PAA_HELMET);
            event.accept(ModItems.PAA_CHESTPLATE);
            event.accept(ModItems.PAA_LEGGINGS);
            event.accept(ModItems.PAA_BOOTS);
            event.accept(ModItems.STARMETAL_HELMET);
            event.accept(ModItems.STARMETAL_CHESTPLATE);
            event.accept(ModItems.STARMETAL_LEGGINGS);
            event.accept(ModItems.STARMETAL_BOOTS);
            if (ModClothConfig.get().enableDebugLogging) {
                LOGGER.info("Added Alloy Sword to vanilla Combat tab");
            }
        }
        if (event.getTab() == ModCreativeTabs.NTM_RESOURCES_TAB.get()) {
            for (RegistryObject<Item> registryObject : ModItems.INGOTS.values()) {
                event.m_246326_((ItemLike)registryObject.get());
                if (!ModClothConfig.get().enableDebugLogging) continue;
                LOGGER.info("Added {} to NTM Resources tab", registryObject.get());
            }
            event.accept(ModItems.CINNABAR);
            event.accept(ModItems.FIRECLAY_BALL);
            event.accept(ModItems.SULFUR);
            event.accept(ModItems.FLUORITE);
            event.accept(ModItems.RAREGROUND_ORE_CHUNK);
            event.accept(ModItems.CINNABAR);
            event.accept(ModItems.FIRECLAY_BALL);
            event.accept(ModItems.FIREBRICK);
            event.accept(ModItems.WOOD_ASH_POWDER);
        }
        if (event.getTab() == ModCreativeTabs.NTM_CONSUMABLES_TAB.get()) {
            List allModItems = ForgeRegistries.ITEMS.getEntries().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals(MOD_ID)).map(entry -> RegistryObject.create((ResourceLocation)((ResourceKey)entry.getKey()).m_135782_(), (IForgeRegistry)ForgeRegistries.ITEMS)).collect(Collectors.toList());
            for (RegistryObject itemObject : allModItems) {
                Item item = (Item)itemObject.get();
                if (!(item instanceof ItemArmorMod)) continue;
                event.m_246326_((ItemLike)item);
                if (!ModClothConfig.get().enableDebugLogging) continue;
                LOGGER.info("Automatically added Armor Mod [{}] to NTM Consumables tab", (Object)itemObject.getId());
            }
            event.accept(ModItems.RADAWAY);
        }
        if (event.getTab() == ModCreativeTabs.NTM_SPAREPARTS_TAB.get()) {
            event.accept(ModItems.PLATE_IRON);
            event.accept(ModItems.PLATE_STEEL);
            event.accept(ModItems.PLATE_GOLD);
            event.accept(ModItems.PLATE_GUNMETAL);
            event.accept(ModItems.PLATE_GUNSTEEL);
            event.accept(ModItems.PLATE_TITANIUM);
            event.accept(ModItems.PLATE_KEVLAR);
            event.accept(ModItems.PLATE_LEAD);
            event.accept(ModItems.PLATE_MIXED);
            event.accept(ModItems.PLATE_PAA);
            event.accept(ModItems.PLATE_SATURNITE);
            event.accept(ModItems.PLATE_SCHRABIDIUM);
            event.accept(ModItems.PLATE_ADVANCED_ALLOY);
            event.accept(ModItems.PLATE_ALUMINUM);
            event.accept(ModItems.PLATE_COPPER);
            event.accept(ModItems.PLATE_BISMUTH);
            event.accept(ModItems.PLATE_ARMOR_AJR);
            event.accept(ModItems.PLATE_ARMOR_DNT);
            event.accept(ModItems.PLATE_ARMOR_DNT_RUSTED);
            event.accept(ModItems.PLATE_ARMOR_FAU);
            event.accept(ModItems.PLATE_ARMOR_HEV);
            event.accept(ModItems.PLATE_ARMOR_LUNAR);
            event.accept(ModItems.PLATE_ARMOR_TITANIUM);
            event.accept(ModItems.PLATE_CAST);
            event.accept(ModItems.PLATE_CAST_ALT);
            event.accept(ModItems.PLATE_CAST_BISMUTH);
            event.accept(ModItems.PLATE_CAST_DARK);
            event.accept(ModItems.PLATE_COMBINE_STEEL);
            event.accept(ModItems.PLATE_DURA_STEEL);
            event.accept(ModItems.PLATE_DALEKANIUM);
            event.accept(ModItems.PLATE_DESH);
            event.accept(ModItems.PLATE_DINEUTRONIUM);
            event.accept(ModItems.PLATE_EUPHEMIUM);
            event.accept(ModItems.WIRE_RED_COPPER);
            event.accept(ModItems.WIRE_COPPER);
            event.accept(ModItems.WIRE_TUNGSTEN);
            event.accept(ModItems.WIRE_GOLD);
            event.accept(ModItems.WIRE_ALUMINIUM);
            event.accept(ModItems.WIRE_MAGNETIZED_TUNGSTEN);
            event.accept(ModItems.WIRE_SCHRABIDIUM);
            event.accept(ModItems.WIRE_FINE);
            event.accept(ModItems.WIRE_CARBON);
            event.accept(ModItems.WIRE_ADVANCED_ALLOY);
            event.accept(ModItems.NUGGET_SILICON);
            event.accept(ModItems.BILLET_SILICON);
            event.accept(ModItems.INSULATOR);
            event.accept(ModItems.SILICON_CIRCUIT);
            event.accept(ModItems.CONTROLLER_ADVANCED);
            event.accept(ModItems.CONTROLLER_CHASSIS);
            event.accept(ModItems.CONTROLLER);
            event.accept(ModItems.CAPACITOR_TANTALUM);
            event.accept(ModItems.CAPACITOR_BOARD);
            event.accept(ModItems.QUANTUM_CIRCUIT);
            event.accept(ModItems.QUANTUM_COMPUTER);
            event.accept(ModItems.QUANTUM_CHIP);
            event.accept(ModItems.BISMOID_CHIP);
            event.accept(ModItems.BISMOID_CIRCUIT);
            event.accept(ModItems.PCB);
            event.accept(ModItems.VACUUM_TUBE);
            event.accept(ModItems.CAPACITOR);
            event.accept(ModItems.MICROCHIP);
            event.accept(ModItems.ANALOG_CIRCUIT);
            event.accept(ModItems.INTEGRATED_CIRCUIT);
            event.accept(ModItems.ADVANCED_CIRCUIT);
            event.accept(ModItems.ATOMIC_CLOCK);
            event.accept(ModItems.BATTLE_GEARS);
            event.accept(ModItems.BATTLE_SENSOR);
            event.accept(ModItems.BATTLE_CASING);
            event.accept(ModItems.BATTLE_COUNTER);
            event.accept(ModItems.BATTLE_MODULE);
            event.accept(ModItems.METAL_ROD);
            event.accept(ModItems.PLATE_ARMOR_AJR);
            event.accept(ModItems.PLATE_ARMOR_DNT);
            event.accept(ModItems.PLATE_ARMOR_DNT_RUSTED);
            event.accept(ModItems.PLATE_ARMOR_FAU);
            event.accept(ModItems.PLATE_ARMOR_HEV);
            event.accept(ModItems.PLATE_ARMOR_LUNAR);
            event.accept(ModItems.PLATE_ARMOR_TITANIUM);
            event.accept(ModItems.PLATE_DALEKANIUM);
            event.accept(ModItems.PLATE_DESH);
            event.accept(ModItems.PLATE_DINEUTRONIUM);
            event.accept(ModItems.PLATE_EUPHEMIUM);
            event.accept(ModItems.PLATE_COMBINE_STEEL);
            event.accept(ModItems.PLATE_BISMUTH);
            event.accept(ModItems.PLATE_MIXED);
            event.accept(ModItems.PLATE_IRON);
            event.accept(ModItems.PLATE_STEEL);
            event.accept(ModItems.PLATE_GOLD);
            event.accept(ModItems.PLATE_GUNMETAL);
            event.accept(ModItems.PLATE_GUNSTEEL);
            event.accept(ModItems.PLATE_TITANIUM);
            event.accept(ModItems.PLATE_KEVLAR);
            event.accept(ModItems.PLATE_LEAD);
            event.accept(ModItems.PLATE_PAA);
            event.accept(ModItems.PLATE_SATURNITE);
            event.accept(ModItems.PLATE_SCHRABIDIUM);
            event.accept(ModItems.PLATE_ADVANCED_ALLOY);
            event.accept(ModItems.PLATE_ALUMINUM);
            event.accept(ModItems.PLATE_COPPER);
            event.accept(ModItems.PLATE_DURA_STEEL);
            event.accept(ModItems.PLATE_CAST);
            event.accept(ModItems.PLATE_CAST_ALT);
            event.accept(ModItems.PLATE_CAST_BISMUTH);
            event.accept(ModItems.PLATE_CAST_DARK);
        }
        if (event.getTab() == ModCreativeTabs.NTM_ORES_TAB.get()) {
            event.accept(ModBlocks.URANIUM_BLOCK);
            event.accept(ModBlocks.POLONIUM210_BLOCK);
            event.accept(ModBlocks.PLUTONIUM_BLOCK);
            event.accept(ModBlocks.PLUTONIUM_FUEL_BLOCK);
            event.accept(ModBlocks.URANIUM_ORE);
            event.accept(ModBlocks.WASTE_GRASS);
            event.accept(ModBlocks.WASTE_LEAVES);
            event.accept(ModBlocks.ALUMINUM_ORE);
            event.accept(ModBlocks.ALUMINUM_ORE_DEEPSLATE);
            event.accept(ModBlocks.LIGNITE_ORE);
            event.accept(ModBlocks.TITANIUM_ORE);
            event.accept(ModBlocks.TITANIUM_ORE_DEEPSLATE);
            event.accept(ModBlocks.TUNGSTEN_ORE);
            event.accept(ModBlocks.ASBESTOS_ORE);
            event.accept(ModBlocks.SULFUR_ORE);
            event.accept(ModBlocks.COBALT_ORE);
            event.accept(ModBlocks.URANIUM_ORE_H);
            event.accept(ModBlocks.URANIUM_ORE_DEEPSLATE);
            event.accept(ModBlocks.THORIUM_ORE);
            event.accept(ModBlocks.THORIUM_ORE_DEEPSLATE);
            event.accept(ModBlocks.RAREGROUND_ORE);
            event.accept(ModBlocks.RAREGROUND_ORE_DEEPSLATE);
            event.accept(ModBlocks.BERYLLIUM_ORE);
            event.accept(ModBlocks.BERYLLIUM_ORE_DEEPSLATE);
            event.accept(ModBlocks.FLUORITE_ORE);
            event.accept(ModBlocks.LEAD_ORE);
            event.accept(ModBlocks.LEAD_ORE_DEEPSLATE);
            event.accept(ModBlocks.COBALT_ORE_DEEPSLATE);
            event.accept(ModBlocks.CINNABAR_ORE_DEEPSLATE);
            event.accept(ModBlocks.CINNABAR_ORE);
            event.accept(ModItems.ALUMINUM_RAW);
            event.accept(ModItems.BERYLLIUM_RAW);
            event.accept(ModItems.COBALT_RAW);
            event.accept(ModItems.LEAD_RAW);
            event.accept(ModItems.THORIUM_RAW);
            event.accept(ModItems.TITANIUM_RAW);
            event.accept(ModItems.TUNGSTEN_RAW);
            event.accept(ModItems.URANIUM_RAW);
            event.accept(ModItems.STRAWBERRY);
            event.accept(ModBlocks.STRAWBERRY_BUSH);
            if (ModClothConfig.get().enableDebugLogging) {
                LOGGER.info("Added uranium block to NTM Resources tab");
                LOGGER.info("Added polonium210 block to NTM Resources tab");
                LOGGER.info("Added plutonium block to NTM Resources tab");
                LOGGER.info("Added plutonium fuel block to NTM Resources tab");
                LOGGER.info("Added uranium ore to NTM Resources tab");
                LOGGER.info("Added waste leaves block to NTM Resources tab");
                LOGGER.info("Added waste grass block to NTM Resources tab");
            }
        }
        if (event.getTab() == ModCreativeTabs.NTM_BUILDING_TAB.get()) {
            event.accept(ModBlocks.DOOR_OFFICE);
            event.accept(ModBlocks.DOOR_BUNKER);
            event.accept(ModBlocks.METAL_DOOR);
            event.accept(ModBlocks.CONCRETE_MARKED);
            event.accept(ModBlocks.CONCRETE_VENT);
            event.accept(ModBlocks.CONCRETE_FAN);
            event.accept(ModBlocks.CONCRETE_CRACKED_STAIRS);
            event.accept(ModBlocks.CONCRETE_CRACKED_SLAB);
            event.accept(ModBlocks.CONCRETE_CRACKED);
            event.accept(ModBlocks.CONCRETE_MOSSY_STAIRS);
            event.accept(ModBlocks.CONCRETE_MOSSY_SLAB);
            event.accept(ModBlocks.CONCRETE_MOSSY);
            event.accept(ModBlocks.CONCRETE_STAIRS);
            event.accept(ModBlocks.CONCRETE_SLAB);
            event.accept(ModBlocks.CONCRETE);
            event.accept(ModBlocks.CRATE);
            event.accept(ModBlocks.CRATE_LEAD);
            event.accept(ModBlocks.CRATE_METAL);
            event.accept(ModBlocks.CRATE_WEAPON);
            event.accept(ModBlocks.REINFORCED_STONE);
            event.accept(ModBlocks.REINFORCED_GLASS);
            event.accept(ModBlocks.REINFORCED_STONE_SLAB);
            event.accept(ModBlocks.REINFORCED_STONE_STAIRS);
            event.accept(ModBlocks.CONCRETE_HAZARD);
            event.accept(ModBlocks.CONCRETE_HAZARD_SLAB);
            event.accept(ModBlocks.CONCRETE_HAZARD_STAIRS);
            event.accept(ModBlocks.BRICK_CONCRETE);
            event.accept(ModBlocks.BRICK_CONCRETE_SLAB);
            event.accept(ModBlocks.BRICK_CONCRETE_STAIRS);
            event.accept(ModBlocks.BRICK_CONCRETE_BROKEN);
            event.accept(ModBlocks.BRICK_CONCRETE_BROKEN_SLAB);
            event.accept(ModBlocks.BRICK_CONCRETE_BROKEN_STAIRS);
            event.accept(ModBlocks.BRICK_CONCRETE_CRACKED);
            event.accept(ModBlocks.BRICK_CONCRETE_CRACKED_SLAB);
            event.accept(ModBlocks.BRICK_CONCRETE_CRACKED_STAIRS);
            event.accept(ModBlocks.BRICK_CONCRETE_MOSSY);
            event.accept(ModBlocks.BRICK_CONCRETE_MOSSY_SLAB);
            event.accept(ModBlocks.BRICK_CONCRETE_MOSSY_STAIRS);
            event.accept(ModBlocks.BRICK_CONCRETE_MARKED);
            event.accept(ModBlocks.LARGE_VEHICLE_DOOR);
            event.accept(ModBlocks.FREAKY_ALIEN_BLOCK);
            if (ModClothConfig.get().enableDebugLogging) {
                LOGGER.info("Added concrete hazard to NTM Resources tab");
            }
        }
        if (event.getTab() == ModCreativeTabs.NTM_INSTRUMENTS_TAB.get()) {
            event.accept(ModItems.DOSIMETER);
            event.accept(ModItems.GEIGER_COUNTER);
        }
        if (event.getTab() == ModCreativeTabs.NTM_MACHINES_TAB.get()) {
            event.accept(ModBlocks.GEIGER_COUNTER_BLOCK);
            event.accept(ModBlocks.PRESS);
            event.accept(ModBlocks.BLAST_FURNACE);
            event.accept(ModBlocks.SHREDDER);
            event.accept(ModBlocks.WOOD_BURNER);
            event.accept(ModBlocks.MACHINE_ASSEMBLER);
            event.accept(ModBlocks.ADVANCED_ASSEMBLY_MACHINE);
            event.accept(ModBlocks.ARMOR_TABLE);
            event.accept(ModBlocks.MACHINE_BATTERY);
            event.accept(ModBlocks.WIRE_COATED);
            if (ModClothConfig.get().enableDebugLogging) {
                LOGGER.info("Added geiger counter BLOCK to NTM Machines tab");
                LOGGER.info("Added assembly machine BLOCK to NTM Machines tab");
                LOGGER.info("Added advanced assembly machine BLOCK to NTM Machines tab");
                LOGGER.info("Added battery machine BLOCK to NTM Machines tab");
                LOGGER.info("Added wire coated BLOCK to NTM Machines tab");
            }
        }
        if (event.getTab() == ModCreativeTabs.NTM_FUEL_TAB.get()) {
            event.accept(ModItems.LIGNITE);
            event.accept(ModItems.PLATE_FUEL_MOX);
            event.accept(ModItems.PLATE_FUEL_PU238BE);
            event.accept(ModItems.PLATE_FUEL_PU239);
            event.accept(ModItems.PLATE_FUEL_RA226BE);
            event.accept(ModItems.PLATE_FUEL_SA326);
            event.accept(ModItems.PLATE_FUEL_U233);
            event.accept(ModItems.PLATE_FUEL_U235);
            event.accept(ModItems.CREATIVE_BATTERY);
            if (ModClothConfig.get().enableDebugLogging) {
                LOGGER.info("Added creative battery ITEM to NTM Fuel tab");
            }
        }
        if (event.getTab() == ModCreativeTabs.NTM_TEMPLATES_TAB.get()) {
            event.accept(ModItems.TEMPLATE_FOLDER);
            if (Minecraft.m_91087_().f_91073_ != null) {
                RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
                List list = recipeManager.m_44013_((RecipeType)AssemblerRecipe.Type.INSTANCE);
                HashSet<String> blueprintPools = new HashSet<String>();
                for (AssemblerRecipe recipe : list) {
                    String pool = recipe.getBlueprintPool();
                    if (pool == null || pool.isEmpty()) continue;
                    blueprintPools.add(pool);
                }
                for (String pool : blueprintPools) {
                    ItemStack folderStack = new ItemStack((ItemLike)ModItems.BLUEPRINT_FOLDER.get());
                    ItemBlueprintFolder.writeBlueprintPool(folderStack, pool);
                    event.m_246342_(folderStack);
                }
                if (ModClothConfig.get().enableDebugLogging) {
                    LOGGER.info("Added {} blueprint folders to NTM Templates tab", (Object)blueprintPools.size());
                }
                event.accept(ModItems.STAMP_STONE_FLAT);
                event.accept(ModItems.STAMP_STONE_PLATE);
                event.accept(ModItems.STAMP_STONE_WIRE);
                event.accept(ModItems.STAMP_STONE_CIRCUIT);
                event.accept(ModItems.STAMP_IRON_FLAT);
                event.accept(ModItems.STAMP_IRON_PLATE);
                event.accept(ModItems.STAMP_IRON_WIRE);
                event.accept(ModItems.STAMP_IRON_CIRCUIT);
                event.accept(ModItems.STAMP_IRON_9);
                event.accept(ModItems.STAMP_IRON_44);
                event.accept(ModItems.STAMP_IRON_50);
                event.accept(ModItems.STAMP_IRON_357);
                event.accept(ModItems.STAMP_STEEL_FLAT);
                event.accept(ModItems.STAMP_STEEL_PLATE);
                event.accept(ModItems.STAMP_STEEL_WIRE);
                event.accept(ModItems.STAMP_STEEL_CIRCUIT);
                event.accept(ModItems.STAMP_TITANIUM_FLAT);
                event.accept(ModItems.STAMP_TITANIUM_PLATE);
                event.accept(ModItems.STAMP_TITANIUM_WIRE);
                event.accept(ModItems.STAMP_TITANIUM_FLAT);
                event.accept(ModItems.STAMP_TITANIUM_PLATE);
                event.accept(ModItems.STAMP_TITANIUM_WIRE);
                event.accept(ModItems.STAMP_TITANIUM_CIRCUIT);
                event.accept(ModItems.STAMP_OBSIDIAN_FLAT);
                event.accept(ModItems.STAMP_OBSIDIAN_PLATE);
                event.accept(ModItems.STAMP_OBSIDIAN_WIRE);
                event.accept(ModItems.STAMP_OBSIDIAN_CIRCUIT);
                event.accept(ModItems.STAMP_DESH_FLAT);
                event.accept(ModItems.STAMP_DESH_PLATE);
                event.accept(ModItems.STAMP_DESH_WIRE);
                event.accept(ModItems.STAMP_DESH_CIRCUIT);
                event.accept(ModItems.STAMP_DESH_9);
                event.accept(ModItems.STAMP_DESH_44);
                event.accept(ModItems.STAMP_DESH_50);
                event.accept(ModItems.STAMP_DESH_357);
                for (AssemblerRecipe recipe : list) {
                    ItemStack templateStack = new ItemStack((ItemLike)ModItems.ASSEMBLY_TEMPLATE.get());
                    ItemAssemblyTemplate.writeRecipeOutput(templateStack, recipe.m_8043_(null));
                    event.m_246342_(templateStack);
                }
                if (ModClothConfig.get().enableDebugLogging) {
                    LOGGER.info("Added {} templates to NTM Templates tab", (Object)list.size());
                }
            } else if (ModClothConfig.get().enableDebugLogging) {
                LOGGER.warn("Could not populate templates tab: Minecraft level is null.");
            }
        }
    }

    static {
        ModClothConfig.register();
    }
}

