/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.menu;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.MachineBatteryBlockEntity;
import com.hbm_m.menu.ModMenuTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.SlotItemHandler;

public class MachineBatteryMenu
extends AbstractContainerMenu {
    public final MachineBatteryBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int PLAYER_INVENTORY_START_INDEX = 0;
    private static final int PLAYER_INVENTORY_END_INDEX = 36;
    private static final int TE_INPUT_SLOT_INDEX = 36;
    private static final int TE_OUTPUT_SLOT_INDEX = 37;

    public MachineBatteryMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.MACHINE_BATTERY_MENU.get(), pContainerId);
        MachineBatteryMenu.m_38869_((Container)inv, (int)2);
        this.blockEntity = (MachineBatteryBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 26, 17));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 26, 53));
        });
        this.m_38884_(data);
    }

    public MachineBatteryMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(6));
    }

    public int getEnergy() {
        return this.data.m_6413_(0);
    }

    public int getMaxEnergy() {
        return this.data.m_6413_(1);
    }

    public int getEnergyDelta() {
        return this.data.m_6413_(2);
    }

    public int getModeOnNoSignal() {
        return this.data.m_6413_(3);
    }

    public int getModeOnSignal() {
        return this.data.m_6413_(4);
    }

    public int getPriorityOrdinal() {
        return this.data.m_6413_(5);
    }

    public boolean isTransferLocked() {
        return this.data.m_6413_(6) == 1;
    }

    public boolean m_6875_(Player pPlayer) {
        return MachineBatteryMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)ModBlocks.MACHINE_BATTERY.get()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index >= 0 && index < 36) {
            Optional energyCapability = sourceStack.getCapability(ForgeCapabilities.ENERGY).resolve();
            if (!energyCapability.isPresent()) return ItemStack.f_41583_;
            IEnergyStorage itemEnergy = (IEnergyStorage)energyCapability.get();
            boolean moved = false;
            if (itemEnergy.canExtract() && this.m_38903_(sourceStack, 36, 37, false)) {
                moved = true;
            }
            if (!moved && itemEnergy.canReceive() && this.m_38903_(sourceStack, 37, 38, false)) {
                moved = true;
            }
            if (!moved) {
                return ItemStack.f_41583_;
            }
        } else {
            if (index != 36 && index != 37) return ItemStack.f_41583_;
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        }
        if (sourceStack.m_41619_()) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

